/*
 * Copyright 2016 Freescale
 * Copyright 2018,2023 NXP
 * SPDX-License-Identifier: EPL-1.0
 */

package com.nxp.sa.ui.traceviewer.search.epl;

import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import com.nxp.sa.ui.traceviewer.search.epl.TraceViewerGridSearchStrategy.GridRectangle;

public class FindCellGridProgressMonitor extends AbstractFindProgressMonitor implements IRunnableWithProgress {
    
    List<GridRectangle> cellRectangles;
    boolean columnFirst;
    boolean includeCollapsed;
    
    public FindCellGridProgressMonitor(ILayer layer, IConfigRegistry configRegistry,
                               List<GridRectangle> cellRectangles, Pattern pattern,
                               String stringValue, Comparator<String> comparator,
                               boolean caseSensitive, boolean wholeWord, boolean regex,
                               boolean columnFirst, boolean includeCollapsed) {
        this.cellRectangles = cellRectangles;
        this.columnFirst = columnFirst;
        this.includeCollapsed = includeCollapsed;
        super.init(configRegistry, layer, pattern, stringValue, comparator, caseSensitive,
                   wholeWord, regex);
    }
    
    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException,
                                              InterruptedException {
        
        int totalWork = DEFAULT_TOTAL_WORK;
        double progress = 0;   
        
        // Total number of tasks.
        for (GridRectangle cellRectangle : cellRectangles) {
            totalWork += Math.abs(cellRectangle.firstDim.end - cellRectangle.firstDim.start);
        }        
        setTotalWork(totalWork);

        monitor.beginTask("Searching for \"" + getTaskName() + "\"", totalWork); //$NON-NLS-1$ //$NON-NLS-2$

        IProgressMonitor subMonitor = new SubProgressMonitor(monitor, DEFAULT_TOTAL_WORK);
        subMonitor.beginTask("Completed 0 %", DEFAULT_TOTAL_WORK); //$NON-NLS-1$
        
        PositionCoordinate pc = null;
        for (GridRectangle cellRectangle : cellRectangles) {
            int direction = cellRectangle.firstDim.size() > 0
                    || cellRectangle.secondDim.size() > 0 ? 1 : -1;
            for (int i = cellRectangle.firstDim.start; Math.abs(cellRectangle.firstDim.end
                                                                - i) > 0; i += direction) {
                pc = TraceViewerCellDisplayValueSearchUtil.findCell(layer, configRegistry, i,
                                                    cellRectangle.secondDim.start,
                                                    cellRectangle.secondDim.end,
                                                    direction, pattern, stringValue,
                                                    comparator, caseSensitive,
                                                    wholeWord, regex, columnFirst,
                                                    includeCollapsed);
                
                if (monitor.isCanceled()) {
                    setCanceled(true);
                    subMonitor.done();
                    monitor.done();
                    return;
                } else if (pc != null) {
                    setPositionCoordinate(pc);
                    subMonitor.done();
                    monitor.done();
                    return;
                }
                
                monitor.worked(1);
                progress += 1;
                subMonitor.subTask("Completed " + getProgressPercent(progress) + "%"); //$NON-NLS-1$ //$NON-NLS-2$
            }
        }
        
        setFinished(true);
        monitor.done();
        subMonitor.done();
        return;
    }
}
