/*
 * Copyright 2014 Freescale
 * Copyright 2018,2021,2023 NXP
 * SPDX-License-Identifier: EPL-1.0
 */

package com.nxp.sa.ui.traceviewer.search.epl;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import com.freescale.sa.util.Logger;
import com.freescale.sa.util.LoggerStatus;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	private static Logger LOGGER;
	// The plug-in ID
	public static final String PLUGIN_ID = "com.nxp.sa.ui.traceviewer.search.epl"; //$NON-NLS-1$

	// The shared instance
	private static Activator plugin;
	
	/**
	 * The constructor
	 */
	public Activator() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		LOGGER = Logger.getLogger(context.getBundle());
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		LOGGER = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}


	/**
	 * Returns the instance of the logger
	 * 
	 * @since 2.0
	 */

	public Logger getLogger() {
		return LOGGER;
	}
	
	/**
	 * Logs an error message the instance of the logger for the plugin
	 * 
	 * @param msg The error message
	 * @since 2.0
	 */
	public void logError(String msg) {
		LoggerStatus status = getLogger().getErrorStatus(msg);
		getLogger().log(status);
	}
	
	/**
	 * Logs an error message with the exception thrown the instance of the logger for the plugin
	 * 
	 * @param msg The error message
	 * @param t The caught Throwable
	 * @since 2.0
	 */
	public void logError(String msg, Throwable t) {
		LoggerStatus status = getLogger().getErrorStatus(msg, t);
		getLogger().log(status);
	}
	
	/**
	 * Logs an info message the instance of the logger for the plugin
	 * 
	 * @param msg The error message
	 * @since 2.0
	 */
	public void logInfo(String msg) {
		LoggerStatus status = getLogger().getInfoStatus(msg);
		getLogger().log(status);
	}
	
	/**
	 * Logs an info message with the exception thrown the instance of the logger for the plugin
	 * 
	 * @param msg The error message
	 * @param t The caught Throwable
	 * @since 2.0
	 */
	public void logInfo(String msg, Throwable t) {
		LoggerStatus status = getLogger().getInfoStatus(msg, t);
		getLogger().log(status);
	}
	
	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}
}
