/*******************************************************************************
 * Copyright 2023 NXP
 * NXP Confidential and Proprietary. This software is owned or controlled by NXP and may only be
 * used strictly in accordance with the applicable license terms. By expressly
 * accepting such terms or by downloading, installing, activating and/or otherwise
 * using the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 *******************************************************************************/

package com.freescale.system.browser2;

import org.eclipse.cdt.dsf.debug.service.IRunControl.IExecutionDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TasksTreeContentProvider2 extends ContentProviderAutoUpdater2 implements ITreeContentProvider {

	public static class ProcessElement {
		public ProcessInfo2 processInfo;
	}

	public static class ThreadElement {
		public ThreadInfo2 threadInfo;
	}

	/**
	 * Constructor
	 * 
	 * @param viewer
	 *            The viewer we service
	 */
	public TasksTreeContentProvider2(final Viewer viewer) {
		super(viewer);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.
	 * lang.Object)
	 */
	@Override
	public Object[] getElements(Object inputElement) {
		elementsRequested();

		if (inputElement instanceof OSAwarenessData2) {
			OSAwarenessData2 data = (OSAwarenessData2) inputElement;
			final IExecutionDMContext context = data.getContext();
			if (DsfSession.getSession(context.getSessionId()) != null) {
				ThreadSequenceHolder2 threads = data.getLink().getThreadSequenceHolder(context);
				if (threads != null) {
					ThreadElement[] elements = new ThreadElement[threads.getValues().length];
					for (int i = 0; i < elements.length; i++) {
						elements[i] = new ThreadElement();
						elements[i].threadInfo = threads.getValue(i);
					}
					return elements;
				}
			}
		}
		return new Object[0];
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	@Override
	public void dispose() {
		super.dispose();
	}

	/**
	 * This gets called when the active debug context switches to a new process
	 * or element thereof. We don't get called for a switch to a thread/frame
	 * within the same process thanks to filtering in the Tasks section. There's
	 * nothing really for us to do here. We simply assert our assumption that
	 * we're only servicing a single viewer.
	 * 
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
	 *      java.lang.Object, java.lang.Object)
	 */
	@Override
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		// CWExceptionLogger.logAssert(viewer == fViewer,
		// "Input viewer is not the one we're supposed to be exclusively
		// servicing"); //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.
	 * Object)
	 */
	@Override
	public Object[] getChildren(Object parentElement) {
		return new Object[0];
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.
	 * Object)
	 */
	@Override
	public Object getParent(Object element) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.
	 * Object)
	 */
	@Override
	public boolean hasChildren(Object element) {
		return false;
	}

	/** */
	public boolean registerSession(final String sessionID) {
		return setDebugSession(sessionID);
	}
}
