/*******************************************************************************
 * Copyright (c) 2011, 2012 Mentor Graphics and others.
 * Copyright 2023 NXP
 * 
 * SPDX-License-Identifier: EPL-1.0
 *
 * Contributors:
 *     Vladimir Prus (Mentor Graphics) - initial API and implementation
 *
 * Used:
 *     getCommandControlContext method from
 *     org.eclipse.cdt.dsf.gdb.internal.ui.osview.OSResourcesView
 *******************************************************************************/

package com.nxp.sa.v8.launch.ui.epl;

import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService.ICommandControlDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import com.nxp.sa.v8.launch.ui.epl.Activator;

@SuppressWarnings("restriction")
public class LsV8LaunchUtilsEPL {
	public static ICommandControlDMContext getCommandControlContext(Object obj) {
        IDMContext context = null;
        if (obj instanceof IDMVMContext) {
            context = ((IDMVMContext) obj).getDMContext();
        } else if (obj instanceof GdbLaunch) {
            GdbLaunch l = (GdbLaunch) obj;
            final DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(),
                                                                      l.getSession().getId());
            Query<IDMContext> contextQuery = new Query<IDMContext>()
            {
                @Override
                protected void execute(DataRequestMonitor<IDMContext> rm) {
                    ICommandControlService commandControl = tracker.getService(ICommandControlService.class);
                    tracker.dispose();
                    if (commandControl != null) {
                        rm.setData(commandControl.getContext());
                    }
                    rm.done();
                }
            };
            l.getSession().getExecutor().submit(contextQuery);
            try {
                context = contextQuery.get();
            } catch (Exception e) {
                Activator.getDefault().logError(e.getLocalizedMessage());
            }
        }
        return DMContexts.getAncestorOfType(context, ICommandControlDMContext.class);
	}
}
