/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controller;

import com.nxp.swtools.codemanager.CodeManager;
import com.nxp.swtools.codemanager.ICodeGenerator;
import com.nxp.swtools.codemanager.IToolSpecificCodeManager;
import com.nxp.swtools.common.uct.controller.AUctController;
import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.mcu.McuErrorParseStatus;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.BoolSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.EnumSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.IntegerSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.ItemSetting;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.gtm.controller.GtmSpecificCodeManager;
import com.nxp.swtools.gtm.controller.Messages;
import com.nxp.swtools.gtm.controller.constraints.GtmCheckConstraintsRunnable;
import com.nxp.swtools.gtm.controller.constraints.GtmConstraintsDequeContainer;
import com.nxp.swtools.gtm.controller.constraints.GtmConstraintsHandler;
import com.nxp.swtools.gtm.controller.generation.GtmSourceCodeRefreshHandler;
import com.nxp.swtools.gtm.controller.scripting.GtmScriptProfile;
import com.nxp.swtools.gtm.controller.states.GtmIdleConstraintsState;
import com.nxp.swtools.gtm.controller.states.IGtmConstraintsState;
import com.nxp.swtools.gtm.controller.validation.GtmProblem;
import com.nxp.swtools.gtm.controller.validation.GtmProblemsManager;
import com.nxp.swtools.gtm.controller.validation.GtmValidationHandler;
import com.nxp.swtools.gtm.model.mcu.GtmEmptyMcu;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.gtm.model.mcu.McuFactory;
import com.nxp.swtools.gtm.model.utils.GtmUtils;
import com.nxp.swtools.gtm.model.xml.settings.GtmConstraintsTable;
import com.nxp.swtools.gtm.model.xml.settings.GtmEnumSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmXmlConfiguration;
import com.nxp.swtools.gtm.model.xml.settings.IGtmSetting;
import com.nxp.swtools.gtml.controller.utils.StorageGtmUtils;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.helper.CommonConfigImpl;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksTool;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmConfiguration;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmContainer;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmSetting;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmTool;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.view.IViewRefreshManager;
import com.nxp.swtools.utils.wizards.exportWizard.AExportWizard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.swt.widgets.Display;

public class GtmController
extends AUctController
implements ICodeGenerator {
    public static final int SHOW_PROBLEM = 1024;
    private static final Logger LOGGER = LogManager.getLogger(GtmController.class);
    @Nullable
    private ISharedConfigurationListener sharedConfigListener;
    private IGtmMcu gtmMcu;
    private GtmXmlConfiguration gtmXmlConfig;
    @Nullable
    private Display display;
    @Nullable
    private GtmSourceCodeRefreshHandler codeRefreshManagerHandler = null;
    private GtmValidationHandler validationHandler;
    private HashMap<ChangeListener<?>, ObservableValue<?>> listenersMap = new HashMap();
    private CodeManager codeManager;
    GtmConstraintsHandler constraintsHandler;
    private Set<IGtmSetting> currentPaneSettings;
    private GtmConstraintsDequeContainer<IGtmSetting> constraintsDequeContainer;
    private Thread constraintsThread;
    private IGtmConstraintsState constraintsState;
    private final ReentrantLock constraintsLock;
    private McuErrorParseStatus mcuErrorParseStatus = new McuErrorParseStatus(false);

    private GtmController() {
        this.display = SWToolsProperties.isHeadlessOn() ? null : Display.getCurrent();
        this.codeManager = new CodeManager((IToolSpecificCodeManager)new GtmSpecificCodeManager(this));
        this.currentPaneSettings = new HashSet<IGtmSetting>();
        this.constraintsDequeContainer = new GtmConstraintsDequeContainer();
        this.constraintsThread = new Thread(new GtmCheckConstraintsRunnable(this));
        this.constraintsState = new GtmIdleConstraintsState(this);
        this.constraintsLock = new ReentrantLock();
        this.gtmMcu = this.getMcuFromSharedConfig(this.getSharedConfig());
        this.setMcu((IMcu)this.gtmMcu);
        this.gtmXmlConfig = this.gtmMcu.getGtmXmlConfig();
        this.constraintsHandler = new GtmConstraintsHandler(this);
        this.problemsManager = new GtmProblemsManager();
        this.storeTool();
        this.validationHandler = new GtmValidationHandler();
        this.reloadFromSharedConfig(this.getSharedConfig(), ConfigChangeReason.UNKNOWN);
        this.sharedConfigListener = new SharedConfigurationAdapter(){

            public void configurationReloaded(ISharedConfiguration sharedConfig, ConfigChangeReason reason) {
                GtmController.this.reloadFromSharedConfig(sharedConfig, reason);
            }

            public void commonConfigurationChanged(ISharedConfiguration sharedConfiguration) {
                IMcu currentMcu = GtmController.this.getMcu();
                if (currentMcu != null && !sharedConfiguration.getCommonConfig().getMcuIdentification().equals(currentMcu.getMcuIdentification())) {
                    this.configurationReloaded(GtmController.this.getSharedConfig(), ConfigChangeReason.UNKNOWN);
                }
            }

            public void configurationChanged(ISharedConfiguration sharedConfiguration, IConfigChangeContext changeContext) {
                Object source = changeContext.getSource();
                if (source instanceof StorageGtmTool) {
                    if (((StorageGtmTool)source).isEnabled() != GtmController.this.isToolEnabled().get()) {
                        this.configurationReloaded(sharedConfiguration, ConfigChangeReason.UNKNOWN);
                    }
                } else if (source instanceof CommonConfigImpl) {
                    CommonConfigImpl commonConfigImpl = (CommonConfigImpl)source;
                    ProcessorCore selectedCore = commonConfigImpl.getSelectedCore();
                    if (selectedCore != null) {
                        GtmController.this.handleSettingChange(4, GtmController.this.getSharedConfig(), null, null);
                    }
                } else if (source instanceof StorageClocksTool) {
                    GtmController.this.constraintsHandler.checkInputResolutionConstraints();
                    GtmController.this.checkQueuedConstraints();
                }
            }
        };
        this.getSharedConfig().addListener(Objects.requireNonNull(this.sharedConfigListener));
    }

    public GtmScriptProfile getProfile() {
        GtmScriptProfile profile = new GtmScriptProfile(this.gtmMcu);
        profile.applyDependencies();
        return profile;
    }

    public @Nullable Display getDisplay() {
        return this.display;
    }

    public boolean isMcuSupported() {
        return !(this.gtmMcu instanceof GtmEmptyMcu);
    }

    public boolean waitUntilRegenerated() {
        return this.codeManager.waitUntilRegenerated();
    }

    public @Nullable ScriptResult waitAndGetGeneratedCode() {
        if (this.waitUntilRegenerated()) {
            return this.codeManager.getGeneratedCode();
        }
        return null;
    }

    public boolean isGeneratingCode() {
        return this.codeManager.isGeneratingCode();
    }

    public boolean isCodeDirty() {
        return this.codeManager.isCodeDirty();
    }

    public void regenerateCode() {
        this.codeManager.requestRegenerateCode();
    }

    public void forceCodeRegeneration() {
        this.regenerateCode();
    }

    public GtmConstraintsHandler getConstraintsHandler() {
        return this.constraintsHandler;
    }

    public static GtmController getInstance() {
        try {
            GtmController controller = (GtmController)((Object)SWTFactoryProxy.INSTANCE.getSingletonInstance(GtmController.class));
            if (controller.isDisposed().get()) {
                throw new IllegalStateException("GTM Controller is disposed");
            }
            return controller;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot obtain user-singleton instance of: " + GtmController.class.getSimpleName(), e);
        }
    }

    public @Nullable String getToolError() {
        if (!(this.isToolEnabled().get() && GtmController.isMcuSupported((IMcu)this.gtmMcu) || !(this.gtmMcu instanceof GtmEmptyMcu))) {
            return ((GtmEmptyMcu)this.gtmMcu).getReason();
        }
        return null;
    }

    public AExportWizard.GenerationResult getGenerationResult(String coreId) {
        ScriptResult scriptResult = this.getGeneratedCode();
        String error = this.getToolError();
        if (error != null) {
            return AExportWizard.GenerationResult.fail((String)error);
        }
        if (scriptResult.isFailed()) {
            return AExportWizard.GenerationResult.fail((String)UtilsText.safeString((String)Messages.CodeGenerationError));
        }
        return AExportWizard.GenerationResult.success((Map)CollectionsUtils.safeMap((Map)scriptResult.getOpenedFiles(coreId)), (Map)CollectionsUtils.safeMap((Map)scriptResult.getOpenedBinaryFiles(coreId)));
    }

    protected IGtmMcu getMcuFromSharedConfig(ISharedConfiguration sharedConfiguration) {
        this.mcuErrorParseStatus.setErrorParseStatus(false);
        ICommonConfig commonConfig = sharedConfiguration.getCommonConfig();
        GtmEmptyMcu selectedMcu = null;
        if (!commonConfig.getMcu().isEmpty()) {
            IGtmMcu currentMcu = (IGtmMcu)this.getMcu();
            if (currentMcu != null && commonConfig.getMcuIdentification().equals(currentMcu.getMcuIdentification()) && !SWToolsProperties.isVerificationOn() && !(currentMcu instanceof GtmEmptyMcu)) {
                selectedMcu = currentMcu;
            } else {
                ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
                selectedMcu = McuFactory.create((ISupportedDerivativesForSwTools)derivatives, (ICommonConfig)commonConfig, (McuErrorParseStatus)this.mcuErrorParseStatus);
            }
        } else {
            selectedMcu = new GtmEmptyMcu(UtilsText.safeString((String)com.nxp.swtools.common.uct.utils.Messages.Msg_NoMcuSelected));
        }
        return selectedMcu != null ? selectedMcu : new GtmEmptyMcu(UtilsText.safeString((String)com.nxp.swtools.common.uct.utils.Messages.Msg_CorruptedMcuData));
    }

    protected void reloadFromSharedConfig(ISharedConfiguration sharedConfiguration) {
    }

    public void handleSettingChange(int eventType, @Nullable Object eventOriginator, @Nullable String actionLabel) {
    }

    protected StorageGtmTool storeTool() {
        StorageGtmTool stGtmTool = this.getSharedConfig().getTools().getGtmTool();
        if (stGtmTool == null) {
            stGtmTool = new StorageGtmTool();
            this.getSharedConfig().getTools().setGtmTool(stGtmTool);
        }
        return stGtmTool;
    }

    public void resetToProcessorDefaults() {
        this.getProblemsManager().clearAllProblems();
        this.reloadFromSharedConfig(this.getSharedConfig(), ConfigChangeReason.CLEAR_CONFIG);
        GtmUtils.checkAllComponentsConstraints((GtmXmlConfiguration)this.gtmXmlConfig, (IGtmMcu)this.gtmMcu);
        this.requestRegenerateCode();
    }

    public McuErrorParseStatus getMcuErrorParseStatus() {
        return this.mcuErrorParseStatus;
    }

    public IGtmMcu getGtmMcu() {
        return this.gtmMcu;
    }

    public GtmXmlConfiguration getGtmXmlConfig() {
        return this.gtmXmlConfig;
    }

    public void setGtmXmlConfig() {
        this.gtmXmlConfig = this.gtmMcu.getGtmXmlConfig();
    }

    public GtmProblemsManager getProblemsManager() {
        return (GtmProblemsManager)this.problemsManager;
    }

    protected void reloadFromSharedConfig(ISharedConfiguration sharedConfiguration, ConfigChangeReason reason) {
        if (this.getSharedConfig() != sharedConfiguration) {
            LOGGER.log(Level.SEVERE, "Unexpected change of shared configuration for GTM tool");
            throw new IllegalArgumentException("Unexpected change of shared configuration");
        }
        this.gtmMcu = this.getMcuFromSharedConfig(sharedConfiguration);
        this.setMcu((IMcu)this.gtmMcu);
        this.setGtmXmlConfig();
        ArrayList<GtmProblem> oldProblemsList = new ArrayList<GtmProblem>(this.getProblemsManager().getUnmodifiableProblemsList());
        this.getProblemsManager().clearAllProblems();
        StorageGtmTool stGtmTool = sharedConfiguration.getTools().getGtmTool();
        this.setToolEnabled((stGtmTool == null || stGtmTool.isEnabled()) && !(this.gtmMcu instanceof GtmEmptyMcu));
        if (this.isToolEnabled().get()) {
            this.storeTool();
            this.loadGtmConfiguration(reason, oldProblemsList);
            this.reintializeValidationListener(this.getGtmMcu().getGtmLayoutContent(), this.validationHandler);
            this.validationHandler.validateAllIntegerSettings();
            this.validationHandler.validateAllEnumSettings();
            this.validate();
        } else {
            this.gtmMcu = this.mcuErrorParseStatus.hasParsingFailed() ? new GtmEmptyMcu(com.nxp.swtools.common.uct.utils.Messages.Msg_CorruptedMcuData) : new GtmEmptyMcu(Messages.Msg_ToolDisabled);
            this.setMcu((IMcu)this.gtmMcu);
            this.setGeneratedCode(new ScriptResult.Builder().appendError(UtilsText.safeString((String)Messages.Msg_ToolDisabled)).build());
            this.refreshSourceView();
        }
        if (!this.getProblemsManager().hasGtmToolErrors()) {
            this.requestRegenerateCode();
        }
        this.handleSettingChange(2, this.getSharedConfig(), null, null);
    }

    public void validate() {
        this.validationHandler.validate();
    }

    public void reintializeValidationListener(GtmStructSetting structSetting, GtmValidationHandler handler) {
        for (GtmIntegerSetting integerSetting : structSetting.getIntegerSettings()) {
            integerSetting.removePropertyChangeListener(handler.getValueChangeListener());
            integerSetting.removePropertyChangeListener(handler.getDisableStateListener());
            integerSetting.addPropertyChangeListener(handler.getValueChangeListener());
            integerSetting.addPropertyChangeListener(handler.getDisableStateListener());
        }
        for (GtmEnumSetting enumSetting : structSetting.getEnumSettings()) {
            if (enumSetting.getConstraintsRef().isBlank()) continue;
            enumSetting.removePropertyChangeListener(handler.getValueChangeListener());
            enumSetting.removePropertyChangeListener(handler.getDisableStateListener());
            enumSetting.addPropertyChangeListener(handler.getValueChangeListener());
            enumSetting.addPropertyChangeListener(handler.getDisableStateListener());
        }
        for (GtmStructSetting childStructSetting : structSetting.getStructSettings()) {
            this.reintializeValidationListener(childStructSetting, handler);
        }
    }

    public void addValidationListener(GtmStructSetting structSetting, GtmValidationHandler handler) {
        for (GtmIntegerSetting integerSetting : structSetting.getIntegerSettings()) {
            integerSetting.addPropertyChangeListener(handler.getValueChangeListener());
            integerSetting.addPropertyChangeListener(handler.getDisableStateListener());
        }
        for (GtmEnumSetting enumSetting : structSetting.getEnumSettings()) {
            if (enumSetting.getConstraintsRef().isBlank()) continue;
            enumSetting.addPropertyChangeListener(handler.getValueChangeListener());
            enumSetting.addPropertyChangeListener(handler.getDisableStateListener());
        }
        for (GtmStructSetting childStructSetting : structSetting.getStructSettings()) {
            this.addValidationListener(childStructSetting, handler);
        }
    }

    public void removeValidationListener(GtmStructSetting structSetting, GtmValidationHandler handler) {
        for (GtmIntegerSetting integerSetting : structSetting.getIntegerSettings()) {
            integerSetting.removePropertyChangeListener(handler.getValueChangeListener());
            integerSetting.removePropertyChangeListener(handler.getDisableStateListener());
        }
        for (GtmEnumSetting enumSetting : structSetting.getEnumSettings()) {
            if (enumSetting.getConstraintsRef().isBlank()) continue;
            enumSetting.removePropertyChangeListener(handler.getValueChangeListener());
            enumSetting.removePropertyChangeListener(handler.getDisableStateListener());
        }
        for (GtmStructSetting childStructSetting : structSetting.getStructSettings()) {
            this.removeValidationListener(childStructSetting, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCurrentPanelSetting(GtmStructSetting gtmStructSetting) {
        this.currentPaneSettings.clear();
        gtmStructSetting.computeChildGtmSettings(this.currentPaneSettings);
        GtmConstraintsDequeContainer<IGtmSetting> gtmConstraintsDequeContainer = this.constraintsDequeContainer;
        synchronized (gtmConstraintsDequeContainer) {
            Set<IGtmSetting> onGoingConstraintsToCheck = this.constraintsDequeContainer.getOngoingConstraintsToCheck();
            HashSet<IGtmSetting> currentPaneSettingsToCheck = new HashSet<IGtmSetting>(onGoingConstraintsToCheck);
            HashSet<IGtmSetting> nonCurrentPaneSettingsToCheck = new HashSet<IGtmSetting>(onGoingConstraintsToCheck);
            currentPaneSettingsToCheck.retainAll(this.currentPaneSettings);
            nonCurrentPaneSettingsToCheck.removeAll(currentPaneSettingsToCheck);
            this.constraintsDequeContainer.clearAddVisibleSettings(currentPaneSettingsToCheck);
            this.constraintsDequeContainer.clearAddNonVisibleSettings(nonCurrentPaneSettingsToCheck);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRemainingVisibleSettings() {
        while (this.constraintsDequeContainer.hasVisible()) {
            IGtmSetting componentSetting;
            IGtmSetting iGtmSetting = componentSetting = this.constraintsDequeContainer.poll();
            synchronized (iGtmSetting) {
                componentSetting.checkConstraints(this.gtmMcu, this.gtmXmlConfig.getConstraints());
                if (componentSetting instanceof ABaseUIComponentSetting) {
                    StorageGtmUtils.updateSettingStorage((Object)this, (ABaseUIComponentSetting)componentSetting);
                }
            }
        }
    }

    public void checkQueuedConstraints() {
        GtmConstraintsTable constraints = this.gtmXmlConfig.getConstraints();
        while (!this.constraintsDequeContainer.isEmpty()) {
            IGtmSetting componentSetting = this.constraintsDequeContainer.poll();
            componentSetting.checkConstraints(this.gtmMcu, constraints);
        }
    }

    public void requestConstraintsCheck() {
        this.constraintsThread = new Thread(new GtmCheckConstraintsRunnable(this));
        this.constraintsThread.start();
    }

    private void loadGtmConfiguration(ConfigChangeReason reason, List<GtmProblem> oldProblemsList) {
        StorageGtmTool stGtmTool = this.getSharedConfig().getTools().getGtmTool();
        if (stGtmTool != null) {
            this.createConstraintSettingsDependencies();
            StorageGtmConfiguration stGtmConfiguration = stGtmTool.getGtmConfiguration();
            if (stGtmConfiguration == null || reason.equals((Object)ConfigChangeReason.CLEAR_CONFIG)) {
                stGtmConfiguration = new StorageGtmConfiguration();
                stGtmTool.setGtmConfiguration(stGtmConfiguration);
                StorageGtmUtils.initAllStorageContainers(this.gtmMcu, stGtmTool);
                GtmUtils.initAllUiComponents((GtmXmlConfiguration)this.gtmXmlConfig);
            } else {
                this.loadGtmSettingsFromContainers(stGtmConfiguration.getContainers());
            }
            this.constraintsHandler.checkInputResolutionConstraints();
            this.checkQueuedConstraints();
            for (GtmProblem gtmProblem : oldProblemsList) {
                IProblemSource source = gtmProblem.getProblemSource();
                if (source instanceof GtmIntegerSetting) {
                    this.validationHandler.validateValue((GtmIntegerSetting)source);
                    continue;
                }
                if (!(source instanceof GtmEnumSetting)) continue;
                this.validationHandler.validateValue((GtmEnumSetting)source);
            }
        }
        if (reason.equals((Object)ConfigChangeReason.UNDO_REDO)) {
            this.handleSettingChange(16, this.getSharedConfig(), null, null);
        } else {
            this.handleSettingChange(8, this.getSharedConfig(), null, null);
        }
    }

    public void createConstraintSettingsDependencies() {
        this.listenersMap.entrySet().forEach(entry -> ((ObservableValue)entry.getValue()).removeListener((ChangeListener)entry.getKey()));
        this.listenersMap.clear();
        GtmStructSetting parentStruct = this.getGtmXmlConfig().getLayoutComponents().getParentLayoutContent();
        this.constraintsHandler.createConstraintDependency(parentStruct);
    }

    public void loadGtmSettingsFromContainers(List<StorageGtmContainer> gtmContainers) {
        for (StorageGtmContainer gtmContainer : gtmContainers) {
            ABaseUIComponentSetting containerSetting = UctUtils.getComponentSettingById((IMcu)this.gtmMcu, (String)gtmContainer.getId());
            if (containerSetting instanceof GtmStructSetting) {
                GtmStructSetting structSeting = (GtmStructSetting)containerSetting;
                for (StorageGtmSetting stSetting : gtmContainer.getSettings()) {
                    ABaseUIComponentSetting uiSetting = GtmUtils.getChildFromStructSetting((GtmStructSetting)structSeting, (String)stSetting.getId());
                    if (uiSetting == null) continue;
                    GtmController.setUIComponentValue(uiSetting, stSetting.getValue());
                }
            }
            this.loadGtmSettingsFromContainers(gtmContainer.getChildContainers());
        }
    }

    private static void setUIComponentValue(ABaseUIComponentSetting uiSetting, String value) {
        if (uiSetting instanceof EnumSetting) {
            EnumSetting enumSetting = (EnumSetting)uiSetting;
            ItemSetting itemSetting = enumSetting.getItemByName(value);
            if (itemSetting != null) {
                enumSetting.setCurrentValue(itemSetting.getId());
                enumSetting.setCurrentSelection(itemSetting.getLabel());
            }
        } else if (uiSetting instanceof BoolSetting) {
            BoolSetting boolSetting = (BoolSetting)uiSetting;
            boolSetting.setCurrentValue(value);
        } else if (uiSetting instanceof IntegerSetting) {
            IntegerSetting integerSetting = (IntegerSetting)uiSetting;
            integerSetting.setCurrentValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSettingChange(int eventType, @Nullable Object eventOriginator, @Nullable Object inputObject, @Nullable String actionLabel) {
        ISharedConfiguration currentSharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        GtmController gtmController = this;
        synchronized (gtmController) {
            IMcu currentMcu = this.getMcu();
            if (currentMcu != null && this.getShouldUpdateConfiguration().get() && this.isToolEnabled().get() && GtmController.isMcuSupported((IMcu)currentMcu)) {
                if (eventOriginator != currentSharedConfig) {
                    StorageGtmTool stGtmTool = this.storeTool();
                    currentSharedConfig.getTools().setGtmTool(stGtmTool);
                    this.setDirty(currentSharedConfig, "GTM", stGtmTool, actionLabel, IConfigChangeContext.ConfigChangeType.TOOL_SETTING_CHANGE);
                }
                this.setSaved(false);
            }
        }
        UIJobHelper.runNowOrInJob(() -> this.handleEvent(new ToolEvent.Builder(eventType).setObject(inputObject).setOriginator(eventOriginator).build()), (String)"Refresh GTM tool", (Display)this.display);
    }

    public @Nullable GtmSourceCodeRefreshHandler getSourceCodeRefreshManager() {
        return this.codeRefreshManagerHandler;
    }

    public void setSourceCodeRefreshManager(GtmSourceCodeRefreshHandler managerHandler) {
        this.codeRefreshManagerHandler = managerHandler;
    }

    public void removeSourceCodeRefreshManager() {
        this.codeRefreshManagerHandler = null;
    }

    public void refreshSourceView() {
        IViewRefreshManager refreshManager;
        GtmSourceCodeRefreshHandler refreshManagerHandler = this.getSourceCodeRefreshManager();
        if (refreshManagerHandler != null && (refreshManager = refreshManagerHandler.getRefreshManager()) != null) {
            refreshManager.refresh();
        }
    }

    public GtmValidationHandler getValidationHandler() {
        return this.validationHandler;
    }

    public ChangeListener<String> createConstraintsListener(IGtmSetting gtmSetting) {
        return (obs, oldVal, newVal) -> {
            GtmConstraintsDequeContainer<IGtmSetting> gtmConstraintsDequeContainer = this.constraintsDequeContainer;
            synchronized (gtmConstraintsDequeContainer) {
                if (this.currentPaneSettings.contains(gtmSetting)) {
                    this.constraintsDequeContainer.addVisibleSetting(gtmSetting);
                } else {
                    this.constraintsDequeContainer.addNonVisibleSetting(gtmSetting);
                }
            }
        };
    }

    public ChangeListener<String> createValidateValueListener(GtmIntegerSetting integerSetting) {
        return (obs, oldVal, newVal) -> {
            if (!integerSetting.isDisabled()) {
                this.validationHandler.validateValue(integerSetting);
            }
        };
    }

    public GtmConstraintsDequeContainer<IGtmSetting> getConstraintsDequeContainer() {
        return this.constraintsDequeContainer;
    }

    public synchronized void lockConstraintsLock() {
        this.constraintsLock.lock();
    }

    public synchronized void unlockConstraintsLock() {
        this.constraintsLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IGtmConstraintsState getConstraintsState() {
        IGtmConstraintsState iGtmConstraintsState = this.constraintsState;
        synchronized (iGtmConstraintsState) {
            return this.constraintsState;
        }
    }

    public void changeConstraintsState(IGtmConstraintsState state) {
        this.constraintsState = state;
    }

    public void changeInCurrentPane() {
        this.constraintsState.changeInCurrentPane();
    }

    public void changeInTreePane() {
        this.constraintsState.changeInTreePane();
    }

    public void updateConstraintsDeque() {
        this.constraintsState.updateConstraintsDeque();
    }

    public void clearCurrentPaneSettings() {
        this.currentPaneSettings.clear();
    }

    public Set<IGtmSetting> getCurrentPaneSettings() {
        return this.currentPaneSettings;
    }

    public Thread getConstraintsThread() {
        return this.constraintsThread;
    }

    public void clearConstraintsDeque() {
        this.constraintsDequeContainer.clear();
    }

    public void addEntryToListenersMap(ChangeListener<?> listener, ObservableValue<?> observable) {
        this.listenersMap.put(listener, observable);
    }

    public synchronized void dispose() {
        this.setDisposed(true);
        ISharedConfigurationListener listenerLoc = this.sharedConfigListener;
        if (listenerLoc != null) {
            this.getSharedConfig().removeListener(listenerLoc);
        }
        this.removeValidationListener(this.getGtmMcu().getGtmLayoutContent(), this.validationHandler);
        this.listenersMap.entrySet().forEach(entry -> ((ObservableValue)entry.getValue()).removeListener((ChangeListener)entry.getKey()));
        this.listenersMap.clear();
    }

    public @Nullable String getSelectedCore() {
        ProcessorCore core = this.getSharedConfig().getCommonConfig().getSelectedCore();
        return core != null ? core.getID() : null;
    }

    public boolean waitUntilConstraintCheckFinished() {
        if (this.constraintsThread.isAlive()) {
            try {
                this.constraintsThread.join();
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.SEVERE, "Unexpected interruption while waiting for the constraints task to finish.");
            }
        }
        return this.getConstraintsState() instanceof GtmIdleConstraintsState;
    }
}

