/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.view;

import com.freescale.s32ds.debug.ka.osek.controller.TypeObjectTableColumnLabelProvider;
import com.freescale.s32ds.debug.ka.osek.controller.TypeObjectTableContentProvider;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplAttr;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttribute;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiImplementation;
import com.freescale.s32ds.debug.ka.osek.utils.OrtiGlobal;
import com.freescale.s32ds.debug.ka.osek.utils.OrtiImageResources;
import com.freescale.s32ds.debug.ka.osek.utils.TypeObjectTableSorter;
import com.freescale.s32ds.debug.ka.osek.view.AbstractOsekView;
import com.freescale.s32ds.debug.ka.osek.view.OrtiItemDetailsView;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.progress.UIJob;

public class TypeObjectTable
extends Composite {
    public static final int DEFAULT_COLUMN_WIDTH = 200;
    private TableViewer m_tableViewer;
    private TypeObjectTableSorter m_tableSorter;
    private OrtiItemDetailsView m_description;
    private String m_objectToSelect = "";
    private boolean m_columnsLoaded = false;
    private OrtiImplementation.ImplObjectInfo m_dataProvider;
    private Menu m_tableItemMenu;
    private TableCursor m_cursor;
    private List<Button> m_checkButtons = new LinkedList<Button>();
    private TypeObjectTableContentProvider m_contentProvider;

    public TypeObjectTable(Composite parent, int style, OrtiImplementation.ImplObjectInfo implObjInfo) {
        super(parent, style);
        this.m_dataProvider = implObjInfo;
        this.setLayout((Layout)new FormLayout());
        final Sash sash = new Sash((Composite)this, 256);
        FormData data = new FormData();
        data.top = new FormAttachment(80, 0);
        data.right = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        sash.setLayoutData((Object)data);
        Composite upSashPane = new Composite(this, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                this.layout();
                return this.getSize();
            }
        };
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment((Control)sash, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        upSashPane.setLayoutData((Object)data);
        GridLayout gridlay = new GridLayout();
        gridlay.marginWidth = 0;
        gridlay.marginHeight = 0;
        gridlay.verticalSpacing = 1;
        gridlay.horizontalSpacing = 1;
        upSashPane.setLayout((Layout)gridlay);
        upSashPane.setBackground(AbstractOsekView.BACKGROUND_COLOR);
        Group selcolPane = new Group(upSashPane, 4);
        selcolPane.setText("Update attributes");
        selcolPane.setLayoutData((Object)new GridData(32, 2, false, false));
        RowLayout rowlay = new RowLayout(256);
        rowlay.wrap = true;
        rowlay.pack = true;
        rowlay.marginHeight = 0;
        rowlay.marginTop = 0;
        rowlay.marginBottom = 0;
        rowlay.marginWidth = 0;
        selcolPane.setLayout((Layout)rowlay);
        selcolPane.setBackground(AbstractOsekView.BACKGROUND_COLOR);
        this.CreateTable(upSashPane, implObjInfo);
        this.m_description = new OrtiItemDetailsView(this, 0, implObjInfo);
        data = new FormData();
        data.top = new FormAttachment((Control)sash, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.m_description.setLayoutData(data);
        this.m_description.setBackground(AbstractOsekView.BACKGROUND_COLOR);
        this.m_description.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TypeObjectTable.this.notifyListeners(13, event);
            }
        });
        this.m_description.setText("Please wait while loading objects...");
        this.addColumns();
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sash.setBounds(e.x, e.y, e.width, e.height);
                FormData formData = new FormData();
                formData.top = new FormAttachment(0, e.y);
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                formData.height = 3;
                sash.setLayoutData((Object)formData);
            }
        });
        sash.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                sash.getParent().layout();
            }
        });
        sash.pack();
    }

    private void CreateTable(Composite parent, OrtiImplementation.ImplObjectInfo implObjInfo) {
        int style = 66304;
        if (implObjInfo.GetObjects() != null && implObjInfo.GetObjects().length > 1) {
            style |= 0x20;
        }
        this.m_tableViewer = new TableViewer(parent, style);
        this.m_tableSorter = new TypeObjectTableSorter(implObjInfo);
        this.m_tableViewer.setSorter((ViewerSorter)this.m_tableSorter);
        Table table = this.m_tableViewer.getTable();
        table.setLinesVisible(true);
        GridData grlay = new GridData(4, 4, true, true);
        table.setLayoutData((Object)grlay);
        table.setHeaderVisible(true);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrtiImplementation.ImplObjectInfo info = TypeObjectTable.this.m_contentProvider.getImplObjectInfo();
                if (e.detail == 32) {
                    info.SetUpdateObject(((TableItem)e.item).getText(), ((TableItem)e.item).getChecked());
                }
            }
        });
        this.m_contentProvider = new TypeObjectTableContentProvider(implObjInfo);
        this.m_tableViewer.setContentProvider((IContentProvider)this.m_contentProvider);
        this.m_cursor = new TableCursor(table, 0);
        this.m_cursor.setBackground(this.getDisplay().getSystemColor(17));
        this.m_cursor.setForeground(this.getDisplay().getSystemColor(7));
        this.m_cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof TableCursor) {
                    TypeObjectTable.this.ShowDetailsOnSelectedItem((TableCursor)e.widget);
                }
            }
        });
        this.m_cursor.setBackgroundMode(1);
        this.m_tableItemMenu = new Menu((Control)this.m_cursor);
        this.m_cursor.setMenu(this.m_tableItemMenu);
        OrtiGlobal.IntBases[] intBasesArray = OrtiGlobal.IntBases.values();
        int n = intBasesArray.length;
        int n2 = 0;
        while (n2 < n) {
            OrtiGlobal.IntBases item_base = intBasesArray[n2];
            MenuItem item = new MenuItem(this.m_tableItemMenu, 16);
            item.setText(item_base.name());
            item.setData((Object)item_base);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem item = (MenuItem)e.widget;
                    TypeObjectTable.this.handleIntFormatMenuItemSelect(((OrtiGlobal.IntBases)((Object)item.getData())).getBase());
                }
            });
            ++n2;
        }
        new MenuItem(this.m_tableItemMenu, 2);
        MenuItem updateitem = new MenuItem(this.m_tableItemMenu, 32);
        updateitem.setText("Toggle update");
        updateitem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrtiObjectAttribute attr = (OrtiObjectAttribute)TypeObjectTable.this.getSelectedAttribute();
                if (attr != null) {
                    TableItem ti = TypeObjectTable.this.m_cursor.getRow();
                    OrtiObject obj = (OrtiObject)ti.getData();
                    TypeObjectTable.this.m_dataProvider.toggleObjectAttrUpdate(obj, attr.implAttribute.name);
                    ti.setChecked(true);
                    for (Button btn : TypeObjectTable.this.m_checkButtons) {
                        if (!btn.getText().equals(attr.implAttribute.name)) continue;
                        btn.setSelection(true);
                        break;
                    }
                }
            }
        });
        updateitem = new MenuItem(this.m_tableItemMenu, 8);
        updateitem.setText("Refresh");
        updateitem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeObjectTable.this.refreshSelectedItem();
            }
        });
        new MenuItem(this.m_tableItemMenu, 2);
        OrtiGlobal.EnumValueShow[] enumValueShowArray = OrtiGlobal.EnumValueShow.values();
        int n3 = enumValueShowArray.length;
        n = 0;
        while (n < n3) {
            OrtiGlobal.EnumValueShow eShow = enumValueShowArray[n];
            final MenuItem mitem = new MenuItem(this.m_tableItemMenu, 16);
            mitem.setText(eShow.label);
            mitem.setData((Object)eShow);
            mitem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableColumn tc = TypeObjectTable.this.m_tableViewer.getTable().getColumn(TypeObjectTable.this.m_cursor.getColumn());
                    if (tc != null) {
                        String text = tc.getText();
                        TypeObjectTable.this.m_dataProvider.GetEnumDisplay().put(text, (OrtiGlobal.EnumValueShow)((Object)mitem.getData()));
                        TypeObjectTable.this.doUpdate(new String[]{text});
                        TypeObjectTable.this.SelectObject();
                        TypeObjectTable.this.m_cursor.redraw();
                    }
                }
            });
            ++n;
        }
        this.m_tableItemMenu.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                TypeObjectTable.this.handleShowMenu();
            }
        });
    }

    private Object getSelectedAttribute() {
        TableItem ti = this.m_cursor.getRow();
        OrtiObjectAttribute retObj = null;
        if (ti != null) {
            OrtiObject obj;
            String colName;
            int col_index = this.m_cursor.getColumn();
            TableColumn tcol = this.m_tableViewer.getTable().getColumn(col_index);
            if (tcol != null && !(colName = tcol.getText()).equals("Name") && (obj = (OrtiObject)ti.getData()) != null) {
                OrtiObjectAttribute[] ortiObjectAttributeArray = obj.getAtributes();
                int n = ortiObjectAttributeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OrtiObjectAttribute attr = ortiObjectAttributeArray[n2];
                    if (attr.implAttribute.name.equals(colName)) {
                        retObj = attr;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return retObj;
    }

    private void handleShowMenu() {
        OrtiObjectAttribute attr = (OrtiObjectAttribute)this.getSelectedAttribute();
        boolean disable = true;
        OrtiGlobal.IntBases base = OrtiGlobal.IntBases.Decimal;
        String itemText = "";
        MenuItem[] menuItemArray = this.m_tableItemMenu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            itemText = item.getText();
            disable = attr == null || attr.implAttribute.type == 3 || (itemText.equals("Toggle update") || itemText.equals("Refresh")) && attr.isStatic;
            Object data = item.getData();
            if (data != null && attr != null) {
                if (data instanceof OrtiGlobal.IntBases) {
                    base = (OrtiGlobal.IntBases)((Object)data);
                    item.setSelection(attr.representBase == base.getBase());
                } else if (data instanceof OrtiGlobal.EnumValueShow) {
                    if (attr.getType() != 1) {
                        disable = true;
                    } else {
                        boolean selection = false;
                        OrtiGlobal.EnumValueShow eshow = this.m_dataProvider.GetEnumDisplay().get(attr.implAttribute.name);
                        if (eshow.equals(item.getData())) {
                            selection = true;
                        }
                        item.setSelection(selection);
                    }
                }
            }
            item.setEnabled(!disable);
            ++n2;
        }
    }

    private void handleIntFormatMenuItemSelect(int base) {
        OrtiObjectAttribute attr = (OrtiObjectAttribute)this.getSelectedAttribute();
        if (attr != null) {
            attr.setRepresentBase((short)base);
            OrtiObject obj = (OrtiObject)this.m_cursor.getRow().getData();
            if (obj != null) {
                this.m_tableViewer.update((Object)obj, new String[]{attr.implAttribute.name});
                this.m_cursor.redraw();
                this.m_description.showOrtiObjectAttribute(obj, attr.implAttribute.name);
            }
        }
    }

    private void ShowDetailsOnSelectedItem(TableCursor tc) {
        Object dataObj;
        TableColumn tcol = this.m_tableViewer.getTable().getColumn(tc.getColumn());
        TableItem titem = tc.getRow();
        if (titem != null && (dataObj = titem.getData()) != null && dataObj instanceof OrtiObject) {
            OrtiObject obj = (OrtiObject)dataObj;
            if (tcol.getText() == "Name") {
                this.m_description.showOrtiObject(obj);
            } else if (tcol.getData() instanceof OrtiImplAttr) {
                OrtiImplAttr attr = (OrtiImplAttr)tcol.getData();
                this.m_description.showOrtiObjectAttribute(obj, attr.name);
            }
        }
    }

    public Color getDefaultTableColor() {
        return this.m_tableViewer.getTable().getBackground();
    }

    public OrtiImplementation.ImplObjectInfo getImplObject() {
        return this.m_dataProvider;
    }

    public boolean isColumnSetLoaded() {
        return this.m_columnsLoaded;
    }

    public void addColumns() {
        TableJob job = new TableJob("Create view for " + this.m_dataProvider.implObject.getName(), TableJobs.CreateView);
        job.setSystem(true);
        job.schedule();
    }

    private void refreshSelectedItem() {
        Object elem;
        Object attr = this.getSelectedAttribute();
        if (attr != null && (elem = this.m_cursor.getRow().getData()) != null) {
            OrtiObjectAttribute oattr = (OrtiObjectAttribute)attr;
            this.doRefreshAttributes(new Object[]{elem}, new String[]{oattr.implAttribute.name}, new int[]{oattr.attrID});
        }
    }

    private void doRefreshAttributes(Object[] elements, String[] properties, int[] attrIDList) {
        this.m_dataProvider.UpdateAttributeValues(attrIDList);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.m_tableViewer.update(obj, properties);
            ++n2;
        }
    }

    private void doAddColumns() {
        if (this.m_columnsLoaded) {
            return;
        }
        Button attrCheck = null;
        AttrCheckBoxSelection selListener = new AttrCheckBoxSelection();
        OrtiImplObject implObjH = this.m_contentProvider.getImplObjectInfo().implObject;
        Table table = this.m_tableViewer.getTable();
        if (table.isDisposed()) {
            return;
        }
        TableColumn tblcol = null;
        Composite selcolpane = (Composite)table.getParent().getChildren()[0];
        if (implObjH != null) {
            OrtiImplementation.ImplObjectInfo info = this.m_contentProvider.getImplObjectInfo();
            TableViewerColumn tvcn = new TableViewerColumn(this.m_tableViewer, 16384);
            tvcn.setLabelProvider((CellLabelProvider)new TypeObjectTableColumnLabelProvider(this, "Name"));
            tblcol = tvcn.getColumn();
            tblcol.setText("Name");
            tblcol.setResizable(true);
            tblcol.setToolTipText("Object name");
            tblcol.setWidth(200);
            tblcol.addSelectionListener((SelectionListener)new ColumnSelection("Name"));
            String toolTip = "";
            Image img = null;
            OrtiImplAttr[] ortiImplAttrArray = implObjH.getAtributes();
            int n = ortiImplAttrArray.length;
            int n2 = 0;
            while (n2 < n) {
                OrtiImplAttr attr = ortiImplAttrArray[n2];
                int style = attr.getTypeID() == 3 ? 16384 : 131072;
                TableViewerColumn tvc = new TableViewerColumn(this.m_tableViewer, style);
                tvc.setLabelProvider((CellLabelProvider)new TypeObjectTableColumnLabelProvider(this, attr.getName()));
                tblcol = tvc.getColumn();
                tblcol.setText(attr.getName());
                tblcol.setResizable(true);
                toolTip = info.GetImplAttrDescription(attr.getName());
                tblcol.setToolTipText(toolTip);
                tblcol.setWidth(200);
                tblcol.addSelectionListener((SelectionListener)new ColumnSelection(attr.getName()));
                tblcol.setData((Object)attr);
                tblcol.setMoveable(true);
                tblcol.setAlignment(style);
                switch (attr.getType()) {
                    case 2: {
                        img = OrtiImageResources.GetImage(OrtiImageResources.ImageType.OrtiCtype);
                        break;
                    }
                    case 1: {
                        img = OrtiImageResources.GetImage(OrtiImageResources.ImageType.OrtiEnum);
                        break;
                    }
                    case 3: {
                        img = OrtiImageResources.GetImage(OrtiImageResources.ImageType.OrtiString);
                    }
                }
                if (img != null) {
                    Color bkgImg = tvcn.getViewer().getControl().getBackground();
                    img.setBackground(bkgImg);
                    tblcol.setImage(img);
                }
                if (attr.getType() != 3 && !attr.isStatic()) {
                    attrCheck = new Button(selcolpane, 32);
                    attrCheck.setText(attr.name);
                    attrCheck.setSelection(true);
                    attrCheck.addSelectionListener((SelectionListener)selListener);
                    attrCheck.setToolTipText(toolTip);
                    attrCheck.setBackground(AbstractOsekView.BACKGROUND_COLOR);
                    this.m_checkButtons.add(attrCheck);
                }
                ++n2;
            }
            this.m_columnsLoaded = true;
            this.doUpdate();
            this.m_tableViewer.setInput((Object)info);
            ortiImplAttrArray = this.m_tableViewer.getTable().getColumns();
            n = ortiImplAttrArray.length;
            n2 = 0;
            while (n2 < n) {
                OrtiImplAttr tc = ortiImplAttrArray[n2];
                tc.pack();
                ++n2;
            }
            this.m_description.setText("");
            if (attrCheck == null) {
                selcolpane.setVisible(false);
            }
        } else {
            this.m_description.setText("Loading objects failed!", this.getDisplay().getSystemColor(3));
        }
        this.SelectObject();
        selcolpane.getParent().pack();
    }

    public void update() {
        TableJob job = new TableJob("Update " + this.m_dataProvider.implObject.getName() + " view", TableJobs.Update);
        job.schedule();
    }

    private void doUpdate(String[] columns) {
        if (this.m_tableViewer.getControl().isDisposed()) {
            return;
        }
        if (!this.m_columnsLoaded) {
            this.m_tableViewer.setInput((Object)this.m_contentProvider.getImplObjectInfo());
        } else {
            int icount = this.m_tableViewer.getTable().getItemCount();
            OrtiImplementation.ImplObjectInfo info = this.m_contentProvider.getImplObjectInfo();
            if (info != null && icount == info.GetObjects().length && this.m_tableViewer.getInput() != null && info != null) {
                Object[] objectArray = info.GetUpdateObjects();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    this.m_tableViewer.update(obj, columns);
                    ++n2;
                }
            }
            this.ShowDetailsOnSelectedItem(this.m_cursor);
            this.m_cursor.redraw();
        }
    }

    private void doUpdate() {
        OrtiImplementation.ImplObjectInfo info = this.m_contentProvider.getImplObjectInfo();
        if (info != null) {
            String[] properties = info.getUpdateImplAttributes().toArray(new String[0]);
            info.UpdateAttributeValues();
            this.doUpdate(properties);
        }
    }

    public void setInput(Object input) {
        if (input instanceof IThread || input instanceof IStackFrame) {
            this.update();
        }
    }

    public void SelectObject(String objectName) {
        this.m_objectToSelect = objectName;
        this.SelectObject();
    }

    protected void SelectObject() {
        TableItem[] tableItemArray = this.m_tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getText().equals(this.m_objectToSelect)) {
                this.m_tableViewer.getTable().setSelection(item);
            }
            ++n2;
        }
    }

    class AttrCheckBoxSelection
    extends SelectionAdapter {
        AttrCheckBoxSelection() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Button) {
                boolean selection = ((Button)e.widget).getSelection();
                OrtiImplementation.ImplObjectInfo implInfo = TypeObjectTable.this.m_contentProvider.getImplObjectInfo();
                if (implInfo != null) {
                    String implAttr = ((Button)e.widget).getText();
                    implInfo.SetUpdateImplAttribute(implAttr, selection);
                }
            }
        }
    }

    class ColumnSelection
    extends SelectionAdapter {
        private String implAttrID = "Name";

        public ColumnSelection(String attrID) {
            this.implAttrID = attrID;
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof TableColumn) {
                TypeObjectTable.this.m_tableSorter.setColumn(this.implAttrID);
                int dir = TypeObjectTable.this.m_tableViewer.getTable().getSortDirection();
                dir = TypeObjectTable.this.m_tableViewer.getTable().getSortColumn() == e.widget ? (dir == 128 ? 1024 : 128) : 1024;
                TypeObjectTable.this.m_tableViewer.getTable().setSortDirection(dir);
                TypeObjectTable.this.m_tableViewer.getTable().setSortColumn((TableColumn)e.widget);
                TypeObjectTable.this.m_tableViewer.refresh(true);
            }
        }
    }

    class TableJob
    extends UIJob {
        private TableJobs jobType;

        public TableJob(String name, TableJobs jobType) {
            super(name);
            this.jobType = jobType;
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            switch (this.jobType) {
                case CreateView: {
                    TypeObjectTable.this.doAddColumns();
                    break;
                }
                case Update: {
                    TypeObjectTable.this.doUpdate();
                }
            }
            return Status.OK_STATUS;
        }
    }

    static enum TableJobs {
        CreateView,
        Update;

    }
}

