/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.template;

import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SetProjectBinaryParser
extends ProcessRunner {
    private static final String OLD_BINARY_PARSER_ID = "org.eclipse.cdt.core.BinaryParser";

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        if (args == null || args.length < 2) {
            S32DSWizardPlugin.logWarning("Data for SetProjectBinaryParser should contain more input parameters !");
            return;
        }
        Params params = new Params(args);
        String[] binErrParserIds = null;
        ICProjectDescription projectDesc = params.getProjectDescription();
        try {
            ICConfigurationDescription confDesc = params.getConfigurationDescription();
            ICConfigExtensionReference[] refs = confDesc.get(OLD_BINARY_PARSER_ID);
            if (refs.length != 0) {
                binErrParserIds = new String[refs.length + 1];
                int i = 0;
                while (i < refs.length) {
                    binErrParserIds[i] = refs[i].getID();
                    ++i;
                }
                binErrParserIds[refs.length] = params.getName();
            }
            CoreModelUtil.setBinaryParserIds((ICConfigurationDescription[])new ICConfigurationDescription[]{confDesc}, (String[])binErrParserIds);
            CoreModel.getDefault().setProjectDescription(params.getProject(), projectDesc);
        }
        catch (CoreException e) {
            S32DSWizardPlugin.log(e);
        }
    }

    private static class Params {
        private String id = null;
        private String name = null;
        private String projectName = null;
        private final ICProjectDescription projectDesc;
        private final IProject project;

        public Params(ProcessArgument[] args) {
            ProcessArgument[] processArgumentArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessArgument pa = processArgumentArray[n2];
                pa.resolve();
                if (pa.getParameterType() == 1) {
                    String argName = pa.getName();
                    if ("id".equals(argName)) {
                        this.id = pa.getSimpleValue();
                    }
                    if ("name".equals(argName)) {
                        this.name = pa.getSimpleValue();
                    }
                    if ("projectName".equals(argName)) {
                        this.projectName = pa.getSimpleValue();
                    }
                }
                ++n2;
            }
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
            this.projectDesc = CoreModel.getDefault().getProjectDescription(this.getProject(), true);
        }

        public String getId() {
            return this.id;
        }

        public ICProjectDescription getProjectDescription() {
            return this.projectDesc;
        }

        public ICConfigurationDescription getConfigurationDescription() throws CoreException {
            ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getProjectDescription().getConfigurations();
            int n = iCConfigurationDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
                if (c.getName().equals(this.getId())) {
                    return c;
                }
                ++n2;
            }
            throw new CoreException((IStatus)new Status(4, "com.freescale.s32ds.cross.wizard", "Can't find Configuration Description: " + this.getId()));
        }

        public String getName() {
            return this.name;
        }

        public IProject getProject() {
            return this.project;
        }
    }
}

