/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.core.imports;

import com.nxp.s32ds.cle.cdt.project.info.core.imports.PIReader;
import com.nxp.s32ds.cle.cdt.project.info.core.imports.processors.IOptionProcessor;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.PIActivator;
import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ProjectInfoImportSettings {
    private static final String ATTR_ID = "id";
    private static final String ATTR_TC = "toolchain";
    private static final String ATTR_CL = "class";
    private String projectName = "";
    private PIReader piReader;
    private WritableValue<Long> observableUpdateNeeded;
    private IProjectType selectedProjectType;
    private boolean initialState = true;
    private LaunchConfigurationCreator creator;
    private IConfiguration configuration;

    public ProjectInfoImportSettings() {
        if (Realm.getDefault() != null) {
            this.observableUpdateNeeded = WritableValue.withValueType(Long.class);
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.initialState = false;
        this.projectName = projectName;
    }

    public PIReader getPiReader() {
        return this.piReader;
    }

    public void setPiReader(PIReader piReader) {
        this.initialState = false;
        this.piReader = piReader;
        if (this.observableUpdateNeeded != null) {
            this.observableUpdateNeeded.setValue((Object)System.currentTimeMillis());
        }
    }

    public void setSelectedProjectType(IProjectType selectedProjectType) {
        this.selectedProjectType = selectedProjectType;
    }

    public IProjectType getSelectedProjectType() {
        return this.selectedProjectType;
    }

    public WritableValue<Long> getObservableUpdaterValue() {
        return this.observableUpdateNeeded;
    }

    private static List<IOptionProcessor> createConverterList(IToolChain tc) {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(PIActivator.getDefault().getBundleId()) + ".piToolChainOptionProcessor");
        if (ep == null) {
            return Collections.emptyList();
        }
        ArrayList<IOptionProcessor> result = new ArrayList<IOptionProcessor>();
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ex = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ex.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement cfgE = iConfigurationElementArray[n4];
                IConfigurationElement[] iConfigurationElementArray2 = cfgE.getChildren(ATTR_TC);
                int n5 = iConfigurationElementArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    IConfigurationElement tcE = iConfigurationElementArray2[n6];
                    String tcId = tcE.getAttribute(ATTR_ID);
                    if (tcId != null && tc != null && (tcId.equals(tc.getId()) || tc.getSuperClass() != null && tcId.equals(tc.getSuperClass().getId()))) {
                        try {
                            IOptionProcessor proc = (IOptionProcessor)cfgE.createExecutableExtension(ATTR_CL);
                            result.add(proc);
                        }
                        catch (CoreException e) {
                            PIActivator.getDefault().log(e.getStatus());
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    public IOptionProcessor getSelectedToolChainOptionProcessor(IToolChain tc) {
        return ProjectInfoImportSettings.createConverterList(tc).stream().findFirst().orElse(null);
    }

    public boolean isInitialState() {
        return this.initialState;
    }

    public String getDebugConfigurationName() {
        return this.configuration.getName();
    }

    public LaunchConfigurationCreator getLCCreator() {
        return this.creator;
    }

    public void setLCCreator(LaunchConfigurationCreator creator) {
        this.creator = creator;
    }

    public void setBuildConfiguration(IConfiguration configuration) {
        this.configuration = configuration;
    }

    public IConfiguration getConfiguration() {
        return this.configuration;
    }
}

