/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.project.info.core.exports.toolchains;

import com.nxp.s32ds.cle.cdt.project.info.core.exports.toolchains.GDBToolChainExporter;
import com.nxp.s32ds.cle.cdt.project.info.core.internal.PIActivator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class FreescaleS32DSToolChainExporter
extends GDBToolChainExporter {
    private static final String TOOL_C_LINKER = "tool.c.linker";
    private static final String TOOL_ASSEMBLER = "tool.assembler";
    private static final String TOOL_C_COMPILER = "tool.c.compiler";
    public static final String CPP_LINKER_PATTERN = "tool.cpp.linker";
    public static final String C_LINKER_PATTERN = "tool.c.linker";
    public static final String CPP_LINK_OPTION_LIBS = "gnu.cpp.link.option.libs";
    public static final String C_LINK_OPTION_LIBS = "gnu.c.link.option.libs";
    public static final String CPP_LINK_OPTION_PATHS = "gnu.cpp.link.option.paths";
    public static final String C_LINK_OPTION_PATHS = "gnu.c.link.option.paths";
    public static final String CDT_C_LINKER_ID = "cdt.managedbuild.tool.gnu.cross.c.linker";
    public static final String CDT_CPP_LINKER_ID = "cdt.managedbuild.tool.gnu.cross.cpp.linker";
    public static final String SPT_ASSEMBLER_PATTERN = "tool.spt.assembler";
    private static final String ATTR_ID = "id";
    private static final String ATTR_TC = "toolchain";
    private static final Set<String> toolchainsSuitable = new HashSet<String>();

    public FreescaleS32DSToolChainExporter() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(PIActivator.getDefault().getBundleId()) + ".toolchainsSuitable");
        if (ep != null) {
            IExtension[] iExtensionArray = ep.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] ces;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ces = ext.getConfigurationElements();
                int n3 = ces.length;
                int n4 = 0;
                while (n4 < n3) {
                    String tcid;
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    if (ATTR_TC.equals(ce.getName()) && (tcid = ce.getAttribute(ATTR_ID)) != null) {
                        toolchainsSuitable.add(tcid);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean isLinker(ITool tool) {
        return tool.getId().contains("tool.c.linker");
    }

    @Override
    public boolean isAssembler(ITool tool) {
        return tool.getId().contains(TOOL_ASSEMBLER);
    }

    @Override
    public boolean isCCompiler(ITool tool) {
        return tool.getId().contains(TOOL_C_COMPILER);
    }

    @Override
    public boolean isSptAssembler(ITool tool) {
        return tool.getId().contains(SPT_ASSEMBLER_PATTERN);
    }

    @Override
    public boolean isFits(IToolChain toolchain) {
        String extToolthainId = toolchain.getId();
        for (String toolchainId : toolchainsSuitable) {
            if (!extToolthainId.startsWith(toolchainId)) continue;
            return true;
        }
        return false;
    }
}

