/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.volkano.ui;

import com.nxp.s32ds.cle.runtime.storage.sensitive.info.StorageDispatcher;
import com.nxp.s32ds.cle.runtime.storage.sensitive.info.StorageDispatchers;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.S32DebuggerSecureData;
import com.nxp.s32ds.debug.ide.volkano.CommandBuilder;
import com.nxp.s32ds.debug.ide.volkano.CommandExecutor;
import com.nxp.s32ds.debug.ide.volkano.VolkanoDescriptor;
import com.nxp.s32ds.debug.ide.volkano.VolkanoRepresenter;
import com.nxp.s32ds.debug.ide.volkano.VolkanoUtil;
import com.nxp.s32ds.debug.ide.volkano.internal.ui.SmartCardCommand;
import com.nxp.s32ds.debug.ide.volkano.internal.ui.VolkanoActivator;
import com.nxp.s32ds.debug.ide.volkano.internal.ui.VolkanoAppletVersions;
import com.nxp.s32ds.debug.ide.volkano.internal.ui.VolkanoTypes;
import com.nxp.s32ds.debug.ide.volkano.internal.ui.VolkanoUIMessage;
import com.nxp.s32ds.debug.ide.volkano.internal.ui.VolkanoWorkingModes;
import com.nxp.s32ds.debug.ide.volkano.ui.UpdatePasswordDialog;
import com.nxp.s32ds.debug.ide.volkano.ui.VolkanoRegisterDialog;
import com.nxp.s32ds.debug.ide.volkano.ui.VolkanoSettingsDialog;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class VolkanoViewPart
extends ViewPart {
    private static final String EMPTY_SPLITTER = " ";
    private static final String DOTS_SPLITTER = " : ";
    protected static final String PLUS_SPLITTER = " + ";
    private static final String EMPTY_STRING = "";
    private static final String OUTPUT_PARSE_KEY = "key";
    private static final String LINE_NUMBER_REGEX = "#\\d*\\s?";
    private static final String APPLET_VERSION_LINE_MARKER = "applet version";
    private static final String CARD_DISCONNECTED_MARKER = "smart card disconnected";
    private static final String CARD_INITIALIZED_MARKER = "wrapping key available";
    private static final String CARD_INITIALIZED_CONSTANT = "yes";
    private static final String SC_PASSWORD_STORAGE = "sc_password";
    private static final String WORKING_MODE = "WORKING_MODE";
    private Composite base;
    private Composite baseTools;
    private Label lblCurrentWorkingMode;
    private TableViewer tableView;
    private Button btnRegister;
    private Button btnExportWK;
    private Button btnRenewDatabase;
    private Button btnRefresh;
    private Button btnDelete;
    private Button btnClearCache;
    private Button btnSetPwd;
    private Button btnSettings;
    private Group grpWrapKey;
    private Text txtWKey;
    private Collection<Button> btnControls;
    private CommandBuilder commandBuilder = VolkanoRepresenter.getCommandBuilder();
    private CommandExecutor commandExecutor = VolkanoRepresenter.getCommandExecutor();
    private List<VolkanoDescriptor> descriptors = new ArrayList<VolkanoDescriptor>();
    private VolkanoDescriptor activeMode = null;
    private Set<String> uidPlusTypeSet = new HashSet<String>();
    private float volkanoAppletVersion = VolkanoAppletVersions.v0.getVersion();
    private boolean isCardInitialised = false;
    private String SCPassword = "";
    private Path volkanoPath;
    private String volkanoLocation;
    private SmartCardCommand handleDiscover = () -> {
        IStatus status = Status.OK_STATUS;
        try {
            status = this.getSmartCardPassword();
            if (!status.isOK()) {
                return status;
            }
            status = this.commandExecutor.exec(this.commandBuilder.getBuilderDiscoverCommand(this.SCPassword));
            if (!status.isOK()) {
                this.updateWkGroupView(status.getMessage(), true);
                this.tableView.setInput(Collections.emptyList());
                return status;
            }
            List<String> items = this.retrieveItemsDiscoverOutput(this.commandExecutor.getOutput());
            if (items != null && !items.isEmpty()) {
                this.tableView.setInput(items);
            } else {
                this.tableView.setInput(Collections.emptyList());
            }
        }
        catch (IOException e) {
            status = new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", e.getMessage());
        }
        catch (CoreException e) {
            status = e.getStatus();
        }
        if (!status.isOK()) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)VolkanoUIMessage.Volkano_error_dialog_title, (String)status.getMessage());
        }
        return status;
    };
    private SmartCardCommand handleRefresh = () -> {
        if (this.execExportWrapKeyCommand().isOK()) {
            this.setWrapValue(this.commandExecutor.getOutput());
        }
        this.toggleButtons(true);
        return this.handleDiscover.run();
    };
    private SmartCardCommand handleExport = () -> {
        IStatus status = this.execExportWrapKeyCommand();
        if (!status.isOK()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)VolkanoUIMessage.Volkano_error_dialog_title, (String)status.getMessage());
        } else {
            this.setWrapValue(this.commandExecutor.getOutput());
            String msg = NLS.bind((String)VolkanoUIMessage.Volkano_export_key_info, (Object)this.commandBuilder.getDefaultWrapKeyPath());
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)VolkanoUIMessage.Volkano_export_dilaog_title, (String)msg);
        }
        return status;
    };
    private SmartCardCommand handleRegister = () -> {
        VolkanoRegisterDialog dialog = new VolkanoRegisterDialog(Display.getDefault().getActiveShell(), VolkanoUIMessage.Volkano_command_dialog_title, this.uidPlusTypeSet);
        dialog.open();
        if (dialog.isCancelled()) {
            return Status.CANCEL_STATUS;
        }
        String key = dialog.getKey();
        String uid = dialog.getUid();
        String registerType = dialog.getRegisterType();
        if (key == null || key.isEmpty() || uid == null || uid.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        IStatus status = Status.OK_STATUS;
        if (VolkanoTypes.ADKP_VALUE.getName().equals(registerType)) {
            status = this.execRegisterAdkpCommand(key, this.commandBuilder.getDefaultWrapKeyFileName(), uid);
        } else if (VolkanoTypes.KUID_VALUE.getName().equals(registerType)) {
            status = this.execRegisterKuidCommand(key, uid);
        } else if (VolkanoTypes.ADKP_WRAPPED_FILE.getName().equals(registerType)) {
            status = this.execRegisterWrappedAdkpCommand(key, uid);
        } else if (VolkanoTypes.KUID_FILE.getName().equals(registerType)) {
            status = this.execRegisterKuidCommand(key, uid);
        }
        if (!status.isOK()) {
            if (status.getCode() == 1) {
                return status;
            }
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)VolkanoUIMessage.Volkano_error_dialog_title, (String)status.getMessage());
            return status;
        }
        status = this.execWithSmartCard(this.handleDiscover);
        return status;
    };
    private SmartCardCommand handleDelete = () -> {
        IStatus status = Status.OK_STATUS;
        if (this.volkanoAppletVersion >= VolkanoAppletVersions.v1_3.getVersion()) {
            boolean confirm = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)VolkanoUIMessage.Volkano_command_dialog_title, (String)VolkanoUIMessage.Volkano_confirm_delete_msg);
            if (!confirm) {
                status = Status.CANCEL_STATUS;
            }
            ISelection selections = this.tableView.getSelection();
            String[] stringArray = selections.toString().split(", ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String selection = stringArray[n2];
                String uid = selection.split(EMPTY_SPLITTER)[2];
                status = this.deleteRecord(uid);
                ++n2;
            }
        } else {
            status = new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", NLS.bind((String)VolkanoUIMessage.Volkano_applet_command_not_supported, (Object)String.valueOf(this.volkanoAppletVersion)));
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)VolkanoUIMessage.Volkano_error_dialog_title, (String)VolkanoUIMessage.Volkano_error_deleting_record, (IStatus)status);
        }
        return status;
    };

    public void createPartControl(Composite parent) {
        this.base = new Composite(parent, 2048);
        this.base.setLayout((Layout)new GridLayout(2, false));
        this.base.setLayoutData((Object)new GridData(4, 4, false, false));
        if (!"win32".equals(Platform.getOS())) {
            Display display = Display.getDefault();
            display.asyncExec(() -> MessageDialog.openError((Shell)display.getActiveShell(), (String)VolkanoUIMessage.Volkano_error_dialog_title, (String)VolkanoUIMessage.Volkano_no_linux_support));
            return;
        }
        Composite currentWorkingMode = new Composite(this.base, 2048);
        currentWorkingMode.setLayout((Layout)new GridLayout(6, false));
        currentWorkingMode.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        GridData dataControl = new GridData(4, 4, false, false, 1, 1);
        dataControl.widthHint = 152;
        this.descriptors = VolkanoRepresenter.getDescriptors();
        try {
            this.volkanoPath = Paths.get(DebuggerUtils.substitute((String)((VolkanoDescriptor)this.descriptors.stream().filter(d -> d.getMode().equalsIgnoreCase("APPLICATION")).collect(Collectors.toList()).get(0)).getLocation()), "vlk_config.ini");
            this.volkanoLocation = this.volkanoPath.toString();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            VolkanoActivator.getBundle().logError(ex.getMessage());
        }
        Label lblWorkingMode = new Label(currentWorkingMode, 0);
        lblWorkingMode.setText(VolkanoUIMessage.Volkano_label_current_working_mode);
        lblWorkingMode.setLayoutData((Object)dataControl);
        GridData dataWorkingMode = new GridData(4, 4, false, false, 1, 1);
        dataWorkingMode.widthHint = 120;
        this.lblCurrentWorkingMode = new Label(currentWorkingMode, 0);
        this.lblCurrentWorkingMode.setText(VolkanoUtil.getValueFromFile((String)this.volkanoLocation, (String)WORKING_MODE).toUpperCase());
        this.lblCurrentWorkingMode.setLayoutData((Object)dataWorkingMode);
        this.tableView = new TableViewer(this.base, 65538);
        this.tableView.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.tableView.getTable().setHeaderVisible(true);
        this.tableView.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableView.addSelectionChangedListener(event -> this.btnDelete.setEnabled(!event.getSelection().isEmpty()));
        this.tableView.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.keyCode == 127 && VolkanoViewPart.this.btnDelete.isEnabled()) {
                    VolkanoViewPart.this.btnDelete.notifyListeners(13, new Event());
                }
            }
        });
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableView, this.createColumn(VolkanoUIMessage.Volkano_table_col_num, 50));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String source;
                String[] results;
                if (element instanceof String && (results = (source = (String)element).split(VolkanoViewPart.EMPTY_SPLITTER)).length > 4) {
                    return results[0];
                }
                return VolkanoViewPart.EMPTY_STRING;
            }
        });
        viewerColumn = new TableViewerColumn(this.tableView, this.createColumn(VolkanoUIMessage.Volkano_table_col_uid, 200));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String source = (String)element;
                String[] results = source.split(VolkanoViewPart.EMPTY_SPLITTER);
                if (results.length > 4) {
                    return results[2];
                }
                return VolkanoViewPart.EMPTY_STRING;
            }
        });
        viewerColumn = new TableViewerColumn(this.tableView, this.createColumn(VolkanoUIMessage.Volkano_table_col_type, 100));
        viewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String source = (String)element;
                String[] results = source.split(VolkanoViewPart.EMPTY_SPLITTER);
                StringBuilder builder = new StringBuilder();
                int i = 4;
                while (i < results.length) {
                    builder.append(results[i]).append(VolkanoViewPart.EMPTY_SPLITTER);
                    ++i;
                }
                return builder.toString();
            }
        });
        this.createColumn(VolkanoUIMessage.Volkano_table_col_description, 500);
        GridData baseToolsData = new GridData(4, 4, false, false, 2, 1);
        baseToolsData.heightHint = 40;
        GridData btnData = new GridData(4, 4, false, false, 1, 1);
        btnData.heightHint = 26;
        btnData.widthHint = 120;
        GridData settingsbtnData = new GridData(0x1000008, 0x1000000, true, false, 1, 1);
        settingsbtnData.heightHint = 26;
        settingsbtnData.widthHint = 120;
        this.grpWrapKey = new Group(this.base, 0);
        GridData grpWrapKeyGrid = new GridData(4, 4, true, false, 2, 1);
        grpWrapKeyGrid.heightHint = 90;
        this.grpWrapKey.setLayoutData((Object)grpWrapKeyGrid);
        this.grpWrapKey.setLayout((Layout)new GridLayout(1, false));
        this.grpWrapKey.setText(VolkanoUIMessage.Volkano_grp_wrap_key);
        this.txtWKey = new Text((Composite)this.grpWrapKey, 72);
        this.txtWKey.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.baseTools = new Composite(this.base, 2048);
        this.baseTools.setLayout((Layout)new GridLayout(7, false));
        this.baseTools.setLayoutData((Object)baseToolsData);
        this.btnControls = new HashSet<Button>();
        this.btnRefresh = new Button(this.baseTools, 8);
        this.btnRefresh.setText(VolkanoUIMessage.Volkano_btn_refresh);
        this.btnRefresh.setLayoutData((Object)btnData);
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VolkanoViewPart.this.tableView.setInput(Collections.emptyList());
                VolkanoViewPart.this.execWithSmartCard(VolkanoViewPart.this.handleRefresh);
            }
        });
        this.btnControls.add(this.btnRefresh);
        this.btnClearCache = new Button(this.baseTools, 8);
        this.btnClearCache.setText(VolkanoUIMessage.Volkano_btn_clear_cache);
        this.btnClearCache.setLayoutData((Object)btnData);
        this.btnClearCache.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VolkanoViewPart.this.SCPassword = VolkanoViewPart.EMPTY_STRING;
                StorageDispatchers.getStorageDispatcher().resetProtectedSettings("com.nxp.s32ds.debug.ide.volkano.ui");
                VolkanoViewPart.this.btnClearCache.setEnabled(false);
            }
        });
        this.btnControls.add(this.btnClearCache);
        this.btnSetPwd = new Button(this.baseTools, 8);
        this.btnSetPwd.setText(VolkanoUIMessage.Volkano_btn_upd_pwd);
        this.btnSetPwd.setLayoutData((Object)btnData);
        this.btnSetPwd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    VolkanoViewPart.this.commandExecutor.exec(VolkanoViewPart.this.commandBuilder.getBuilderFetchVersionCmd());
                    VolkanoViewPart.this.fetchAppletInfo(VolkanoViewPart.this.commandExecutor.getOutput());
                    if (VolkanoViewPart.this.volkanoAppletVersion > VolkanoAppletVersions.v0.getVersion()) {
                        if (VolkanoViewPart.this.isCardInitialised) {
                            UpdatePasswordDialog dialog = new UpdatePasswordDialog(Display.getDefault().getActiveShell());
                            dialog.open();
                            String currentPwd = dialog.getInput1();
                            String newPwd = dialog.getInput2();
                            String confirmedPwd = dialog.getConfirmedPassword();
                            if (!(currentPwd.isEmpty() || newPwd.isEmpty() || confirmedPwd.isEmpty())) {
                                Object status = newPwd.equals(confirmedPwd) ? VolkanoViewPart.this.execWithSmartCard(() -> VolkanoViewPart.this.execUpdatePasswordCommand(currentPwd, newPwd)) : new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", VolkanoUIMessage.Volkano_passwords_do_not_match);
                                if (status.isOK()) {
                                    if (VolkanoViewPart.this.btnClearCache.isEnabled()) {
                                        VolkanoViewPart.this.btnClearCache.notifyListeners(13, new Event());
                                    }
                                    VolkanoViewPart.this.btnSetPwd.setText(VolkanoUIMessage.Volkano_btn_upd_pwd);
                                    VolkanoViewPart.this.tableView.setInput(Collections.emptyList());
                                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)VolkanoUIMessage.Volkano_change_password_dialog, (String)VolkanoUIMessage.Volkano_change_password_message);
                                } else {
                                    VolkanoViewPart.this.updateWkGroupView(status.getMessage(), true);
                                }
                            }
                        } else {
                            VolkanoViewPart.this.commandExecutor.exec(VolkanoViewPart.this.commandBuilder.getBuilderGenerateWrapKeyCmd());
                            IStatus status = VolkanoViewPart.this.setInitialSmartCardPassword();
                            if (status.isOK()) {
                                VolkanoViewPart.this.toggleButtons(true);
                                VolkanoViewPart.this.btnSetPwd.setText(VolkanoUIMessage.Volkano_btn_upd_pwd);
                                if (VolkanoViewPart.this.btnClearCache.isEnabled()) {
                                    VolkanoViewPart.this.btnClearCache.notifyListeners(13, new Event());
                                }
                                VolkanoViewPart.this.execWithSmartCard(() -> {
                                    IStatus sts = VolkanoViewPart.this.execExportWrapKeyCommand();
                                    if (sts.isOK()) {
                                        VolkanoViewPart.this.setWrapValue(VolkanoViewPart.this.commandExecutor.getOutput());
                                    }
                                    return sts;
                                });
                                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)VolkanoUIMessage.Volkano_smartcard_setup_info_title, (String)VolkanoUIMessage.Volkano_smartcard_successfully_set_up);
                            } else if (status.matches(4)) {
                                VolkanoViewPart.this.commandExecutor.exec(VolkanoViewPart.this.commandBuilder.getBuilderFetchVersionCmd());
                                VolkanoViewPart.this.fetchAppletInfo(VolkanoViewPart.this.commandExecutor.getOutput());
                                if (VolkanoViewPart.this.volkanoAppletVersion > VolkanoAppletVersions.v0.getVersion()) {
                                    VolkanoViewPart.this.updateWkGroupView(status.getMessage(), true);
                                } else {
                                    VolkanoViewPart.this.showDetectedError(VolkanoUIMessage.Volkano_error_no_smartcard_detected);
                                }
                            }
                        }
                    } else {
                        VolkanoViewPart.this.showDetectedError(VolkanoUIMessage.Volkano_error_no_smartcard_detected);
                    }
                }
                catch (IOException ex) {
                    VolkanoViewPart.this.updateWkGroupView(ex.getMessage(), true);
                }
                catch (CoreException ex) {
                    VolkanoViewPart.this.updateWkGroupView(ex.getStatus().getMessage(), true);
                }
            }
        });
        this.btnControls.add(this.btnSetPwd);
        this.btnExportWK = new Button(this.baseTools, 8);
        this.btnExportWK.setText(VolkanoUIMessage.Volkano_btn_export_wrap_key);
        this.btnExportWK.setLayoutData((Object)btnData);
        this.btnExportWK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VolkanoViewPart.this.execWithSmartCard(VolkanoViewPart.this.handleExport);
            }
        });
        this.btnControls.add(this.btnExportWK);
        this.btnRegister = new Button(this.baseTools, 8);
        this.btnRegister.setText(VolkanoUIMessage.Volkano_btn_register_key);
        this.btnRegister.setLayoutData((Object)btnData);
        this.btnRegister.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VolkanoViewPart.this.execWithSmartCard(VolkanoViewPart.this.handleRegister);
            }
        });
        this.btnControls.add(this.btnRegister);
        this.btnDelete = new Button(this.baseTools, 8);
        this.btnDelete.setText(VolkanoUIMessage.Volkano_btn_delete);
        this.btnDelete.setLayoutData((Object)btnData);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VolkanoViewPart.this.execWithSmartCard(VolkanoViewPart.this.handleDelete);
            }
        });
        this.btnDelete.setEnabled(false);
        this.btnControls.add(this.btnDelete);
        this.btnSettings = new Button(this.baseTools, 8);
        this.btnSettings.setText(VolkanoUIMessage.Volkano_btn_settings);
        this.btnSettings.setLayoutData((Object)settingsbtnData);
        this.btnSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VolkanoSettingsDialog dialog = new VolkanoSettingsDialog(Display.getDefault().getActiveShell());
                dialog.open();
                if (!dialog.isCanceled()) {
                    VolkanoViewPart.this.lblCurrentWorkingMode.setText(VolkanoUtil.getValueFromFile((String)VolkanoViewPart.this.volkanoLocation, (String)VolkanoViewPart.WORKING_MODE).toUpperCase());
                }
                VolkanoViewPart.this.invalidateUI();
                VolkanoViewPart.this.base.layout();
            }
        });
        this.btnRenewDatabase = new Button(this.baseTools, 8);
        this.btnRenewDatabase.setText(VolkanoUIMessage.Volkano_btn_renew_database);
        this.btnRenewDatabase.setLayoutData((Object)btnData);
        this.btnRenewDatabase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean result = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)VolkanoUIMessage.Volkano_command_dialog_title, (String)VolkanoUIMessage.Volkano_confirmation_db_renew);
                if (result) {
                    IStatus status = VolkanoViewPart.this.removeDataBase();
                    VolkanoViewPart.this.uidPlusTypeSet.clear();
                    if (!status.isOK()) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)VolkanoUIMessage.Volkano_error_dialog_title, (String)status.getMessage());
                    } else {
                        VolkanoViewPart.this.handleDiscover.run();
                        VolkanoViewPart.this.btnExportWK.notifyListeners(13, new Event());
                    }
                }
            }
        });
        this.btnRenewDatabase.setEnabled(false);
        this.btnRenewDatabase.setVisible(false);
        this.btnControls.add(this.btnRenewDatabase);
        Dialog.applyDialogFont((Control)this.base);
        this.fillControls();
        this.tableView.setInput(new ArrayList());
        this.updateWkGroupView(EMPTY_STRING, false);
        this.activeMode = this.descriptors.get(0);
        this.uidPlusTypeSet.clear();
        try {
            this.commandBuilder = VolkanoRepresenter.createCommandBuilder((String)this.activeMode.getLocation());
            this.commandBuilder.resolveEnvironment();
        }
        catch (CoreException e1) {
            this.updateWkGroupView(e1.getStatus().getMessage(), true);
        }
        this.invalidateUI();
    }

    private IStatus execExportWrapKeyCommand() {
        IStatus status = Status.OK_STATUS;
        try {
            status = this.commandExecutor.exec(this.commandBuilder.getBuilderExportWrapKeyCmd());
        }
        catch (IOException e) {
            return new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return status;
    }

    private IStatus deleteRecord(String uid) {
        IStatus status = this.execDeleteRecordCommand(uid);
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)VolkanoUIMessage.Volkano_error_dialog_title, (String)VolkanoUIMessage.Volkano_error_deleting_record, (IStatus)status);
        } else {
            this.btnRefresh.notifyListeners(13, new Event());
            this.uidPlusTypeSet.removeIf(item -> item.contains(uid));
        }
        return status;
    }

    private void fillControls() {
        if (!"win32".equals(Platform.getOS())) {
            this.btnControls.forEach(button -> button.setEnabled(false));
            Display display = Display.getDefault();
            display.asyncExec(() -> MessageDialog.openError((Shell)display.getActiveShell(), (String)VolkanoUIMessage.Volkano_error_dialog_title, (String)VolkanoUIMessage.Volkano_no_linux_support));
        } else {
            this.descriptors = VolkanoRepresenter.getDescriptors();
            this.descriptors.sort(new Comparator<VolkanoDescriptor>(){

                @Override
                public int compare(VolkanoDescriptor o1, VolkanoDescriptor o2) {
                    return o1.getMode().compareTo(o2.getMode());
                }
            });
        }
    }

    private void setWrapValue(List<String> input) {
        try {
            String[] wrapKey = input.get(1).split(DOTS_SPLITTER);
            this.updateWkGroupView(wrapKey[1], false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.showDetectedError(VolkanoUIMessage.Volkano_error_no_smartcard_detected);
        }
    }

    private TableColumn createColumn(String name, int size) {
        TableColumn column = new TableColumn(this.tableView.getTable(), 0);
        column.setText(name);
        column.setWidth(size);
        return column;
    }

    public void setFocus() {
        if (this.btnRegister != null && !this.btnRegister.isDisposed()) {
            this.btnRegister.setFocus();
        }
    }

    private void toggleButtons(boolean enable) {
        this.btnSetPwd.setEnabled(enable);
        this.btnRegister.setEnabled(enable);
        this.btnExportWK.setEnabled(enable);
    }

    private IStatus execWithSmartCard(SmartCardCommand command) {
        if (this.lblCurrentWorkingMode.getText().equalsIgnoreCase(VolkanoWorkingModes.SERVER_MODE.getName())) {
            return new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", VolkanoUIMessage.Volkano_error_server_mode);
        }
        IStatus status = Status.OK_STATUS;
        try {
            status = this.commandExecutor.exec(this.commandBuilder.getBuilderFetchVersionCmd());
            this.fetchAppletInfo(this.commandExecutor.getOutput());
            if (this.volkanoAppletVersion > VolkanoAppletVersions.v0.getVersion()) {
                if (this.isCardInitialised) {
                    status = command.run();
                } else {
                    if (this.btnClearCache.isEnabled()) {
                        this.btnClearCache.notifyListeners(13, new Event());
                    }
                    this.tableView.setInput(Collections.emptyList());
                    this.toggleButtons(false);
                    this.btnSetPwd.setEnabled(true);
                    this.btnSetPwd.setText(VolkanoUIMessage.Volkano_btn_set_pwd);
                    this.updateWkGroupView(VolkanoUIMessage.Volkano_smartcard_setup_incomplete, true);
                }
            } else {
                this.showDetectedError(VolkanoUIMessage.Volkano_error_no_smartcard_detected);
                status = new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", VolkanoUIMessage.Volkano_error_no_smartcard_detected);
            }
        }
        catch (IOException e) {
            status = new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            status = e.getStatus();
        }
        return status;
    }

    private IStatus execRegisterAdkpCommand(String key, String wrapFile, String uid) {
        try {
            IStatus status = this.commandExecutor.exec(this.commandBuilder.getBuilderCreateWrapingADKPCmd(key, wrapFile));
            if (!status.isOK()) {
                return status;
            }
            String wrapAdkp = VolkanoViewPart.retrieveFormOutput(this.commandExecutor.getOutput(), OUTPUT_PARSE_KEY);
            if (wrapAdkp == null || wrapAdkp.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            status = this.getSmartCardPassword();
            if (!status.isOK()) {
                return status;
            }
            status = this.commandExecutor.exec(this.commandBuilder.getBuilderRegisterAdkpByUidCmd(uid, wrapAdkp, this.SCPassword));
            if (!status.isOK()) {
                return status;
            }
        }
        catch (IOException e) {
            return new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private IStatus execRegisterWrappedAdkpCommand(String wrapAdkp, String uid) {
        try {
            IStatus status = this.getSmartCardPassword();
            if (!status.isOK()) {
                return status;
            }
            status = this.commandExecutor.exec(this.commandBuilder.getBuilderRegisterAdkpByUidCmd(uid, wrapAdkp, this.SCPassword));
            if (!status.isOK()) {
                return status;
            }
        }
        catch (IOException e) {
            return new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private IStatus execRegisterKuidCommand(String key, String uid) {
        try {
            IStatus status = this.getSmartCardPassword();
            if (!status.isOK()) {
                return status;
            }
            status = this.commandExecutor.exec(this.commandBuilder.getBuilderRegisterKuidByUidCmd(uid, key, this.SCPassword));
            if (!status.isOK()) {
                return status;
            }
        }
        catch (IOException e) {
            return new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private IStatus execUpdatePasswordCommand(String currentPwd, String newPwd) {
        try {
            return this.commandExecutor.exec(this.commandBuilder.getBuilderChangePassword(currentPwd, newPwd));
        }
        catch (IOException ex) {
            return new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", ex.getMessage(), (Throwable)ex);
        }
        catch (CoreException ex) {
            return ex.getStatus();
        }
    }

    private IStatus execDeleteRecordCommand(String uid) {
        try {
            IStatus status = this.commandExecutor.exec(this.commandBuilder.getBuilderDeleteRecordByUidCmd(uid, this.SCPassword));
            if (!status.isOK()) {
                return status;
            }
        }
        catch (IOException e) {
            return new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    private IStatus removeDataBase() {
        return this.commandBuilder.performRemoveDataBase();
    }

    private static String retrieveFormOutput(List<String> output, String string) {
        if (output.size() >= 2) {
            return output.get(1);
        }
        return EMPTY_STRING;
    }

    private List<String> retrieveItemsDiscoverOutput(List<String> output) {
        ArrayList<String> result = new ArrayList<String>();
        if (output.size() < 3) {
            return result;
        }
        int i = 2;
        while (i < output.size()) {
            String item = VolkanoViewPart.formatItem(output.get(i));
            this.fillUidTypeSet(item);
            result.add(item);
            ++i;
        }
        return result;
    }

    private boolean fetchAppletInfo(List<String> output) throws NumberFormatException {
        this.volkanoAppletVersion = VolkanoAppletVersions.v0.getVersion();
        this.isCardInitialised = false;
        boolean ret = false;
        for (String line : output) {
            if (line.toLowerCase().contains(CARD_DISCONNECTED_MARKER)) {
                ret = false;
                break;
            }
            if (line.toLowerCase().contains(APPLET_VERSION_LINE_MARKER)) {
                this.volkanoAppletVersion = Float.valueOf(line.split(DOTS_SPLITTER)[1]).floatValue();
                ret = true;
            }
            if (!line.toLowerCase().contains(CARD_INITIALIZED_MARKER)) continue;
            this.isCardInitialised = line.split(DOTS_SPLITTER)[1].equalsIgnoreCase(CARD_INITIALIZED_CONSTANT);
            ret = true;
        }
        return ret;
    }

    protected IStatus getSmartCardPassword() {
        if (!this.SCPassword.isEmpty()) {
            return Status.OK_STATUS;
        }
        StorageDispatcher dispatcher = StorageDispatchers.getStorageDispatcher();
        this.getCachedPassword(dispatcher);
        if (this.SCPassword.isEmpty()) {
            try {
                RcpStatusHandler handler = RcpStatusHandlers.getStatusHandlerService().getStatusHandler("com.nxp.s32ds.debug.ide.ui.handlers.smartCardPasswordStatusHandler");
                if (handler == null) {
                    return new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", VolkanoUIMessage.Volkano_error_cannot_open_smart_card_password_dialog);
                }
                Object result = handler.handleStatus(null, (Object)this);
                if (result instanceof S32DebuggerSecureData) {
                    this.SCPassword = ((S32DebuggerSecureData)result).getKeyWord();
                    if (this.SCPassword.isEmpty()) {
                        return Status.CANCEL_STATUS;
                    }
                    return this.cachePassword(dispatcher, this.SCPassword);
                }
            }
            catch (CoreException ex) {
                return ex.getStatus();
            }
        }
        return Status.OK_STATUS;
    }

    protected IStatus setInitialSmartCardPassword() {
        Object status = Status.OK_STATUS;
        try {
            UpdatePasswordDialog dialog = new UpdatePasswordDialog(Display.getDefault().getActiveShell(), VolkanoUIMessage.Volkano_enter_password_message, VolkanoUIMessage.Volkano_label_confirm_password, true);
            dialog.open();
            String newPwd = dialog.getInput1();
            String confirmedPwd = dialog.getInput2();
            status = !newPwd.isEmpty() && !confirmedPwd.isEmpty() ? (newPwd.equals(confirmedPwd) ? this.commandExecutor.exec(this.commandBuilder.getBuilderSetInitialPassword(newPwd)) : new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", VolkanoUIMessage.Volkano_passwords_do_not_match)) : Status.CANCEL_STATUS;
        }
        catch (IOException e) {
            return new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return status;
    }

    private static String formatItem(String line) {
        Matcher m = Pattern.compile(LINE_NUMBER_REGEX).matcher(line);
        if (m.find()) {
            String lineNumber = m.group(0);
            String modified = line.replaceAll(LINE_NUMBER_REGEX, EMPTY_STRING);
            return String.valueOf(lineNumber) + modified;
        }
        return line;
    }

    private void updateWkGroupView(String message, boolean isError) {
        if (isError) {
            this.grpWrapKey.setText(VolkanoUIMessage.Volkano_grp_error);
        } else {
            this.grpWrapKey.setText(VolkanoUIMessage.Volkano_grp_wrap_key);
        }
        this.txtWKey.setText(message);
    }

    private IStatus cachePassword(StorageDispatcher dispatcher, String password) {
        if (dispatcher != null) {
            HashMap<String, String> configurationSettings = new HashMap<String, String>();
            configurationSettings.put(SC_PASSWORD_STORAGE, password);
            dispatcher.storeProtectedSettings("com.nxp.s32ds.debug.ide.volkano.ui", configurationSettings);
            this.btnClearCache.setEnabled(true);
            return Status.OK_STATUS;
        }
        return new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", VolkanoUIMessage.Volkano_no_storage_dispatcher_message);
    }

    private IStatus getCachedPassword(StorageDispatcher dispatcher) {
        if (dispatcher != null) {
            Map settings = dispatcher.getProtectedSettings("com.nxp.s32ds.debug.ide.volkano.ui");
            if (settings != null && settings.containsKey(SC_PASSWORD_STORAGE)) {
                this.SCPassword = (String)settings.get(SC_PASSWORD_STORAGE);
                return Status.OK_STATUS;
            }
            return new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", NLS.bind((String)VolkanoUIMessage.Volkano_error_missing_cache_entry, (Object)SC_PASSWORD_STORAGE));
        }
        return new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", VolkanoUIMessage.Volkano_no_storage_dispatcher_message);
    }

    private void fillUidTypeSet(String item) {
        boolean isCombinedType;
        String uidPlusType = VolkanoViewPart.retrieveUidAndType(item);
        boolean bl = isCombinedType = uidPlusType.indexOf(43) != uidPlusType.lastIndexOf(43);
        if (isCombinedType) {
            String[] splitted = uidPlusType.split(Pattern.quote(PLUS_SPLITTER));
            this.uidPlusTypeSet.add(String.valueOf(splitted[0]) + PLUS_SPLITTER + splitted[1]);
            this.uidPlusTypeSet.add(String.valueOf(splitted[0]) + PLUS_SPLITTER + splitted[2]);
        } else {
            this.uidPlusTypeSet.add(uidPlusType);
        }
    }

    private static String retrieveUidAndType(String string) {
        return Arrays.stream(string.split(EMPTY_SPLITTER)).skip(2L).collect(Collectors.joining(EMPTY_SPLITTER));
    }

    private void showDetectedError(String errorMessage) {
        this.toggleButtons(false);
        this.tableView.setInput(Collections.emptyList());
        this.updateWkGroupView(errorMessage, true);
    }

    private void invalidateUI() {
        IStatus status = this.execWithSmartCard(() -> {
            IStatus sts = this.execExportWrapKeyCommand();
            if (sts.isOK()) {
                this.setWrapValue(this.commandExecutor.getOutput());
            }
            return sts;
        });
        this.getCachedPassword(StorageDispatchers.getStorageDispatcher());
        if (this.SCPassword.isEmpty()) {
            this.btnClearCache.setEnabled(false);
        } else {
            status = this.execWithSmartCard(this.handleDiscover);
            this.btnClearCache.setEnabled(true);
        }
        if (status.isOK()) {
            this.toggleButtons(true);
        } else {
            this.showDetectedError(status.getMessage());
            this.toggleButtons(false);
        }
    }
}

