/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core.utils;

import com.nxp.s32ds.ext.rcp.p2.core.LockedFilesTracker;
import com.nxp.s32ds.ext.rcp.p2.core.UnnativeTouchpoint;
import com.nxp.s32ds.ext.rcp.p2.internal.core.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Util {
    public static final String ID = "org.eclipse.equinox.p2.repository";
    private static final String ACTION_COPY = "copy";
    private static final String ACTION_CLEANUPCOPY = "cleanupcopy";

    public static void logError(String message) {
        Util.log(4, message);
    }

    public static void logError(String message, Throwable t) {
        Util.log(4, message, t);
    }

    public static void logWarning(String message) {
        Util.log(2, message);
    }

    public static void log(int status, String message, Throwable t) {
        LogHelper.log((IStatus)Util.createMessage(status, message, t));
    }

    public static void log(int status, String message) {
        LogHelper.log((IStatus)Util.createMessage(status, message));
    }

    public static String getInstallFolder(IProfile profile) {
        String installFolder = profile.getProperty("org.eclipse.equinox.p2.installFolder");
        return installFolder;
    }

    public static IStatus createErrorMessage(String message) {
        Status errorStatus = new Status(4, ID, message);
        return errorStatus;
    }

    private static IAgentLocation getAgentLocation(IProvisioningAgent provisioningAgent) {
        IAgentLocation agentLocation = (IAgentLocation)provisioningAgent.getService(IAgentLocation.SERVICE_NAME);
        return agentLocation;
    }

    public static IStatus createMessage(int status, String message, Throwable t) {
        Status messageStatus = new Status(status, ID, message, t);
        return messageStatus;
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager(IProvisioningAgent provisioningAgent) {
        IArtifactRepositoryManager repositoryManager = (IArtifactRepositoryManager)provisioningAgent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        return repositoryManager;
    }

    public static IStatus createMessage(int status, String message) {
        Status messageStatus = new Status(status, ID, message);
        return messageStatus;
    }

    public static IFileArtifactRepository getDownloadCacheRepo(IProvisioningAgent provisioningAgent) throws ProvisionException {
        URI cacheLocation = Util.getDownloadCacheLocation(provisioningAgent);
        if (cacheLocation == null) {
            throw new IllegalStateException(Messages.could_not_obtain_download_cache);
        }
        IArtifactRepositoryManager repoManager = Util.getArtifactRepositoryManager(provisioningAgent);
        if (repoManager == null) {
            throw new IllegalStateException(Messages.artifact_repo_not_found);
        }
        IFileArtifactRepository artifactRepository = (IFileArtifactRepository)Util.getArtifactRepository(repoManager, cacheLocation).getAdapter(IFileArtifactRepository.class);
        if (artifactRepository == null) {
            throw new ProvisionException(NLS.bind((String)Messages.download_cache_not_writeable, (Object)cacheLocation));
        }
        return artifactRepository;
    }

    private static IArtifactRepository getArtifactRepository(IArtifactRepositoryManager manager, URI location) throws ProvisionException {
        IArtifactRepository repository;
        try {
            repository = manager.loadRepository(location, null);
        }
        catch (ProvisionException provisionException) {
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("p2.system", Boolean.TRUE.toString());
            repository = manager.createRepository(location, NLS.bind((String)Messages.Util_agent_download_cache, (Object)location), "org.eclipse.equinox.p2.artifact.repository.simpleRepository", properties);
        }
        return repository;
    }

    private static URI getDownloadCacheLocation(IProvisioningAgent agent) {
        IAgentLocation location = Util.getAgentLocation(agent);
        if (location != null) {
            URI dataArea = location.getDataArea("org.eclipse.equinox.p2.core");
            return org.eclipse.core.runtime.URIUtil.append((URI)dataArea, (String)"cache/");
        }
        return null;
    }

    public static int copyStream(InputStream in, boolean closeIn, OutputStream out, boolean closeOut) throws IOException {
        try {
            int len;
            int written = 0;
            byte[] buffer = new byte[16384];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                written += len;
            }
            int n = written;
            return n;
        }
        finally {
            try {
                if (closeIn) {
                    in.close();
                }
            }
            finally {
                if (closeOut) {
                    out.close();
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public static int copyFile(File srcFile, File destFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            int n;
            FileOutputStream fos;
            FileInputStream fis;
            block16: {
                block15: {
                    fis = new FileInputStream(srcFile);
                    fos = new FileOutputStream(destFile);
                    n = Util.copyStream(fis, true, fos, true);
                    if (fos == null) break block15;
                    fos.close();
                }
                if (fis == null) break block16;
                fis.close();
            }
            return n;
            {
                catch (Throwable throwable2) {
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (fis != null) {
                            fis.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static int appendStream(InputStream extra, boolean closeExtra, OutputStream base, boolean closeBase) throws IOException {
        try {
            int len;
            int written = 0;
            byte[] buffer = new byte[16384];
            while ((len = extra.read(buffer)) != -1) {
                base.write(buffer, 0, len);
                written += len;
            }
            int n = written;
            return n;
        }
        finally {
            try {
                if (closeExtra) {
                    extra.close();
                }
            }
            finally {
                if (closeBase) {
                    base.close();
                }
            }
        }
    }

    public int removeElement(File base, String element) {
        block3: {
            try {
                if (base.exists()) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(base);
                    TransformerFactory tFactory = TransformerFactory.newInstance();
                    Transformer tFormer = tFactory.newTransformer();
                    Element remElement = (Element)doc.getElementsByTagName(element).item(0);
                    remElement.getParentNode().removeChild(remElement);
                    doc.normalize();
                    DOMSource source = new DOMSource(doc);
                    StreamResult dest = new StreamResult(base);
                    tFormer.transform(source, dest);
                    break block3;
                }
                return 2;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 1;
    }

    public static String getTempFolder() {
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (!tmpdir.endsWith("/") && !tmpdir.endsWith("\\")) {
            tmpdir = String.valueOf(tmpdir) + File.separator;
        }
        return tmpdir;
    }

    public static int mergeXMLFiles(File baseXML, File extraXML) {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transFormer = transFactory.newTransformer();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document baseDoc = builder.parse(baseXML);
            Document extraDoc = builder.parse(extraXML);
            Element baseRoot = baseDoc.getDocumentElement();
            Element extraRoot = extraDoc.getDocumentElement();
            Util.mergeNodes(baseRoot, extraRoot);
            baseDoc.normalize();
            DOMSource source = new DOMSource(baseDoc);
            StreamResult dest = new StreamResult(baseXML);
            transFormer.transform(source, dest);
        }
        catch (Exception exception) {
            return 0;
        }
        return 1;
    }

    private static void mergeNodes(Node baseRoot, Node extraRoot) {
        NodeList baseChildList = baseRoot.getChildNodes();
        NodeList extraChildList = extraRoot.getChildNodes();
        int len = baseChildList.getLength() >= extraChildList.getLength() ? extraChildList.getLength() : baseChildList.getLength();
        int i = 0;
        while (i < len) {
            if (baseChildList.item(i).getNodeName().equals(extraChildList.item(i).getNodeName())) {
                Util.mergeNodes(baseChildList.item(i), extraChildList.item(i));
            } else {
                Document baseDoc = baseRoot.getOwnerDocument();
                Node migratingChild = extraChildList.item(i);
                migratingChild = baseDoc.importNode(migratingChild, true);
                baseRoot.appendChild(migratingChild);
            }
            ++i;
        }
    }

    public static String getExtension(File fileIn) {
        int dotIdx = fileIn.getAbsolutePath().lastIndexOf(".");
        return fileIn.getAbsolutePath().substring(dotIdx + 1);
    }

    public static IPath getLocationIPath(Location loc) throws URISyntaxException {
        URI locationURI = null;
        IPath path = null;
        try {
            locationURI = loc.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            String filePath = loc.getURL().getFile();
            File tempFile = new File(filePath);
            locationURI = tempFile.toURI();
        }
        if (locationURI != null) {
            path = URIUtil.toPath((URI)locationURI);
            return path;
        }
        Util.logWarning(String.format("Cannot obtain the proper locationURI value in getLocationIPath function. %n", new Object[0]));
        path = new Path(loc.getURL().getPath());
        if (path != null) {
            Util.logWarning(String.format("Use this [%s] path instead.%n", path.toString()));
        }
        return path;
    }

    public static void delete(File dir) throws IOException {
        if (dir.isDirectory()) {
            if (dir.list().length == 0) {
                Util.safeDelete(dir);
            } else {
                String[] files;
                String[] stringArray = files = dir.list();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String temp = stringArray[n2];
                    File fileDelete = new File(dir, temp);
                    Util.delete(fileDelete);
                    ++n2;
                }
                if (dir.list().length == 0) {
                    Util.safeDelete(dir);
                }
            }
        } else {
            Util.safeDelete(dir);
        }
    }

    public static void extDelete(String pathStr, Map<String, Object> parameters) throws IOException {
        java.nio.file.Path path = Paths.get(pathStr, new String[0]);
        boolean followLinks = Boolean.valueOf((String)parameters.get("followLinks"));
        boolean keepLinks = Boolean.valueOf((String)parameters.get("keepLinks"));
        boolean keepDirectories = Boolean.valueOf((String)parameters.get("keepDirectories"));
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (Stream<java.nio.file.Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    if (keepDirectories && Files.isDirectory(p, new LinkOption[0])) {
                        return;
                    }
                    if (Files.isSymbolicLink(p)) {
                        if (followLinks) {
                            java.nio.file.Path parent;
                            java.nio.file.Path linkedPath = Files.readSymbolicLink(p);
                            if (!linkedPath.isAbsolute() && (parent = p.getParent()) != null) {
                                linkedPath = parent.resolve(linkedPath);
                            }
                            Util.extDelete(linkedPath.toString(), parameters);
                        }
                        if (keepLinks) {
                            return;
                        }
                    }
                    if (Files.isDirectory(p, new LinkOption[0]) && new File(p.toString()).list().length != 0) {
                        return;
                    }
                    Files.delete(p);
                }
                catch (IOException e) {
                    Util.logError(e.getMessage(), e);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static IStatus copy(Map<String, Object> parameters, String sourceDir, LockedFilesTracker lft, boolean afterUnzip) {
        String target = (String)parameters.get("target");
        if (target == null) {
            return new Status(4, "com.nxp.s32ds.ext.rcp.p2.core", 0, NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ACTION_COPY), null);
        }
        target = Util.resolveWithVersion(target, parameters);
        IBackupStore backupStore = (IBackupStore)parameters.get("backup");
        if (sourceDir == null) {
            return new Status(4, "com.nxp.s32ds.ext.rcp.p2.core", 0, NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_COPY), null);
        }
        String overwrite = (String)parameters.get("overwrite");
        if (overwrite == null) {
            overwrite = "false";
        }
        Profile profile = (Profile)parameters.get("profile");
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        String originalSource = sourceDir;
        String source = sourceDir;
        if (source.equals("@artifact")) {
            String artifactLocation = (String)parameters.get("artifact.location");
            if (artifactLocation == null) {
                IArtifactKey artifactKey = (IArtifactKey)parameters.get("artifact");
                return Util.createErrorMessage(NLS.bind((String)Messages.artifact_not_available, (Object)artifactKey));
            }
            source = artifactLocation;
        }
        Location location = Platform.getConfigurationLocation();
        Location eclipse = Platform.getInstallLocation();
        if (location != null && eclipse != null) {
            try {
                IPath path = Util.getLocationIPath(location);
                IPath eclipsePath = Util.getLocationIPath(eclipse);
                if (!eclipsePath.isPrefixOf(path) && afterUnzip) {
                    IPath newTarget = path.removeLastSegments(1);
                    newTarget = newTarget.addTrailingSeparator();
                    Util.logWarning(String.format("%s is the new (USER) target parameter.%n", newTarget.toString()));
                    target = newTarget.toString();
                }
            }
            catch (URISyntaxException e) {
                Util.logWarning(e.getMessage());
                e.printStackTrace();
            }
        } else {
            Util.logError(String.format("FAIL to compute/validate/re-create target parameter.%n", new Object[0]));
            return Status.CANCEL_STATUS;
        }
        File sourceFile = new File(source);
        File targetFile = new File(target);
        File[] copiedFiles = null;
        try {
            copiedFiles = Util.mergeCopy(sourceFile, targetFile, Boolean.valueOf(overwrite), backupStore, lft);
            String lockedFilesStorage = LockedFilesTracker.getLockedFilesStorage(parameters);
            boolean result = lft.copyLockedFiles(originalSource, lockedFilesStorage);
            if (result) {
                Util.logWarning(Messages.InstallAction_lock_files_have_been_copied);
                lft.createLockedFilesMapFile(lockedFilesStorage);
            }
        }
        catch (IOException e) {
            return Util.createErrorMessage(e.getMessage());
        }
        StringBuffer copiedFileNameBuffer = new StringBuffer();
        File[] fileArray = copiedFiles;
        int n = copiedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File copiedFile = fileArray[n2];
            copiedFileNameBuffer.append(copiedFile.getAbsolutePath()).append("|");
            ++n2;
        }
        profile.setInstallableUnitProperty(iu, "copied|" + originalSource + "|" + target, copiedFileNameBuffer.toString());
        return Status.OK_STATUS;
    }

    private static File[] mergeCopy(File source, File target, boolean overwrite, IBackupStore backupStore, LockedFilesTracker filesTracker) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        Util.xcopy(files, source, target, overwrite, backupStore, filesTracker);
        return files.toArray(new File[files.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void xcopy(List<File> copiedFiles, File sourceFile, File targetFile, boolean overwrite, IBackupStore backupStore, LockedFilesTracker filesTracker) throws IOException {
        if (!sourceFile.exists()) {
            throw new IOException(NLS.bind((String)Messages.InstallAction_source_does_not_exists, (Object)sourceFile));
        }
        if (sourceFile.isDirectory()) {
            if (targetFile.exists() && targetFile.isFile()) {
                if (!overwrite) {
                    throw new IOException(NLS.bind((String)Messages.InstallAction_target_already_exists, (Object)targetFile));
                }
                if (backupStore != null) {
                    backupStore.backup(targetFile);
                } else {
                    Util.safeDelete(targetFile);
                }
            }
            if (!targetFile.exists()) {
                targetFile.mkdirs();
            }
            copiedFiles.add(targetFile);
            File[] children = sourceFile.listFiles();
            if (children == null) {
                throw new IOException(NLS.bind((String)Messages.InstallAction_error_while_retrieving, (Object)sourceFile));
            }
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                Util.xcopy(copiedFiles, element, new File(targetFile, element.getName()), overwrite, backupStore, filesTracker);
                ++n2;
            }
            return;
        }
        if (targetFile.exists() && !overwrite) {
            throw new IOException(NLS.bind((String)Messages.InstallAction_target_already_exists, (Object)targetFile));
        }
        if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
            throw new IOException(NLS.bind((String)Messages.InstallAction_target_could_not_be_created, (Object)targetFile.getParent()));
        }
        try {
            Throwable children = null;
            Object var7_17 = null;
            try {
                FileInputStream fis = new FileInputStream(sourceFile);
                try {
                    try (FileOutputStream fos = new FileOutputStream(targetFile);){
                        Util.copyStream(fis, true, fos, true);
                        copiedFiles.add(targetFile);
                    }
                    if (fis == null) return;
                }
                catch (Throwable throwable) {
                    if (children == null) {
                        children = throwable;
                    } else if (children != throwable) {
                        children.addSuppressed(throwable);
                    }
                    if (fis == null) throw children;
                    fis.close();
                    throw children;
                }
                fis.close();
                return;
            }
            catch (Throwable throwable) {
                if (children == null) {
                    children = throwable;
                    throw children;
                } else {
                    if (children == throwable) throw children;
                    children.addSuppressed(throwable);
                }
                throw children;
            }
        }
        catch (IOException iOException) {
            try {
                Util.logWarning(String.format("%s was detected as locked. %s, %s %n", sourceFile.getAbsolutePath(), filesTracker.getUnzipFolder(), targetFile.getAbsolutePath()));
                try {
                    filesTracker.markLocked(sourceFile.getAbsolutePath().substring(filesTracker.getUnzipFolder().length() + 1), targetFile.getAbsolutePath());
                }
                catch (Exception ex) {
                    Util.logError(ex.getMessage(), ex);
                }
                if (!targetFile.exists()) return;
                Util.delete(targetFile);
                return;
            }
            catch (IOException deleteEx) {
                Util.logError(deleteEx.getMessage(), deleteEx);
            }
        }
    }

    public static IStatus cleanupcopy(Map<String, Object> parameters, boolean restoreable, String targetDir) {
        String target;
        String source;
        String string = source = Util.getTempFolder().isEmpty() ? (String)parameters.get("source") : Util.getTempFolder();
        if (source == null) {
            return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_CLEANUPCOPY));
        }
        String string2 = target = targetDir == null ? (String)parameters.get("target") : targetDir;
        if (target == null) {
            return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ACTION_CLEANUPCOPY));
        }
        IBackupStore backupStore = (IBackupStore)parameters.get("backup");
        if (backupStore == null) {
            backupStore = UnnativeTouchpoint.getBackupStore((IProfile)parameters.get("profile"));
        }
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        IProfile profile = (IProfile)parameters.get("profile");
        String copied = profile.getInstallableUnitProperty(iu, "copied|" + source + "|" + target);
        if (copied == null) {
            return Status.OK_STATUS;
        }
        StringTokenizer tokenizer = new StringTokenizer(copied, "|");
        ArrayList<File> directories = new ArrayList<File>();
        while (tokenizer.hasMoreTokens()) {
            String fileName = tokenizer.nextToken();
            File file = new File(fileName);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                directories.add(0, file);
                continue;
            }
            if (restoreable) {
                try {
                    backupStore.backup(file);
                    continue;
                }
                catch (IOException iOException) {
                    return Util.createErrorMessage(NLS.bind((String)Messages.backup_file_failed, (Object)file));
                }
            }
            Util.safeDelete(file);
        }
        for (File file : directories) {
            File directory = file;
            File[] children = directory.listFiles();
            if (children == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.Error_list_children_0, (Object)directory));
            }
            if (children.length != 0) continue;
            if (restoreable) {
                try {
                    backupStore.backup(directory);
                    continue;
                }
                catch (IOException iOException) {
                    return Util.createErrorMessage(NLS.bind((String)Messages.backup_file_failed, (Object)directory));
                }
            }
            Util.safeDelete(directory);
        }
        return Status.OK_STATUS;
    }

    public static String resolveWithVersion(String str, Map<String, Object> parameters) {
        if (str == null || !str.contains("@artifact_short_version")) {
            return str;
        }
        String shortVersion = (String)parameters.get("artifact.short.version");
        if (shortVersion == null) {
            Util.logWarning(Messages.Util_short_version_is_not_resolved);
            return str;
        }
        return str.replaceAll("@artifact_short_version", shortVersion);
    }

    public static String getVersionStrWoQualifier(Version version) {
        String str = version.toString();
        if (!version.isOSGiCompatible()) {
            Util.logWarning(Messages.Util_short_version_may_be_incorrect);
            return str;
        }
        long count = str.chars().filter(c -> c == 46).count();
        if (count < 3L) {
            Util.logWarning(Messages.Util_short_version_may_be_incorrect);
            return str;
        }
        int j = str.lastIndexOf(46);
        return str.substring(0, j);
    }

    public static boolean safeDelete(File file) {
        try {
            Files.delete(file.toPath());
            return true;
        }
        catch (IOException e) {
            Util.logError(e.getMessage(), e);
            return false;
        }
    }
}

