/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core.actions;

import com.nxp.s32ds.ext.rcp.p2.core.utils.Util;
import com.nxp.s32ds.ext.rcp.p2.internal.core.Messages;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.BundleDefaultsScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.util.NLS;

public class ModifyPreferenceAction
extends ProvisioningAction {
    private static final String MODIFY_PREF_ACTION = "com.nxp.s32ds.ext.rcp.p2.native.modifyPreference";
    private static final Map<String, IScopeContext> scopeTypeMap = Map.of("configuration", ConfigurationScope.INSTANCE, "instance", InstanceScope.INSTANCE, "default", DefaultScope.INSTANCE, "bundle_defaults", BundleDefaultsScope.INSTANCE);
    private String prevPrefValue;

    public IStatus execute(Map<String, Object> parameters) {
        try {
            String scopeTypeParam = (String)parameters.get("scopeType");
            if (scopeTypeParam == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"scopeType", (Object)MODIFY_PREF_ACTION));
            }
            String bundleIDParam = (String)parameters.get("bundleID");
            if (bundleIDParam == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"bundleID", (Object)MODIFY_PREF_ACTION));
            }
            String prefNameParam = (String)parameters.get("prefName");
            if (prefNameParam == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"prefName", (Object)MODIFY_PREF_ACTION));
            }
            String regexParam = (String)parameters.get("regex");
            if (regexParam == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"regex", (Object)MODIFY_PREF_ACTION));
            }
            String replacementParam = (String)parameters.get("replacement");
            if (replacementParam == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"replacement", (Object)MODIFY_PREF_ACTION));
            }
            String replaceAllParam = (String)parameters.get("replaceAll");
            if (replaceAllParam == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"replaceAll", (Object)MODIFY_PREF_ACTION));
            }
            IScopeContext prefStore = scopeTypeMap.get(scopeTypeParam);
            if (prefStore == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.scope_not_found, (Object)scopeTypeParam, (Object)MODIFY_PREF_ACTION));
            }
            IEclipsePreferences pref = prefStore.getNode(bundleIDParam);
            if (pref == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.modify_pref_node_not_found, (Object)bundleIDParam));
            }
            this.prevPrefValue = pref.get(prefNameParam, null);
            if (this.prevPrefValue == null) {
                return Status.warning((String)NLS.bind((String)Messages.modify_pref_not_found, (Object)prefNameParam, (Object)bundleIDParam));
            }
            boolean replaceAll = Boolean.parseBoolean(replaceAllParam.toLowerCase());
            if (replaceAll) {
                pref.put(prefNameParam, this.prevPrefValue.replaceAll(regexParam, replacementParam));
            } else {
                pref.put(prefNameParam, this.prevPrefValue.replaceFirst(regexParam, replacementParam));
            }
            pref.flush();
            pref.sync();
        }
        catch (PatternSyntaxException e) {
            return Util.createErrorMessage(NLS.bind((String)Messages.invalid_regex, (Object)MODIFY_PREF_ACTION, (Object)e));
        }
        catch (ClassCastException classCastException) {
            return Util.createErrorMessage(NLS.bind((String)Messages.param_type_error, (Object)MODIFY_PREF_ACTION));
        }
        catch (Exception e) {
            return Util.createErrorMessage(e.getMessage());
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map<String, Object> parameters) {
        if (this.prevPrefValue == null) {
            return Status.OK_STATUS;
        }
        try {
            String scopeTypeParam = (String)parameters.get("scopeType");
            if (scopeTypeParam == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"scopeType", (Object)MODIFY_PREF_ACTION));
            }
            String bundleIDParam = (String)parameters.get("bundleID");
            if (bundleIDParam == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"bundleID", (Object)MODIFY_PREF_ACTION));
            }
            String prefNameParam = (String)parameters.get("prefName");
            if (prefNameParam == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"prefName", (Object)MODIFY_PREF_ACTION));
            }
            String regexParam = (String)parameters.get("regex");
            if (regexParam == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"regex", (Object)MODIFY_PREF_ACTION));
            }
            String replacementParam = (String)parameters.get("replacement");
            if (replacementParam == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"replacement", (Object)MODIFY_PREF_ACTION));
            }
            String replaceAllParam = (String)parameters.get("replaceAll");
            if (replaceAllParam == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"replaceAll", (Object)MODIFY_PREF_ACTION));
            }
            IScopeContext prefStore = scopeTypeMap.get(scopeTypeParam);
            if (prefStore == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.scope_not_found, (Object)scopeTypeParam, (Object)MODIFY_PREF_ACTION));
            }
            IEclipsePreferences pref = prefStore.getNode(bundleIDParam);
            pref.put(prefNameParam, this.prevPrefValue);
            pref.flush();
            pref.sync();
        }
        catch (Exception e) {
            return Util.createErrorMessage(e.getMessage());
        }
        return Status.OK_STATUS;
    }

    public String getName() {
        return MODIFY_PREF_ACTION;
    }

    public String getPrevPrefValue() {
        return this.prevPrefValue;
    }
}

