/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.validation;

import com.nxp.s32ds.debug.ide.core.AttributeReadingUtils;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class S32DebuggerFlashProgrammerParams {
    private static final String BUNDLE_NAME = "com.nxp.s32ds.debug.ide.s32debugger.flash.core";
    public static final String BINARY_IS_ENABLED = "enabled";
    public static final String BINARY_IS_DISABLED = "disabled";
    public static final String BINARY_TYPE_ELF = "elf";
    public static final String BINARY_TYPE_OTHER = "other";
    public static final String NAME_UNDEFINED = "<undefined>";
    private static final String FLASH_NAME = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.flashName";
    private static final String FLASH_TYPE = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.flashType";
    private static final String DEVICE = "com.nxp.s32ds.debug.ide.s32debugger.core.device";
    private static final String PROJECT_ID_TO_BINARY_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.projectIdToBinaryMap";
    private static final String PROJECT_ID_TO_BINARY_TYPE_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.projectIdToBinaryTypeMap";
    private static final String PROJECT_BINARY_ID_IS_ENABLED_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryIsEnabledMap";
    private static final String PROJECT_BINARY_ID_TO_BASE_ADDRESS_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryIdToBaseAddressMap";
    private static final String PROJECT_BINARY_ID_TO_PROJECT_NAME_MAP = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.binaryIdToProjectNameMap";
    private static final String FLASH_VERIFY_AFTER_WRITE = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.verifyAfterWrite";
    private static final String FLASH_MEMORY_ERASE = "com.nxp.s32ds.debug.ide.s32debugger.flash.core.flashMemoryErase";
    private static final Map<String, String> DEFAULT_ID_TO_BINARY_MAP = new HashMap<String, String>();
    private static final Map<String, String> DEFAULT_ID_TO_BINARY_TYPE_MAP = new HashMap<String, String>();
    private static final Map<String, String> DEFAULT_BINARY_ID_IS_ENABLED_MAP = new HashMap<String, String>();
    private static final Map<String, String> DEFAULT_BINARY_ID_TO_BASE_ADDRESS_MAP = new HashMap<String, String>();
    private static final Map<String, String> DEFAULT_BINARY_ID_TO_PROJECT_NAME_MAP = new HashMap<String, String>();
    private static final boolean DEFAULT_FLASH_VERIFY_AFTER_WRITE = false;
    private static final boolean DEFAULT_FLASH_MEMORY_ERASE = false;
    private String flashName = "";
    private String flashType = "";
    private Map<String, String> idToBinaryMap = DEFAULT_ID_TO_BINARY_MAP;
    private Map<String, String> binaryIdToBinaryTypeMap = DEFAULT_ID_TO_BINARY_TYPE_MAP;
    private Map<String, String> binaryIdIsEnabledMap = DEFAULT_BINARY_ID_IS_ENABLED_MAP;
    private Map<String, String> binariyIdToBaseAdressMap = DEFAULT_BINARY_ID_TO_BASE_ADDRESS_MAP;
    private Map<String, String> binaryIdToProjectNameMap = DEFAULT_BINARY_ID_TO_PROJECT_NAME_MAP;
    private boolean verifyAfterWrite = false;
    private boolean flashMemoryErase = false;
    private ArrayList<IStatus> errors;
    private S32DebuggerParams s32DebuggerDefParams;
    private static int binariesCounter;

    private S32DebuggerFlashProgrammerParams(S32DebuggerParams debugParams) {
        this.s32DebuggerDefParams = debugParams;
        this.s32DebuggerDefParams.setDeviceCoreId(null);
    }

    S32DebuggerParams getS32DebuggerParams() {
        return this.s32DebuggerDefParams;
    }

    public String getLCVersion() {
        return this.s32DebuggerDefParams.getLCVersion();
    }

    public boolean isVerifyAfterWrite() {
        return this.verifyAfterWrite;
    }

    public void verifyAfterWrite(boolean verifyAfterWrite) {
        this.verifyAfterWrite = verifyAfterWrite;
    }

    public boolean isFlashMemoryErase() {
        return this.flashMemoryErase;
    }

    public void setFlashMemoryErase(boolean memoryErase) {
        this.flashMemoryErase = memoryErase;
    }

    public String getFlashName() {
        return this.flashName;
    }

    public void setFlashName(String flashName) {
        this.flashName = flashName;
    }

    public String getFlashType() {
        return this.flashType;
    }

    public void setFlashType(String flashType) {
        this.flashType = flashType;
    }

    public String getClientExecutable() {
        return this.s32DebuggerDefParams.getClientExecutable();
    }

    public void setClientExecutable(String clientExecutable) {
        this.s32DebuggerDefParams.setClientExecutable(clientExecutable);
    }

    public String getDeviceId() {
        return this.s32DebuggerDefParams.getDeviceId();
    }

    public void setDeviceId(String device) {
        this.s32DebuggerDefParams.setDeviceId(device);
    }

    public String getInitializationScript() {
        return this.s32DebuggerDefParams.getInitializationScript();
    }

    public void setInitializationScript(String initializationScript) {
        this.s32DebuggerDefParams.setInitializationScript(initializationScript);
    }

    @Deprecated
    public boolean isUseEthernet() {
        return this.s32DebuggerDefParams.isUseEthernet();
    }

    @Deprecated
    public void setUseEthernet(boolean useEthernet) {
        this.s32DebuggerDefParams.setUseEthernet(useEthernet);
    }

    public String getDevicePort() {
        return this.s32DebuggerDefParams.getDevicePort();
    }

    public void setDevicePort(String devicePort) {
        this.s32DebuggerDefParams.setDevicePort(devicePort);
    }

    @Deprecated
    public String getProbeHostnameOrIP() {
        return this.s32DebuggerDefParams.getProbeHostnameOrIP();
    }

    @Deprecated
    public void setProbeHostnameOrIP(String probeHostnameOrIP) {
        this.s32DebuggerDefParams.setProbeHostnameOrIP(probeHostnameOrIP);
    }

    public String getJtagSpeedKHz() {
        return this.s32DebuggerDefParams.getJtagSpeedKHz();
    }

    public void setJtagSpeedKHz(String jtagSpeedKHz) {
        this.s32DebuggerDefParams.setJtagSpeedKHz(jtagSpeedKHz);
    }

    public String getRemoteTimeoutInSeconds() {
        return this.s32DebuggerDefParams.getRemoteTimeoutInSeconds();
    }

    public void setRemoteTimeoutInSeconds(String remoteTimeoutInSeconds) {
        this.s32DebuggerDefParams.setRemoteTimeoutInSeconds(remoteTimeoutInSeconds);
    }

    public boolean isDoResetAndDelay() {
        return this.s32DebuggerDefParams.isDoResetAndDelay();
    }

    public void setDoResetAndDelay(boolean doResetAndDelay) {
        this.s32DebuggerDefParams.setDoResetAndDelay(doResetAndDelay);
    }

    public String getDelayInMSeconds() {
        return this.s32DebuggerDefParams.getDelayInMSeconds();
    }

    public void setDelayInMSeconds(String delayInMSeconds) {
        this.s32DebuggerDefParams.setDelayInMSeconds(delayInMSeconds);
    }

    public boolean isDoLaunchServer() {
        return this.s32DebuggerDefParams.isDoLaunchServer();
    }

    public void setDoLaunchServer(boolean doLaunchServer) {
        this.s32DebuggerDefParams.setDoLaunchServer(doLaunchServer);
    }

    public String getServerPort() {
        return this.s32DebuggerDefParams.getServerPort();
    }

    public void setServerPort(String serverPort) {
        this.s32DebuggerDefParams.setServerPort(serverPort);
    }

    public boolean isLogEnabled() {
        return this.s32DebuggerDefParams.isLogEnabled();
    }

    public void setLogEnabled(boolean isLogEnabled) {
        this.s32DebuggerDefParams.setLogEnabled(isLogEnabled);
    }

    public String getClientCommands() {
        return this.s32DebuggerDefParams.getClientCommands();
    }

    public void setClientCommands(String clientCommands) {
        this.s32DebuggerDefParams.setClientCommands(clientCommands);
    }

    public boolean isInitialCore() {
        return this.s32DebuggerDefParams.isInitialCore();
    }

    public void setInitialCore(boolean initialCore) {
        this.s32DebuggerDefParams.setInitialCore(initialCore);
    }

    public String getSecureDebuggingType() {
        return this.s32DebuggerDefParams.getSecureDebuggingType();
    }

    public void setSecureDebuggingType(String secureDebuggingType) {
        this.s32DebuggerDefParams.setSecureDebuggingType(secureDebuggingType);
    }

    public boolean isUseSecureDebugging() {
        return this.s32DebuggerDefParams.isUseSecureDebugging();
    }

    public void setUseSecureDebugging(boolean useSecureDebugging) {
        this.s32DebuggerDefParams.setUseSecureDebugging(useSecureDebugging);
    }

    public String getDeviceRevision() {
        return this.s32DebuggerDefParams.getDeviceRevision();
    }

    public void setDeviceRevision(String revision) {
        this.s32DebuggerDefParams.setDeviceRevision(revision);
    }

    public ArrayList<IStatus> getReadErrors() {
        return this.errors;
    }

    public Map<String, String> getBinaryIdToBinaryTypeMap() {
        return this.binaryIdToBinaryTypeMap;
    }

    public void setBinaryIdToBinaryTypeMap(Map<String, String> binaryIdToBinaryTypeMap) {
        this.binaryIdToBinaryTypeMap = binaryIdToBinaryTypeMap;
    }

    public Map<String, String> getIdToBinaryMap() {
        return this.idToBinaryMap;
    }

    public void setIdToBinaryMap(Map<String, String> idToBinaryMap) {
        this.idToBinaryMap = idToBinaryMap;
    }

    public Map<String, String> getBinaryIdToProjectNameMap() {
        return this.binaryIdToProjectNameMap;
    }

    public void setBinaryIdToProjectNameMap(Map<String, String> binaryIdToProjectNameMap) {
        this.binaryIdToProjectNameMap = binaryIdToProjectNameMap;
    }

    public Map<String, String> getBinaryIdIsEnabledMap() {
        return this.binaryIdIsEnabledMap;
    }

    public void setBinaryIdIsEnabledMap(Map<String, String> binaryIdIsEnabledMap) {
        this.binaryIdIsEnabledMap = binaryIdIsEnabledMap;
    }

    public Map<String, String> getBinaryIdToBaseAddressMap() {
        return this.binariyIdToBaseAdressMap;
    }

    public void setBinaryIdToBaseAddressMap(Map<String, String> binariyIdToBaseAdressMap) {
        this.binariyIdToBaseAdressMap = binariyIdToBaseAdressMap;
    }

    public String getNextProjectId() {
        return String.valueOf(binariesCounter++);
    }

    public static S32DebuggerFlashProgrammerParams getParams(ILaunchConfiguration lc) {
        S32DebuggerParams debuggerParams = S32DebuggerParams.getParams((ILaunchConfiguration)lc);
        S32DebuggerFlashProgrammerParams params = new S32DebuggerFlashProgrammerParams(debuggerParams);
        params.errors = new ArrayList();
        params.errors.addAll(debuggerParams.getReadErrors());
        params.setDeviceId((String)AttributeReadingUtils.readAttribute(params.errors, (String)DEVICE, (Object)"", (ILaunchConfiguration)lc));
        params.setFlashName((String)AttributeReadingUtils.readAttribute(params.errors, (String)FLASH_NAME, (Object)"", (ILaunchConfiguration)lc));
        params.setFlashType((String)AttributeReadingUtils.readAttribute(params.errors, (String)FLASH_TYPE, (Object)"", (ILaunchConfiguration)lc));
        binariesCounter = 0;
        HashMap<String, String> binariesToTypesMap = new HashMap<String, String>();
        binariesToTypesMap.putAll((Map)AttributeReadingUtils.readAttribute(params.errors, (String)PROJECT_ID_TO_BINARY_TYPE_MAP, DEFAULT_ID_TO_BINARY_TYPE_MAP, (ILaunchConfiguration)lc));
        params.setBinaryIdToBinaryTypeMap(binariesToTypesMap);
        HashMap<String, String> binariesToKeysMap = new HashMap<String, String>();
        binariesToKeysMap.putAll((Map)AttributeReadingUtils.readAttribute(params.errors, (String)PROJECT_ID_TO_BINARY_MAP, DEFAULT_ID_TO_BINARY_MAP, (ILaunchConfiguration)lc));
        params.setIdToBinaryMap(binariesToKeysMap);
        HashMap<String, String> binariesEnabledMap = new HashMap<String, String>();
        binariesEnabledMap.putAll((Map)AttributeReadingUtils.readAttribute(params.errors, (String)PROJECT_BINARY_ID_IS_ENABLED_MAP, DEFAULT_BINARY_ID_IS_ENABLED_MAP, (ILaunchConfiguration)lc));
        params.setBinaryIdIsEnabledMap(binariesEnabledMap);
        HashMap<String, String> binariesToBaseAddressMap = new HashMap<String, String>();
        binariesToBaseAddressMap.putAll((Map)AttributeReadingUtils.readAttribute(params.errors, (String)PROJECT_BINARY_ID_TO_BASE_ADDRESS_MAP, DEFAULT_BINARY_ID_TO_BASE_ADDRESS_MAP, (ILaunchConfiguration)lc));
        params.setBinaryIdToBaseAddressMap(binariesToBaseAddressMap);
        HashMap<String, String> binariesToProjectNameMap = new HashMap<String, String>();
        binariesToProjectNameMap.putAll((Map)AttributeReadingUtils.readAttribute(params.errors, (String)PROJECT_BINARY_ID_TO_PROJECT_NAME_MAP, DEFAULT_BINARY_ID_TO_PROJECT_NAME_MAP, (ILaunchConfiguration)lc));
        params.setBinaryIdToProjectNameMap(binariesToProjectNameMap);
        params.verifyAfterWrite((Boolean)AttributeReadingUtils.readAttribute(params.errors, (String)FLASH_VERIFY_AFTER_WRITE, (Object)false, (ILaunchConfiguration)lc));
        params.setFlashMemoryErase((Boolean)AttributeReadingUtils.readAttribute(params.errors, (String)FLASH_MEMORY_ERASE, (Object)false, (ILaunchConfiguration)lc));
        return params;
    }

    public static void applyDefaults(ILaunchConfigurationWorkingCopy lc) {
        S32DebuggerParams.applyDefaults((ILaunchConfigurationWorkingCopy)lc);
        lc.setAttribute(DEVICE, "");
        lc.setAttribute(FLASH_NAME, "");
        lc.setAttribute(FLASH_TYPE, "");
        binariesCounter = 0;
        lc.setAttribute(PROJECT_ID_TO_BINARY_TYPE_MAP, DEFAULT_ID_TO_BINARY_TYPE_MAP);
        lc.setAttribute(PROJECT_ID_TO_BINARY_MAP, DEFAULT_ID_TO_BINARY_MAP);
        lc.setAttribute(PROJECT_BINARY_ID_IS_ENABLED_MAP, DEFAULT_BINARY_ID_IS_ENABLED_MAP);
        lc.setAttribute(PROJECT_BINARY_ID_TO_BASE_ADDRESS_MAP, DEFAULT_BINARY_ID_TO_BASE_ADDRESS_MAP);
        lc.setAttribute(PROJECT_BINARY_ID_TO_PROJECT_NAME_MAP, DEFAULT_BINARY_ID_TO_PROJECT_NAME_MAP);
        lc.setAttribute(FLASH_VERIFY_AFTER_WRITE, false);
        lc.setAttribute(FLASH_MEMORY_ERASE, false);
    }

    public void applyParams(ILaunchConfigurationWorkingCopy lc) {
        this.s32DebuggerDefParams.applyParams(lc);
        lc.setAttribute(FLASH_NAME, this.getFlashName());
        lc.setAttribute(FLASH_TYPE, this.getFlashType());
        Map<String, String> idToBinaryMap = this.getIdToBinaryMap();
        if (idToBinaryMap.size() > 0) {
            Map<String, String> binaryIdIsEnabledMap = this.getBinaryIdIsEnabledMap();
            for (String binaryId : idToBinaryMap.keySet()) {
                if (!binaryIdIsEnabledMap.get(binaryId).equals(BINARY_IS_ENABLED)) continue;
                lc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", idToBinaryMap.get(binaryId));
                if (Paths.get(idToBinaryMap.get(binaryId), new String[0]).isAbsolute()) break;
                Map<String, String> idToProjectNameMap = this.getBinaryIdToProjectNameMap();
                lc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", idToProjectNameMap.get(binaryId));
                break;
            }
        }
        binariesCounter = 0;
        lc.setAttribute(PROJECT_ID_TO_BINARY_MAP, this.getIdToBinaryMap());
        lc.setAttribute(PROJECT_ID_TO_BINARY_TYPE_MAP, this.getBinaryIdToBinaryTypeMap());
        lc.setAttribute(PROJECT_BINARY_ID_IS_ENABLED_MAP, this.getBinaryIdIsEnabledMap());
        lc.setAttribute(PROJECT_BINARY_ID_TO_BASE_ADDRESS_MAP, this.getBinaryIdToBaseAddressMap());
        lc.setAttribute(PROJECT_BINARY_ID_TO_PROJECT_NAME_MAP, this.getBinaryIdToProjectNameMap());
        lc.setAttribute(FLASH_VERIFY_AFTER_WRITE, this.isVerifyAfterWrite());
        lc.setAttribute(FLASH_MEMORY_ERASE, this.isFlashMemoryErase());
    }
}

