/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.validation;

import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.validation.S32DebuggerFlashProgrammerErrorMessages;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.validation.S32DebuggerFlashProgrammerValidationActivator;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.FlashElementConfiguration;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class S32DebuggerFlashElementConfigurationValidator {
    private static final Pattern PATTERN_HEX = Pattern.compile("^(0x)??(\\p{XDigit}{1,16})$");
    private static final Pattern PATTERN_HEX_LONG = Pattern.compile("^(0x)??(\\p{XDigit}{1,})$");

    public static IStatus validate(FlashElementConfiguration changedElement, FlashElementConfiguration elementOnEdit, List<String> binaryPaths) {
        ICProject project;
        String projectName = changedElement.getProjectName();
        String binaryPathInput = changedElement.getBinaryPath();
        String binaryPath = DebuggerUtils.substitute((String)changedElement.getBinaryPath());
        if (projectName.isEmpty() && binaryPath.isEmpty()) {
            return new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashElementValidator_specify_project_or_application);
        }
        if (!("<undefined>".equals(projectName) || (project = CoreModel.getDefault().getCModel().getCProject(projectName)) != null && project.exists())) {
            return new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), NLS.bind((String)S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashProgrammerAttributesValidator_project_not_exist, (Object)projectName));
        }
        if (binaryPath.isEmpty() || !Files.exists(Paths.get(binaryPath, new String[0]), new LinkOption[0])) {
            return new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashElementValidator_no_such_binary);
        }
        if (Files.isDirectory(Paths.get(binaryPath, new String[0]), new LinkOption[0])) {
            return new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashElementValidator_binary_file_expected);
        }
        if (binaryPath.indexOf(32) != -1) {
            return new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), NLS.bind((String)S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashProgrammerAttributesValidator_binary_contains_spaces, (Object)binaryPath));
        }
        if (changedElement.isUseBaseAddress()) {
            if (changedElement.getBaseAddress().isEmpty()) {
                return new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashElementValidator_specify_base_address);
            }
            if (!PATTERN_HEX.matcher(changedElement.getBaseAddress()).matches()) {
                if (PATTERN_HEX_LONG.matcher(changedElement.getBaseAddress()).matches()) {
                    return new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashElementValidator_base_address_too_long);
                }
                return new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashElementValidator_base_address_has_hex_format);
            }
        }
        if (elementOnEdit == null || !elementOnEdit.getBinaryPath().equals(changedElement.getBinaryPath())) {
            for (String curBinaryPath : binaryPaths) {
                if (!curBinaryPath.equals(binaryPath)) continue;
                String[] pathSegments = new Path(binaryPath).segments();
                return new Status(4, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), NLS.bind((String)S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashElementValidator_binary_is_already_added, (Object)pathSegments[pathSegments.length - 1]));
            }
        }
        if ("<undefined>".equals(projectName)) {
            if (!binaryPathInput.equals(binaryPath)) {
                return new Status(2, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), NLS.bind((String)S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashElementValidator_no_such_project, (Object)binaryPathInput));
            }
            String[] pathSegments = new Path(binaryPath).segments();
            return new Status(2, S32DebuggerFlashProgrammerValidationActivator.getInstance().getBundleId(), NLS.bind((String)S32DebuggerFlashProgrammerErrorMessages.S32DebuggerFlashElementValidator_no_such_project, (Object)pathSegments[pathSegments.length - 1]));
        }
        return Status.OK_STATUS;
    }
}

