/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.global.variables.memento;

import com.nxp.s32ds.debug.ide.global.variables.Activator;
import com.nxp.s32ds.debug.ide.global.variables.model.GlobalVariableModel;
import com.nxp.s32ds.ext.rcp.runtime.ui.memento.RcpMementos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;

public class GlobalVariablesToShowMemento
extends RcpMementos<Collection<GlobalVariableModel>> {
    private static final String GLOBAL_VARIABLE_CHILD = "GlobalVariableModel_";
    private static final String GLOBAL_VARIBLE_NAME = "global_varaible_name";
    private static final String GLOBAL_VARIABLE_PATH = "global_varaiable_path";

    public GlobalVariablesToShowMemento(String mementoId) {
        super("GlobalVariablesToShowContextMemento", mementoId);
    }

    protected void saveToMemento(IMemento memento, Collection<GlobalVariableModel> globalVaraibleModels) {
        int number = 0;
        for (GlobalVariableModel globalVariable : globalVaraibleModels) {
            IMemento memSpaceChild = memento.createChild(GLOBAL_VARIABLE_CHILD + String.valueOf(number++));
            memSpaceChild.putString(GLOBAL_VARIBLE_NAME, globalVariable.getName());
            memSpaceChild.putString(GLOBAL_VARIABLE_PATH, globalVariable.getFilePath().toOSString());
        }
    }

    protected Collection<GlobalVariableModel> restoreFromMemento(IMemento memento, Collection<GlobalVariableModel> globalVariablesToShow) {
        IMemento[] globalVaraibles = memento.getChildren();
        if (globalVaraibles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<GlobalVariableModel> returnList = new ArrayList<GlobalVariableModel>();
        for (GlobalVariableModel globalVariableModel : globalVariablesToShow) {
            if (!Arrays.stream(globalVaraibles).anyMatch(child -> child.getString(GLOBAL_VARIBLE_NAME).equals(globalVariableModel.getName()) && child.getString(GLOBAL_VARIABLE_PATH).equals(globalVariableModel.getFilePath().toOSString()))) continue;
            returnList.add(globalVariableModel);
        }
        return returnList;
    }

    protected IPreferenceStore getPreferenceStore() {
        return Activator.getInstance().getPreferenceStore();
    }
}

