/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core.internal.usb.devices.s32debugger.tap;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DeviceConnection;
import com.nxp.s32ds.debug.ide.core.connection.Messages;
import com.nxp.s32ds.debug.ide.core.connection.WindowsDebuggerUsbConnection;
import com.nxp.s32ds.debug.ide.core.internal.usb.devices.s32debugger.tap.S32DebuggerTapUsbDeviceAccessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class S32DebuggerTapUsbDeviceAccessorWindowsImpl
extends WindowsDebuggerUsbConnection {
    public Collection<DeviceConnection> getConnectedDevices(DebuggerConnectionDescriptor deviceDescriptor, String vid, String pid) {
        String deviceVidPid = String.format("VID_%s&PID_%s", vid, pid);
        Collection<String> allDevices = this.retrieveCMSISDAPDevices(deviceVidPid);
        Collection<String> activeDevices = this.getActiveCMSISDAPDevices(deviceVidPid);
        HashSet<String> greenBoxDevices = new HashSet<String>();
        for (String device : allDevices) {
            if (!activeDevices.contains(device)) continue;
            greenBoxDevices.add(device);
        }
        HashSet<DeviceConnection> devices = new HashSet<DeviceConnection>();
        devices.addAll(this.createDeviceConnections(greenBoxDevices, deviceDescriptor.getConnectionName()));
        return devices;
    }

    private Collection<String> retrieveCMSISDAPDevices(String deviceVidPid) {
        HashSet<String> devices = new HashSet<String>();
        String request = String.format(REQUEST_TO_WINDOWS_REGISTRY_USB_DEVICES, deviceVidPid);
        List result = this.runProcessForOutput(request);
        for (String line : result) {
            if (!line.contains(deviceVidPid)) continue;
            String deviceId = line.substring(line.indexOf(deviceVidPid) + deviceVidPid.length() + 1);
            devices.add(deviceId);
        }
        return devices;
    }

    private Collection<String> getActiveCMSISDAPDevices(String vidPid) {
        List usbCCGPDevices = this.runProcessForOutput(REQUEST_TO_WINDOWS_REGISTRY_USBCCGP_SERVICE);
        Collection<String> usbCCGPDeviceIDs = this.retrieveDeviceStrings(usbCCGPDevices, vidPid);
        return new HashSet<String>(usbCCGPDeviceIDs);
    }

    private Collection<String> retrieveDeviceStrings(Collection<String> activeDevices, String vidPid) {
        HashSet<String> devicesStrings = new HashSet<String>();
        for (String line : activeDevices) {
            int vidPidIndex = line.lastIndexOf(vidPid);
            if (vidPidIndex == -1) continue;
            String deviceIdStr = line.substring(vidPidIndex + 1 + vidPid.length());
            devicesStrings.add(deviceIdStr);
        }
        return devicesStrings;
    }

    private Collection<DeviceConnection> createDeviceConnections(Collection<String> deviceIDs, String deviceName) {
        HashSet<DeviceConnection> deviceNames = new HashSet<DeviceConnection>();
        for (String deviceId : deviceIDs) {
            DeviceConnection connection = new DeviceConnection(deviceName, false);
            connection.setDeviceConnectionData(deviceId);
            connection.setDeviceUiFriendlyName(NLS.bind((String)Messages.Debugger_connection_ui_pattern, (Object)deviceId, (Object)deviceName));
            deviceNames.add(connection);
        }
        return deviceNames;
    }

    public String getConnectionString(DebuggerConnectionDescriptor connectionDescriptor, DeviceConnection connectionData) {
        String deviceSerial = connectionData.getDeviceConnectionData();
        String vid = S32DebuggerTapUsbDeviceAccessor.getVidOfConnection(connectionDescriptor, connectionData);
        String deviceVidPid = String.format("VID_%s&PID_%s", vid, S32DebuggerTapUsbDeviceAccessor.getPidByVid(vid));
        Collection<String> activeDevices = this.getActiveCMSISDAPDevices(deviceVidPid);
        for (String deviceId : activeDevices) {
            if (!deviceId.contains(deviceSerial)) continue;
            StringBuilder virtualIpStr = new StringBuilder();
            virtualIpStr.append(S32DebuggerTapUsbDeviceAccessor.getVirtualPrefix(vid));
            virtualIpStr.append(deviceSerial);
            return virtualIpStr.toString();
        }
        return null;
    }

    public String runFirmwareUpdate(String command) {
        return this.runFirmwareUpateProcess(command);
    }
}

