/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core.internal.usb.devices.s32debugger.tap;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionAccessor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DeviceConnection;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.connection.DebuggerUsbConnectionInterface;
import com.nxp.s32ds.debug.ide.core.connection.Messages;
import com.nxp.s32ds.debug.ide.core.internal.usb.devices.s32debugger.tap.S32DebuggerTapUsbDeviceAccessorLinuxImpl;
import com.nxp.s32ds.debug.ide.core.internal.usb.devices.s32debugger.tap.S32DebuggerTapUsbDeviceAccessorWindowsImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class S32DebuggerTapUsbDeviceAccessor
implements DebuggerConnectionAccessor {
    private static final String S32DEBUGGER_VIRTUAL_IP_PREFIX_USB = "s32dbg:usb#";
    private static final String S32DEBUGGER_VIRTUAL_IP_PREFIX_USB_ETH = "s32dbg:";
    private static final String VID_USB = "1FC9";
    private static final String PID_USB = "014D";
    private static final String VID_USB_ETH = "15A2";
    private static final String PID_USB_ETH = "0067";
    private static final String S32TAP_FIRMWARE_UPDATE_COMMAND = "%s -u %s";
    private static final String PATH_TO_GDB_SERVER_EXECUTABLE = "${S32DS_GDB_SERVER_EXECUTABLE_PATH}";
    private static final Map<String, String> vid2pid = new TreeMap<String, String>();
    private static DebuggerUsbConnectionInterface usbConnectionImpl;

    public S32DebuggerTapUsbDeviceAccessor() {
        usbConnectionImpl = null;
        vid2pid.put(VID_USB, PID_USB);
        vid2pid.put(VID_USB_ETH, PID_USB_ETH);
        if ("win32".equals(Platform.getOS())) {
            usbConnectionImpl = new S32DebuggerTapUsbDeviceAccessorWindowsImpl();
        }
        if ("linux".equals(Platform.getOS())) {
            usbConnectionImpl = new S32DebuggerTapUsbDeviceAccessorLinuxImpl();
        }
    }

    public Collection<DeviceConnection> getActiveDeviceConnections(DebuggerConnectionDescriptor connectionDescriptor) {
        if (connectionDescriptor == null || usbConnectionImpl == null) {
            return Collections.emptySet();
        }
        Collection connection = usbConnectionImpl.getConnectedDevices(connectionDescriptor, VID_USB, PID_USB);
        connection.addAll(this.getActiveFW106DeviceConnections(connectionDescriptor));
        return connection;
    }

    public String getConnectionString(DebuggerConnectionDescriptor connectionDescriptor, DeviceConnection connectionData) {
        if (usbConnectionImpl == null) {
            return null;
        }
        return usbConnectionImpl.getConnectionString(connectionDescriptor, connectionData);
    }

    public String getBaseSpeed() {
        return "";
    }

    public Collection<DeviceConnection> getActiveFW106DeviceConnections(DebuggerConnectionDescriptor connectionDescriptor) {
        if (connectionDescriptor == null || usbConnectionImpl == null) {
            return Collections.emptySet();
        }
        return usbConnectionImpl.getConnectedDevices(connectionDescriptor, VID_USB_ETH, PID_USB_ETH);
    }

    protected static String getVidOfConnection(DebuggerConnectionDescriptor connectionDescriptor, DeviceConnection deviceConnection) {
        if (connectionDescriptor == null || usbConnectionImpl == null) {
            return "";
        }
        if (usbConnectionImpl.getConnectedDevices(connectionDescriptor, VID_USB, PID_USB).contains(deviceConnection)) {
            return VID_USB;
        }
        if (usbConnectionImpl.getConnectedDevices(connectionDescriptor, VID_USB_ETH, PID_USB_ETH).contains(deviceConnection)) {
            return VID_USB_ETH;
        }
        return "";
    }

    protected static String getPidByVid(String vid) {
        return vid2pid.get(vid);
    }

    protected static String getVirtualPrefix(String vid) {
        if (VID_USB.equals(vid)) {
            return S32DEBUGGER_VIRTUAL_IP_PREFIX_USB;
        }
        if (VID_USB_ETH.equals(vid)) {
            return S32DEBUGGER_VIRTUAL_IP_PREFIX_USB_ETH;
        }
        return "";
    }

    public String runFirmwareUpdate(String deviceFriendlyName) {
        String separatePattern = NLS.bind((String)Messages.Debugger_connection_ui_pattern, (Object)"", (Object)"");
        String[] deviceMAC = deviceFriendlyName.split(separatePattern);
        String result = "";
        if (deviceMAC.length > 1 && !deviceMAC[0].isEmpty()) {
            String cmd = String.format(S32TAP_FIRMWARE_UPDATE_COMMAND, DebuggerUtils.substitute((String)PATH_TO_GDB_SERVER_EXECUTABLE), deviceMAC[0]);
            result = usbConnectionImpl.runFirmwareUpdate(cmd);
        }
        return result;
    }
}

