/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controls;

import com.nxp.swtools.common.uct.controls.IBaseControl;
import com.nxp.swtools.common.uct.validation.AUctProblem;
import com.nxp.swtools.efuse.controller.EfuseController;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.controls.StructSettingNode;
import com.nxp.swtools.efuse.gui.utils.EfuseGuiUtils;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.IEfuseMcu;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.efuse.ui.xml.settings.ArraySetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseIntegerSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseStructSetting;
import com.nxp.swtools.efuse.xml.settings.AdvancedFuseSetting;
import com.nxp.swtools.efuse.xml.settings.EfuseTabSetting;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import org.eclipse.ui.services.IDisposable;

public class TabSettingNode
extends Tab
implements IBaseControl,
IDisposable {
    private EfuseTabSetting tabSetting;
    private StructSettingNode tabContentNode;

    public TabSettingNode(EfuseTabSetting tabSetting) {
        this.tabSetting = tabSetting;
        this.tabContentNode = new StructSettingNode(tabSetting.getEfuseTabContent());
        this.create();
    }

    public void create() {
        this.setId(this.tabSetting.getId());
        this.setText(this.tabSetting.getLabel());
        this.setClosable(false);
        this.setContent((Node)this.tabContentNode.getRegion());
        this.selectedProperty().addListener((obs, oldVal, newVal) -> {
            String tabSettingId = this.tabSetting.getId();
            EfuseUtils.setSwitchingBetweenModes((boolean)true);
            if (tabSettingId.equals("advanced_mode") && newVal.booleanValue() && EfuseUtils.getCurrentMode().equals((Object)EfuseUtils.Mode.STANDARD)) {
                IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
                EfuseControllerUtils.calculateAllFuseWordsValues((IEfuseMcu)mcu);
                EfuseControllerUtils.addModifiedFusesInAdvancedArray();
                EfuseUtils.setCurrentMode((EfuseUtils.Mode)EfuseUtils.Mode.ADVANCED);
                EfuseGuiUtils.refreshEfuseBinaryConfigurationTable();
            } else if (tabSettingId.equals("standard_mode") && newVal.booleanValue() && EfuseUtils.getCurrentMode().equals((Object)EfuseUtils.Mode.ADVANCED)) {
                EfuseUtils.setCurrentMode((EfuseUtils.Mode)EfuseUtils.Mode.STANDARD);
                EfuseController.getInstance().getProblemsManager().clearProblems(AUctProblem.Type.WARNING_SYNCHRONIZATION_LOST);
                ArraySetting fuseArray = EfuseControllerUtils.getAdvancedFusesArray();
                if (fuseArray != null) {
                    IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
                    List advancedFuses = fuseArray.getSettings();
                    for (AdvancedFuseSetting advancedFuse : advancedFuses) {
                        String fuseWordId = advancedFuse.getFuseWordId();
                        EfuseStructSetting uiComponentStruct = advancedFuse.getUiComponent();
                        EfuseIntegerSetting valueInteger = uiComponentStruct.getIntegerSettingById("value_advanced");
                        FuseWord fuseWord = EfuseUtils.getFuseWordByID((List)mcu.getAllFuseWords(), (String)fuseWordId);
                        if (fuseWord == null || valueInteger == null) continue;
                        EfuseControllerUtils.setUIComponentsForFuseWord((IEfuseMcu)mcu, (FuseWord)fuseWord, (EfuseIntegerSetting)valueInteger);
                    }
                }
            }
            this.refresh();
            EfuseUtils.setSwitchingBetweenModes((boolean)false);
        });
    }

    public void refresh() {
        this.tabContentNode.refresh();
    }

    public void dispose() {
        this.tabContentNode.dispose();
    }

    public EfuseTabSetting getTabSetting() {
        return this.tabSetting;
    }
}

