/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.FrequencyRange;
import com.nxp.swtools.clocks.model.INodeHidden;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.util.List;

class NodeHidden
extends Node
implements INodeHidden {
    public NodeHidden(@NonNull String id, @NonNull ENodeType type) {
        super(id, type);
    }

    @Override
    public void printT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
    }

    @Override
    public @NonNull StringBuffer stringT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        return new StringBuffer();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public boolean checkInputFreq(@Nullable BigRational clock) {
        if (clock == null || !this.testFreqLimits) {
            return true;
        }
        FreqLimitErrorI xxLogFLE = this.logFLE;
        @NonNull List inputRanges = this.inputFrequencyRanges;
        if (inputRanges != null) {
            for (FrequencyRange range : inputRanges) {
                if (!range.isInRange(clock)) continue;
                return true;
            }
            if (xxLogFLE != null && this.enabled) {
                xxLogFLE.logFreqLimitError(true, this);
            }
            return false;
        }
        BigRational xxMinInputFreq = this.minInputFreq;
        if (xxMinInputFreq != null && xxMinInputFreq.compareTo(clock) > 0) {
            if (xxLogFLE != null && this.enabled) {
                xxLogFLE.logFreqLimitError(true, this);
            }
            return false;
        }
        BigRational xxMaxInputFreq = this.maxInputFreq;
        if (xxMaxInputFreq != null && xxMaxInputFreq.compareTo(clock) < 0) {
            if (xxLogFLE != null && this.enabled) {
                xxLogFLE.logFreqLimitError(true, this);
            }
            return false;
        }
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public boolean checkOutputFreq(@Nullable BigRational clock) {
        if (clock == null || !this.testFreqLimits) {
            return true;
        }
        FreqLimitErrorI xxLogFLE = this.logFLE;
        @NonNull List outputRanges = this.outputFrequencyRanges;
        if (outputRanges != null) {
            for (FrequencyRange range : outputRanges) {
                if (!range.isInRange(clock)) continue;
                return true;
            }
            if (xxLogFLE != null && this.enabled) {
                xxLogFLE.logFreqLimitError(false, this);
            }
            return false;
        }
        BigRational xxMinOutputFreq = this.minOutputFreq;
        if (xxMinOutputFreq != null && xxMinOutputFreq.compareTo(clock) > 0) {
            if (xxLogFLE != null && this.enabled) {
                xxLogFLE.logFreqLimitError(false, this);
            }
            return false;
        }
        BigRational xxMaxOutputFreq = this.maxOutputFreq;
        if (xxMaxOutputFreq != null && xxMaxOutputFreq.compareTo(clock) < 0) {
            if (xxLogFLE != null && this.enabled) {
                xxLogFLE.logFreqLimitError(false, this);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean checkInternalDividerFreq(@Nullable BigRational clock) {
        return true;
    }

    @Override
    public boolean compute(@NonNull Node callee, @NonNull BigRational clock) {
        return true;
    }

    @Override
    public BigRational[] prepareAuto(@NonNull Node callee, boolean sendFreq) {
        return null;
    }

    @Override
    public void closeAuto() {
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        return EErrorType.CannotSetup;
    }

    @Override
    public void setScaleComputed() {
    }

    @Override
    public void setTreeScaleComputed(@NonNull Node callee) {
    }

    @Override
    public void resetInputOutputClock() {
    }

    @Override
    public @NonNull List<@NonNull Node> getDirectlyConnectedTo(@NonNull Node callee, @NonNull Node node) {
        throw new UnsupportedOperationException("Method getDirectlyConnnectedTo is not applicable for class Node.");
    }

    @Override
    public @Nullable BigRational getActualScale() {
        throw new UnsupportedOperationException("Method getActualScale is not applicable for this class.");
    }
}

