/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.EScaleType;
import com.nxp.swtools.clocks.model.LinearTimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;

public class LargeLinearScale
extends LinearTimingScale {
    public LargeLinearScale(@NonNull BigRational fromScale, @NonNull BigRational toScale, @NonNull BigRational step) {
        super(fromScale, toScale, step);
        this.type = EScaleType.LinearLarge;
    }

    @Override
    public boolean elem(@Nullable BigRational value) {
        if (value == null) {
            return false;
        }
        if (value.compareTo(this.from) < 0 || value.compareTo(this.to) > 0) {
            return false;
        }
        if (ONE.equals(this.numOfScales)) {
            return true;
        }
        return value.subtract(this.from).modulo(this.step).compareTo(BigRational.ZERO) == 0;
    }

    @Override
    public @NonNull BigRational closest(@NonNull BigRational value) {
        if (value.compareTo(this.from) < 0) {
            return this.from;
        }
        if (value.compareTo(this.to) > 0) {
            return this.to;
        }
        if (ONE.equals(this.numOfScales)) {
            return this.from;
        }
        @NonNull BigRational low = this.from;
        @NonNull BigRational high = this.to;
        BigInteger tmpN = this.numOfScales;
        assert (tmpN != null);
        tmpN = tmpN.divide(TWO);
        assert (tmpN != null);
        @NonNull BigRational mid = this.from.add(this.step.multiply(tmpN));
        int cmp;
        while ((cmp = value.compareTo(mid)) != 0) {
            if (cmp > 0) {
                low = mid.add(this.step);
            } else {
                high = mid.subtract(this.step);
            }
            if (high.compareTo(low) < 0) {
                if (value.subtract(high).compareTo(value.subtract(low).negate()) < 0) {
                    return high;
                }
                return low;
            }
            BigInteger partial = LargeLinearScale.divNN(high.subtract(low).divide(this.step).add(ONE).getNumerator(), TWO);
            mid = low.add(this.step.multiply(partial));
        }
        return mid;
    }

    @Override
    public @Nullable BigRational closestUp(@NonNull BigRational value) {
        if (value.compareTo(this.from) < 0) {
            return this.from;
        }
        if (value.compareTo(this.to) > 0) {
            return null;
        }
        if (ONE.equals(this.numOfScales)) {
            return this.from;
        }
        @NonNull BigRational low = this.from;
        @NonNull BigRational high = this.to;
        BigInteger tmpN = this.numOfScales;
        assert (tmpN != null);
        tmpN = tmpN.divide(TWO);
        assert (tmpN != null);
        @NonNull BigRational mid = this.from.add(this.step.multiply(tmpN));
        int cmp;
        while ((cmp = value.compareTo(mid)) != 0) {
            if (cmp > 0) {
                low = mid.add(this.step);
            } else {
                high = mid.subtract(this.step);
            }
            if (high.compareTo(low) < 0) {
                return low;
            }
            BigInteger partial = LargeLinearScale.divNN(high.subtract(low).divide(this.step).add(ONE).getNumerator(), TWO);
            mid = low.add(this.step.multiply(partial));
        }
        return mid;
    }

    @Override
    public @Nullable BigRational closestDown(@NonNull BigRational value) {
        if (value.compareTo(this.from) < 0) {
            return null;
        }
        if (value.compareTo(this.to) > 0) {
            return this.to;
        }
        if (ONE.equals(this.numOfScales)) {
            return this.from;
        }
        @NonNull BigRational low = this.from;
        @NonNull BigRational high = this.to;
        BigInteger tmpN = this.numOfScales;
        assert (tmpN != null);
        tmpN = tmpN.divide(TWO);
        assert (tmpN != null);
        @NonNull BigRational mid = this.from.add(this.step.multiply(tmpN));
        int cmp;
        while ((cmp = value.compareTo(mid)) != 0) {
            if (cmp > 0) {
                low = mid.add(this.step);
            } else {
                high = mid.subtract(this.step);
            }
            if (high.compareTo(low) < 0) {
                return high;
            }
            BigInteger partial = LargeLinearScale.divNN(high.subtract(low).divide(this.step).add(ONE).getNumerator(), TWO);
            mid = low.add(this.step.multiply(partial));
        }
        return mid;
    }
}

