/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.table;

import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.common.utils.NonNull;
import java.util.function.Predicate;

public class SettingsFilter {
    @NonNull
    private IClocksConfig config;
    @NonNull
    private @NonNull Predicate<@NonNull ISetting> filterPredicate;

    public SettingsFilter(@NonNull IClocksConfig config) {
        this.config = config;
        this.filterPredicate = x -> true;
    }

    public @NonNull Predicate<@NonNull ISetting> activePredicate() {
        return x -> {
            boolean inactive;
            boolean enabled = x.isEnabled(this.config);
            SettingValue settingValue = this.config.getSettingsConfig().getSettingValue((ISetting)x);
            boolean bl = inactive = settingValue.isN_A() || settingValue.isUndefined();
            return enabled && !inactive;
        };
    }

    public @NonNull Predicate<@NonNull ISetting> lockedPredicate() {
        return x -> x.isUserLockable() && this.config.isLocked((ISetting)x);
    }

    public @NonNull Predicate<@NonNull ISetting> errorneousPredicate() {
        return x -> !x.isValid(this.config.getSettingsConfig().getSettingValue((ISetting)x), this.config);
    }

    public void andPredicate(@NonNull Predicate<@NonNull ISetting> predicate) {
        this.filterPredicate = this.filterPredicate.and(predicate);
    }

    public void orPredicate(@NonNull Predicate<@NonNull ISetting> predicate) {
        this.filterPredicate = this.filterPredicate.or(predicate);
    }

    public boolean testSetting(@NonNull ISetting setting) {
        return this.filterPredicate.test(setting);
    }

    public void updateConfig(@NonNull IClocksConfig activeConfig) {
        this.config = activeConfig;
    }
}

