/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagram;

import com.nxp.swtools.clocks.ui.diagram.DiagramStyleProvider;
import com.nxp.swtools.clocks.ui.diagramsymbols.DrawState;
import com.nxp.swtools.clocks.ui.diagramsymbols.Fill;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.common.utils.NonNull;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.eclipse.swt.events.PaintEvent;

public class Junction
extends GraphicalElement {
    @NonNull
    Point2D mPositionDS;
    static final double SIZE = 0.6;

    public Junction(@NonNull Point2D position) {
        this.mPositionDS = position;
    }

    @Override
    public void draw(AffineTransform trans, PaintEvent e, DiagramStyleProvider styleProvider) {
        Point2D centerCS = trans.transform(this.mPositionDS, null);
        double sizeCS = trans.getScaleX() * 0.6;
        Fill fill = styleProvider.getStyle((GraphicalElement)this, (DrawState)this.mDrawState).Fill;
        fill.set(e);
        e.gc.fillOval((int)(centerCS.getX() - sizeCS), (int)(centerCS.getY() - sizeCS), (int)(2.0 * sizeCS) + 1, (int)(2.0 * sizeCS) + 1);
        fill.unset(e);
    }

    @Override
    protected GraphicalElement makeCopy() {
        Point2D.Double p = new Point2D.Double(this.mPositionDS.getX(), this.mPositionDS.getY());
        return new Junction(p);
    }

    @Override
    public void applyTransform(AffineTransform transformDS) {
        transformDS.transform(this.mPositionDS, this.mPositionDS);
    }

    @Override
    public boolean isHitBy(Point2D p) {
        return false;
    }

    public @NonNull Point2D getPosition() {
        return this.mPositionDS;
    }
}

