/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagram;

import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.DrawState;
import com.nxp.swtools.clocks.ui.diagramsymbols.Pin;
import com.nxp.swtools.clocks.ui.diagramsymbols.Wire;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.util.ArrayList;
import java.util.Collection;

public class DiagramConnection {
    @Nullable
    protected DiagramSymbol succElement;
    @NonNull
    DiagramSymbol predElement;
    @Nullable
    protected Pin succPin;
    @NonNull
    Pin predPin;
    @NonNull
    Collection<Wire> wires = new ArrayList<Wire>();
    @NonNull
    public static final String SEPARATOR = "->";
    @NonNull
    public static final String NO_SUCC_ID = "";

    public DiagramConnection(@NonNull Pin predPin, @NonNull DiagramSymbol predElement) {
        this.predPin = predPin;
        this.predElement = predElement;
    }

    public @NonNull DiagramConnection makeCopy() {
        DiagramConnection connection = new DiagramConnection(this.predPin, this.predElement);
        connection.succPin = this.succPin;
        connection.succElement = this.succElement;
        connection.predElement = this.predElement;
        connection.wires = new ArrayList<Wire>(this.wires);
        return connection;
    }

    public String toString() {
        return this.getId();
    }

    public @NonNull String getId() {
        return DiagramConnection.createConnectionID(this.getPredecessorId(), this.getSuccessorId());
    }

    public @NonNull String getSuccessorId() {
        return this.succElement != null ? this.succElement.getId() : NO_SUCC_ID;
    }

    public @NonNull String getPredecessorId() {
        return this.predElement.getId();
    }

    public void update(@NonNull DrawState.State state) {
        this.predPin.update(state);
        this.updateButPred(state);
    }

    public void updateButPred(@NonNull DrawState.State state) {
        for (Wire wire : this.wires) {
            wire.update(state);
        }
        Pin inPin = this.getSuccPin();
        if (inPin != null) {
            inPin.update(state);
        }
    }

    public static @NonNull String createConnectionID(@NonNull String fromElementId, @NonNull String toElementId) {
        return String.valueOf(fromElementId) + SEPARATOR + toElementId;
    }

    public @NonNull DiagramSymbol getPredecessor() {
        return this.predElement;
    }

    public @Nullable DiagramSymbol getSuccessor() {
        return this.succElement;
    }

    public void setSuccessor(DiagramSymbol symbol) {
        this.succElement = symbol;
    }

    public void setSuccessorPin(Pin pin) {
        this.succPin = pin;
    }

    public @Nullable Pin getSuccPin() {
        return this.succPin;
    }

    public @NonNull Pin getPredPin() {
        return this.predPin;
    }

    public @NonNull Collection<Wire> getWires() {
        return this.wires;
    }
}

