/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui;

import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.utils.ClocksSourcesHelper;
import com.nxp.swtools.codemanager.GeneratedCodeStatus;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.provider.configuration.storage.ICustomCopyrightHeaderRead;
import com.nxp.swtools.resourcetables.model.mcu.ACommonMcu;
import com.nxp.swtools.resourcetables.model.mcu.ICommonMcu;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.sources.ISourcesContentProvider;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClocksSourcesProvider
implements ISourcesContentProvider {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Collection<@NonNull ISourceFile> getContent() {
        IClocksProfile profile = UiController.getInstance().getProfile();
        ScriptResult lastWorkingResult = profile.getLastWorkingGeneratedCode();
        LinkedHashMap<@NonNull String, @NonNull String> generatedCode = new LinkedHashMap<String, String>();
        if (ClocksSourcesHelper.isGeneratingForMultiCore(lastWorkingResult)) {
            for (String core : lastWorkingResult.getCores()) {
                @NonNull @NonNull Map generatedCodeForCore = lastWorkingResult.getOpenedFiles(core);
                if (generatedCodeForCore == null) continue;
                for (Map.Entry entry : generatedCodeForCore.entrySet()) {
                    generatedCode.put(ACommonMcu.addCoreNameIfMulticore((ICommonMcu)profile.getMcu(), (String)core, (String)((String)entry.getKey())), (String)entry.getValue());
                }
            }
        } else {
            generatedCode.putAll(lastWorkingResult.getOpenedFiles());
        }
        return SourceFileProviderFactory.buildSourceFileList(generatedCode, (ICustomCopyrightHeaderRead)SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().getCustomCopyright());
    }

    public boolean isOutOfSync() {
        ScriptResult scriptResult = ClocksSourcesProvider.getScriptResult();
        return scriptResult.containsAnyError() || GeneratedCodeStatus.getInstance().isOutOfSync();
    }

    public @Nullable String getStatus() {
        String result = Messages.get().ClocksSourcesProvider_Status_CodeGenerated;
        ScriptResult scriptResult = ClocksSourcesProvider.getScriptResult();
        if (scriptResult.containsAnyError()) {
            result = Messages.get().ClocksSourcesProvider_Status_CodeGenerationFailed;
        } else if (!scriptResult.getWarnings().isEmpty()) {
            result = Messages.get().ClocksSourcesProvider_Status_CodeGeneratedWithWarnings;
        }
        return result;
    }

    public @Nullable String getErrorText() {
        return ClocksSourcesProvider.getScriptResult().getErrors();
    }

    public @Nullable String getWarningText() {
        return ClocksSourcesProvider.getScriptResult().getWarnings();
    }

    private static @NonNull ScriptResult getScriptResult() {
        return UiController.getInstance().getProfile().getGeneratedCode();
    }
}

