/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.settings;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.AGeneralSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.clocks.expression.DependencyContextWrapper;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.utils.ExpressionUtils;
import com.nxp.swtools.clocks.utils.ToolTipBuilder;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.utils.registers.BitFieldProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AFrequencyModifierSetting
extends AGeneralSetting {
    @NonNull
    private IClockElement clockElement;

    public AFrequencyModifierSetting(@NonNull IClockElement element) {
        super(element.getName(), SettingType.FREQUENCY_MODIFIER, element, true, true, true);
        this.clockElement = element;
    }

    @Override
    public @NonNull SettingValue createCurrentValue(@NonNull IClocksConfig config) {
        ValueMap valueMap = this.clockElement.getActiveValueMap(config);
        if (valueMap == null) {
            LOGGER.warning("There is no active value map.");
        } else {
            @NonNull BitFieldElement[] bitFields = valueMap.getBitFields();
            if (bitFields.length != 0) {
                SettingValue settingValue;
                LongValues longValues = LongValues.fromConfig(config, bitFields);
                String uiValue = valueMap.getUiValueByBfValue(longValues);
                if (uiValue != null && (settingValue = this.parseUiValue(uiValue, config)) != null) {
                    return settingValue;
                }
            } else {
                return config.getSettingsConfig().getSettingValue(this);
            }
        }
        return SettingValue.N_A;
    }

    @Override
    public @NonNull Collection<@NonNull String> getUsedBitFields() {
        HashSet<@NonNull String> usedBitFields = new HashSet<String>();
        Set<Map.Entry<@NonNull Expression, @NonNull ValueMap>> valueEntries = this.clockElement.getValues().entrySet();
        for (Map.Entry<Expression, ValueMap> valueEntry : valueEntries) {
            valueEntry.getKey().getBitFields().forEach(x -> {
                boolean bl = usedBitFields.add(BitFieldProvider.createBitFieldId((String)x.getRegisterName(), (String)x.getRegisterName()));
            });
            List<@NonNull BitFieldElement> bitFields = Arrays.asList(valueEntry.getValue().getBitFields());
            bitFields.forEach(x -> {
                boolean bl = usedBitFields.add(x.getID());
            });
        }
        return usedBitFields;
    }

    @Override
    public @NonNull Collection<@NonNull String> getDependencies(@NonNull IMcu mcu) {
        Set<@NonNull Expression> caseExpressions = this.clockElement.getValues().keySet();
        assert (caseExpressions != null);
        Collection<@NonNull String> dependencies = ExpressionUtils.getRelatedSettingIDs(caseExpressions, mcu);
        dependencies.addAll(this.getInfluencedSettings(mcu));
        return dependencies;
    }

    @Override
    public @NonNull Collection<@NonNull String> getInfluencedSettings(@NonNull IMcu mcu) {
        HashSet<@NonNull Expression> expressions = new HashSet<Expression>();
        this.clockElement.getValues().values().forEach(x -> {
            boolean bl = expressions.add(x.getExpression());
        });
        return ExpressionUtils.getRelatedSettingIDs(expressions, mcu);
    }

    @Override
    public boolean canRead(@NonNull IClocksConfig config, @NonNull Collection<@NonNull String> resolvedSettingIds) {
        ValueMap activeValueMap = this.clockElement.getActiveValueMap(config);
        if (activeValueMap != null) {
            Expression caseExpr = ExpressionUtils.getCaseExpression(activeValueMap, this.clockElement.getValues());
            return resolvedSettingIds.containsAll(ExpressionUtils.getUsedSettings(config, caseExpr)) && resolvedSettingIds.containsAll(ExpressionUtils.getUsedSettings(config, activeValueMap.getExpression()));
        }
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean canWrite(@NonNull IClocksConfig config, @NonNull Collection<@NonNull String> resolvedSettingIds) throws UnsupportedOperationException {
        Expression caseExpr;
        HashSet<@NonNull String> usedSettings = new HashSet<String>();
        ValueMap activeValueMap = this.clockElement.getActiveValueMap(config);
        if (activeValueMap != null && (caseExpr = ExpressionUtils.getCaseExpression(activeValueMap, this.clockElement.getValues())) != null) {
            DependencyContextWrapper dependencyContextWrapper = ExpressionUtils.getDependencyContextWrapper(caseExpr, config);
            caseExpr.resolve(dependencyContextWrapper);
            usedSettings.addAll(dependencyContextWrapper.getAllUsedSettings(config));
        }
        return resolvedSettingIds.containsAll(usedSettings);
    }

    @Override
    public @NonNull Map<@NonNull ISetting, @NonNull SettingValue> getBitFieldsToWrite(@NonNull IClocksConfig config, @NonNull SettingValue value) throws UnsupportedOperationException {
        HashMap<@NonNull ISetting, @NonNull SettingValue> bitFieldsToWrite = new HashMap<ISetting, SettingValue>();
        ValueMap activeValueMap = this.clockElement.getActiveValueMap(config);
        if (activeValueMap != null) {
            LongValues bfFromControlValue = activeValueMap.getBfFromControlValue(value.getValue());
            if (bfFromControlValue == null) {
                throw new UnsupportedOperationException();
            }
            BitFieldElement @NonNull [] bitFields = activeValueMap.getBitFields();
            int i = 0;
            while (i < bitFields.length) {
                ISetting bitFieldSetting;
                BitFieldElement bitField = bitFields[i];
                if (bitField != null && (bitFieldSetting = SettingProvider.getBitFieldSetting(bitField, config.getMcu())) != null) {
                    SettingValue bfSettingValue = bitFieldSetting.parseBfValue(bfFromControlValue.getValue(i), config);
                    if (bfSettingValue != null) {
                        bitFieldsToWrite.put(bitFieldSetting, bfSettingValue);
                    } else {
                        throw new UnsupportedOperationException();
                    }
                }
                ++i;
            }
        }
        return bitFieldsToWrite;
    }

    @Override
    public @NonNull Collection<@NonNull ISetting> getReadOnlySettings(@NonNull IClocksConfig config) {
        ValueMap activeValueMap = this.clockElement.getActiveValueMap(config);
        Set<Map.Entry<@NonNull Expression, @NonNull ValueMap>> valueEntries = this.clockElement.getValues().entrySet();
        if (activeValueMap != null) {
            for (Map.Entry<Expression, ValueMap> valueEntry : valueEntries) {
                Expression expression = valueEntry.getKey();
                if (!valueEntry.getValue().equals(activeValueMap) || expression == null) continue;
                return ExpressionUtils.getRelatedSettings(expression, config.getMcu());
            }
        }
        LOGGER.warning("No Conditional value found for value map of setting: " + this.getId());
        return new ArrayList<ISetting>();
    }

    @Override
    public @Nullable String getToolTipText(@NonNull IClocksConfig clocksConfig) {
        return ToolTipBuilder.create(this.clockElement, this, clocksConfig);
    }
}

