/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.model;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.ClockSelect;
import com.nxp.swtools.clocks.data.elements.ClockSource;
import com.nxp.swtools.clocks.data.elements.EnableDisableCondition;
import com.nxp.swtools.clocks.data.elements.Fll;
import com.nxp.swtools.clocks.data.elements.FnPll;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.NoClock;
import com.nxp.swtools.clocks.data.elements.Pll;
import com.nxp.swtools.clocks.data.elements.Prescaler;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.ClocksConfig;
import com.nxp.swtools.clocks.data.model.ClocksProblem;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.clocks.model.FrequencyRange;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyCalculator;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;

@NonNullByDefault
public class OutputEnabler {
    public static final int PROBLEM_LEVEL_ERROR = 2;
    private static final int PROGRESS_BAR = 10000000;
    private static final int MAX_RANGE_VALUE_TRIES = 10;
    protected static final Logger LOGGER = LogManager.getLogger(OutputEnabler.class);
    private static final FrequencyRange RANGE_UNDECIDABLE = new FrequencyRange(BigRational.valueOf((long)-1L), BigRational.valueOf((long)-1L));
    private ClockOutput clockOutput;
    private ClocksConfig clocksConfig;
    private Collection<ClocksProblem> problems;
    private Map<ClocksConfig, Integer> erroneousCandidates = new LinkedHashMap<ClocksConfig, Integer>();
    private List<ClocksConfig> candidatesWithGlobalChange = new ArrayList<ClocksConfig>();
    private Map<ClocksConfig, Map<ISetting, SettingValue>> changedSettingsStorage = new HashMap<ClocksConfig, Map<ISetting, SettingValue>>();
    private Map<List<IClockElement>, Map<ISetting, SettingValue>> savedSubPaths = new HashMap<List<IClockElement>, Map<ISetting, SettingValue>>();
    private Set<List<IClockElement>> failingSubPaths = new HashSet<List<IClockElement>>();

    public OutputEnabler(ClockOutput clockOutput, ClocksConfig clocksConfig) {
        this.clockOutput = clockOutput;
        this.clocksConfig = clocksConfig;
        this.problems = new ArrayList<ClocksProblem>(clocksConfig.getProblems());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean enableOutput(Display display, @Nullable IProgressMonitor monitor) {
        ClocksConfig result;
        SubMonitor subMonitor = null;
        if (monitor != null) {
            subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10000000);
        }
        if ((result = this.findEnablePath(this.clocksConfig.clone(this.clocksConfig.getClocksModel()), null, subMonitor)) == null) {
            result = !this.candidatesWithGlobalChange.isEmpty() ? this.candidatesWithGlobalChange.get(0) : this.pickLeastErroneousCandidate();
        }
        if (result != null) {
            IClocksProfile profile = UiController.getInstance().getProfile();
            profile.updateConfig(result);
            display.asyncExec(profile::regenerateCode);
            this.updateLastlyChangedSettings(result);
            Map<ISetting, @Nullable SettingValue> lastlyChanged = result.getSettingsConfig().getLastlyChanged();
            if (!lastlyChanged.isEmpty()) {
                @Nullable Map.Entry entry = (Map.Entry)CollectionsUtils.last(lastlyChanged.entrySet());
                UiController.getInstance().setLastlyChangedSetting(((ISetting)entry.getKey()).getId());
            }
            OutputEnabler.completeMonitor(subMonitor);
            return true;
        }
        OutputEnabler.completeMonitor(subMonitor);
        return false;
    }

    private static void completeMonitor(@Nullable SubMonitor subMonitor) {
        if (subMonitor != null) {
            subMonitor.worked(10000000);
            subMonitor.done();
        }
    }

    private static boolean isMonitorCancelled(@Nullable SubMonitor subMonitor) {
        return subMonitor != null && subMonitor.isCanceled();
    }

    private static @Nullable SubMonitor splitMonitor(@Nullable SubMonitor subMonitor, int work) {
        if (subMonitor == null) {
            return null;
        }
        return subMonitor.split(work);
    }

    private static void setWorkRemaingToMonitor(@Nullable SubMonitor subMonitor, int work) {
        if (subMonitor != null) {
            subMonitor.setWorkRemaining(work);
        }
    }

    private static void monitorWorked(@Nullable SubMonitor subMonitor, int work) {
        if (subMonitor != null) {
            subMonitor.worked(work);
        }
    }

    private @Nullable ClocksConfig findEnablePath(ClocksConfig config, @Nullable ClockSelect lastExpandedSelector, @Nullable SubMonitor subMonitor) {
        List<IClockElement> elementsOnPath = config.getPathToOutput(this.clockOutput.getID());
        int startingSearchIndex = elementsOnPath.size() - 1;
        if (lastExpandedSelector != null) {
            int index = elementsOnPath.indexOf(lastExpandedSelector);
            if (index == -1) {
                LOGGER.log(Level.SEVERE, "Output Enabler: Clock selector {0} was specified as branching point in recursive call, but is not present on the current path. Selector must be on the path in given config.", lastExpandedSelector);
                return null;
            }
            startingSearchIndex = index - 1;
        }
        int i = startingSearchIndex;
        while (i >= 0) {
            if (OutputEnabler.isMonitorCancelled(subMonitor)) {
                return null;
            }
            IClockElement element = elementsOnPath.get(i);
            ISetting setting = element.getSetting(SettingType.FREQUENCY_MODIFIER);
            if (element instanceof ClockSelect && setting != null) {
                ClockSelect selector = (ClockSelect)element;
                ClocksConfig resultForSelector = null;
                List<SettingValue> settingValues = this.getSortedSelectorValue(selector, config);
                int perBrachBarPart = 10000000 / (settingValues.size() + 1);
                for (SettingValue settingValue : settingValues) {
                    SubMonitor recursiveMonitor = OutputEnabler.splitMonitor(subMonitor, perBrachBarPart);
                    OutputEnabler.setWorkRemaingToMonitor(recursiveMonitor, 10000000);
                    ClocksConfig configClone = this.branchSelector(config, setting, settingValue);
                    ClocksConfig branchResult = this.findEnablePath(configClone, selector, recursiveMonitor);
                    if (branchResult != null && !this.isErrorInOutput(branchResult) && !this.containsErrors(branchResult)) {
                        resultForSelector = branchResult;
                        OutputEnabler.completeMonitor(recursiveMonitor);
                        break;
                    }
                    this.changedSettingsStorage.remove(configClone);
                    OutputEnabler.completeMonitor(recursiveMonitor);
                }
                OutputEnabler.completeMonitor(subMonitor);
                return resultForSelector;
            }
            --i;
        }
        return this.forwardEnableElements(config, subMonitor, elementsOnPath);
    }

    private @Nullable ClocksConfig forwardEnableElements(ClocksConfig config, @Nullable SubMonitor subMonitor, List<IClockElement> elementsOnPath) {
        if (this.shouldCutPath(config, elementsOnPath)) {
            OutputEnabler.completeMonitor(subMonitor);
            return null;
        }
        Map changedSettings = this.changedSettingsStorage.getOrDefault(config, new HashMap());
        int forwardStartIndex = 0;
        int i = elementsOnPath.size() - 1;
        while (i >= 0) {
            Map<ISetting, SettingValue> changedSubpathSettings = this.savedSubPaths.get(elementsOnPath.subList(0, i));
            if (changedSubpathSettings != null) {
                OutputEnabler.updatePathSettings(config, changedSettings, changedSubpathSettings);
                forwardStartIndex = i;
                break;
            }
            --i;
        }
        int progressBarPart = 10000000 / elementsOnPath.size();
        int i2 = forwardStartIndex;
        while (i2 < elementsOnPath.size()) {
            IClockElement element = elementsOnPath.get(i2);
            if (OutputEnabler.isMonitorCancelled(subMonitor)) {
                return null;
            }
            if (!element.isEnabledForModel(config) && this.clockOutput.isDisabled(config)) {
                changedSettings.putAll(OutputEnabler.enableClockElement(element, config));
                if (!element.isEnabledForModel(config)) {
                    this.failingSubPaths.add(elementsOnPath.subList(0, i2 + 1));
                    OutputEnabler.completeMonitor(subMonitor);
                    return null;
                }
            }
            if (element.getSuccessors().size() > 1) {
                this.savedSubPaths.put(elementsOnPath.subList(0, i2 + 1), new HashMap(changedSettings));
            }
            OutputEnabler.monitorWorked(subMonitor, progressBarPart);
            ++i2;
        }
        if (!this.cutBeforeRecomputeCheck(config)) {
            config.recompute(false, this.clockOutput.getOutputFrequencySetting());
        }
        OutputEnabler.completeMonitor(subMonitor);
        return this.verifyResult(config, changedSettings);
    }

    private @Nullable ClocksConfig verifyResult(ClocksConfig config, Map<ISetting, SettingValue> changedSettings) {
        if (this.isErrorInOutput(config) || this.clockOutput.isDisabled(config)) {
            List<IClockElement> elementsOnPath = config.getPathToOutput(this.clockOutput.getID());
            for (IClockElement element : elementsOnPath) {
                if (!element.isDisabled(config) || element.equals(this.clockOutput)) continue;
                this.failingSubPaths.add(elementsOnPath.subList(0, elementsOnPath.indexOf(element) + 1));
                break;
            }
            return null;
        }
        ClocksConfig result = config;
        this.changedSettingsStorage.put(result, changedSettings);
        int errorCount = this.errorCount(result);
        if (errorCount > 0) {
            this.erroneousCandidates.put(result, errorCount);
            result = null;
        } else if (OutputEnabler.containsGlobalElementChange(changedSettings.keySet())) {
            this.candidatesWithGlobalChange.add(result);
            result = null;
        }
        return result;
    }

    private static void updatePathSettings(ClocksConfig config, Map<ISetting, SettingValue> changedSettings, Map<ISetting, SettingValue> subpathSettings) {
        for (Map.Entry<ISetting, SettingValue> entry : subpathSettings.entrySet()) {
            ISetting setting = entry.getKey();
            if (setting.getElement() instanceof ClockSelect) continue;
            changedSettings.put(setting, entry.getValue());
            OutputEnabler.setSettingValue(setting, entry.getValue(), config);
        }
    }

    private boolean shouldCutPath(ClocksConfig config, List<IClockElement> elementsOnPath) {
        if (elementsOnPath.isEmpty()) {
            return true;
        }
        int i = 0;
        while (i < elementsOnPath.size()) {
            if (this.failingSubPaths.contains(elementsOnPath.subList(0, i))) {
                return true;
            }
            ++i;
        }
        IClockElement firstElement = elementsOnPath.get(0);
        if (firstElement instanceof ClockSource) {
            ClockSource clockSource = (ClockSource)firstElement;
            return !clockSource.isInternal() && clockSource.isDisabled(config);
        }
        return true;
    }

    private static boolean isConstraintRelevant(Constraint constraint, ClocksConfig config) {
        return constraint.isApplicable(config) && constraint.isValid(config) && !constraint.isOnInput() && constraint.getLevel().equals((Object)Constraint.Level.ERROR);
    }

    private boolean cutBeforeRecomputeCheck(ClocksConfig config) {
        @Nullable LockState outputLockState = config.getSettingsConfig().getLockState(this.clockOutput.getOutputFrequencySetting());
        if (outputLockState == null) {
            return false;
        }
        Frequency requiredFreq = Frequency.parseNonNull((String)outputLockState.getValue().getUiValue());
        for (Constraint constraint : this.clockOutput.getElementConstraints()) {
            if (!OutputEnabler.isConstraintRelevant(constraint, config) || !constraint.isViolatedBy(requiredFreq)) continue;
            return true;
        }
        List<IClockElement> elementsOnPath = config.getPathToOutput(this.clockOutput.getID());
        BigRational frequencyRational = FrequencyCalculator.toHertz((Frequency)requiredFreq).getValue();
        FrequencyRange outputRange = new FrequencyRange(frequencyRational, frequencyRational);
        int i = elementsOnPath.size() - 2;
        while (i >= 0) {
            IClockElement element = elementsOnPath.get(i);
            for (Constraint constraint : element.getElementConstraints()) {
                if (!OutputEnabler.isConstraintRelevant(constraint, config) || !OutputEnabler.checkConstraintRange(constraint, outputRange)) continue;
                return true;
            }
            if ((outputRange = OutputEnabler.updatePossibleRange(element, config, outputRange)).equals((Object)RANGE_UNDECIDABLE)) break;
            --i;
        }
        return false;
    }

    private static boolean checkConstraintRange(Constraint constraint, FrequencyRange outputRange) {
        FrequencyRange exactRange = constraint.getAccuracyRangeOfExactFrequency();
        if (exactRange != null && (exactRange.getMaximalFrequency().compareTo(outputRange.getMinimalFrequency()) < 0 || exactRange.getMinimalFrequency().compareTo(outputRange.getMaximalFrequency()) > 0)) {
            return true;
        }
        Frequency constraintMax = constraint.getMaxFrequencyWithAccuracy();
        Frequency constraintMin = constraint.getMinFrequencyWithAccuracy();
        BigRational max = constraintMax == null ? null : FrequencyCalculator.toHertz((Frequency)constraintMax).getValue();
        BigRational min = constraintMin == null ? BigRational.ZERO : FrequencyCalculator.toHertz((Frequency)constraintMin).getValue();
        List<FrequencyRange> ranges = constraint.getFrequencyRangesWithAccuracy();
        if (ranges != null) {
            for (FrequencyRange range : ranges) {
                if (range.getMinimalFrequency().compareTo(min) < 0) {
                    min = range.getMinimalFrequency();
                }
                if (max != null && range.getMaximalFrequency().compareTo(max) <= 0) continue;
                max = range.getMaximalFrequency();
            }
        }
        return max != null && max.compareTo(outputRange.getMinimalFrequency()) < 0 || min.compareTo(outputRange.getMaximalFrequency()) > 0;
    }

    private static FrequencyRange updatePossibleRange(IClockElement element, ClocksConfig config, FrequencyRange outputRange) {
        if (outputRange.equals((Object)RANGE_UNDECIDABLE)) {
            return RANGE_UNDECIDABLE;
        }
        FrequencyRange result = outputRange;
        if (element instanceof Prescaler) {
            BigRational maxOutput = outputRange.getMaximalFrequency();
            BigRational minOutput = outputRange.getMinimalFrequency();
            Prescaler prescaler = (Prescaler)element;
            ArrayList<BigRational> scales = new ArrayList<BigRational>(prescaler.getScaleValues(config));
            BigRational minScale = null;
            BigRational maxScale = null;
            if (!scales.isEmpty()) {
                scales.sort(null);
                minScale = (BigRational)scales.get(0);
                maxScale = (BigRational)scales.get(scales.size() - 1);
            } else {
                ValueMap valueMap = prescaler.getActiveValueMap(config);
                if (valueMap == null) {
                    return RANGE_UNDECIDABLE;
                }
                Range scaleRange = valueMap.getRange();
                if (scaleRange == null) {
                    return RANGE_UNDECIDABLE;
                }
                minScale = scaleRange.getMin();
                maxScale = scaleRange.getMax();
            }
            if (prescaler.isDivider()) {
                maxOutput = maxOutput.multiply(maxScale);
                minOutput = minOutput.multiply(minScale);
            } else {
                minScale = minScale.equals((Object)BigRational.ZERO) ? BigRational.ONE : minScale;
                maxScale = maxScale.equals((Object)BigRational.ZERO) ? BigRational.ONE : maxScale;
                maxOutput = maxOutput.divide(minScale);
                minOutput = minOutput.divide(maxScale);
            }
            result = new FrequencyRange(minOutput, maxOutput);
        } else if (element instanceof Pll) {
            Pll pll = (Pll)element;
            FrequencyRange semiResult = OutputEnabler.updatePossibleRange(pll.getMultiplier(), config, outputRange);
            semiResult = OutputEnabler.updatePossibleRange(pll.getDivider(), config, semiResult);
            Prescaler postdivider = pll.getPostDivider();
            if (postdivider != null) {
                semiResult = OutputEnabler.updatePossibleRange(postdivider, config, semiResult);
            }
            result = semiResult;
        } else if (element instanceof Fll) {
            Fll fll = (Fll)element;
            result = OutputEnabler.updatePossibleRange(fll.getMultiplier(), config, outputRange);
        } else if (element instanceof FnPll) {
            FnPll fnpll = (FnPll)element;
            BigRational maxOutput = outputRange.getMaximalFrequency();
            BigRational minOutput = outputRange.getMinimalFrequency();
            Range scaleLimits = OutputEnabler.getFnPllScaleLimits(fnpll, config);
            if (scaleLimits == null) {
                return RANGE_UNDECIDABLE;
            }
            BigRational minScale = scaleLimits.getMin();
            BigRational maxScale = scaleLimits.getMax();
            minScale = minScale.equals((Object)BigRational.ZERO) ? BigRational.ONE : minScale;
            maxScale = maxScale.equals((Object)BigRational.ZERO) ? BigRational.ONE : maxScale;
            maxOutput = maxOutput.divide(minScale);
            minOutput = minOutput.divide(maxScale);
            result = new FrequencyRange(minOutput, maxOutput);
        }
        return result;
    }

    private static @Nullable Range getFnPllScaleLimits(FnPll fnpll, ClocksConfig config) {
        List<SettingValue> possibleValues = fnpll.getDivSetting().getValues(config);
        Range possibleRange = fnpll.getDivSetting().getRangeOfValues(config);
        BigRational minScale = null;
        BigRational maxScale = null;
        if (possibleRange != null) {
            minScale = possibleRange.getMin().add(fnpll.getRange().getMin());
            maxScale = possibleRange.getMax().add(fnpll.getRange().getMax());
        } else if (possibleValues != null && !possibleValues.isEmpty()) {
            for (SettingValue value : possibleValues) {
                Object innerValue = value.getValue();
                BigRational valueRational = null;
                if (innerValue instanceof BigRational) {
                    valueRational = (BigRational)innerValue;
                } else if (innerValue instanceof BigInteger) {
                    valueRational = new BigRational((BigInteger)innerValue);
                } else if (innerValue instanceof BigDecimal) {
                    valueRational = new BigRational((BigDecimal)innerValue);
                } else if (innerValue instanceof String) {
                    valueRational = BigRational.tryParse((String)((String)innerValue));
                } else if (innerValue instanceof Number) {
                    valueRational = BigRational.tryParse((String)((Number)innerValue).toString());
                }
                if (valueRational == null) continue;
                if (minScale == null || minScale.compareTo(valueRational) > 0) {
                    minScale = valueRational;
                }
                if (maxScale != null && maxScale.compareTo(valueRational) >= 0) continue;
                maxScale = valueRational;
            }
        }
        if (minScale == null || maxScale == null) {
            return null;
        }
        return new Range(minScale, maxScale);
    }

    private static boolean containsGlobalElementChange(Collection<ISetting> changedSettings) {
        for (ISetting setting : changedSettings) {
            if (!SettingType.GLOBAL_CONFIG_ELEMENT.equals((Object)setting.getType())) continue;
            return true;
        }
        return false;
    }

    private @Nullable ClocksConfig pickLeastErroneousCandidate() {
        ClocksConfig leastErroneous = null;
        int minErrorCount = Integer.MAX_VALUE;
        for (Map.Entry<ClocksConfig, Integer> entry : this.erroneousCandidates.entrySet()) {
            int candidateMinimum = entry.getValue();
            if (candidateMinimum >= minErrorCount) continue;
            minErrorCount = candidateMinimum;
            leastErroneous = entry.getKey();
        }
        return leastErroneous;
    }

    private static Map<ISetting, SettingValue> enableClockElement(IClockElement element, ClocksConfig config) {
        EnableSetting enableSetting;
        HashMap<ISetting, SettingValue> settingsToChange = new HashMap<ISetting, SettingValue>();
        if (!element.isEnabledForModel(config) && (enableSetting = element.getEnableSetting()) != null && OutputEnabler.enableSetting(enableSetting, config, settingsToChange)) {
            OutputEnabler.setSettingValue(enableSetting, EnableSetting.ENABLED_SETTING, config);
        }
        return settingsToChange;
    }

    private static boolean enableSetting(EnableSetting enableSetting, ClocksConfig config, Map<ISetting, SettingValue> changedSettings) {
        List<ISetting> dependencySettings = OutputEnabler.collectDependencies(enableSetting, config);
        HashSet<String> usedSettings = new HashSet<String>();
        EnableDisableCondition activeCase = enableSetting.activeCase(config, usedSettings);
        for (ISetting dependencySetting : dependencySettings) {
            ClocksConfig tempConfig;
            if (dependencySetting.getElement() instanceof ClockSelect && dependencySetting.getType().equals((Object)SettingType.FREQUENCY_MODIFIER) || !OutputEnabler.trySetListValues(dependencySetting, tempConfig = config.clone(config.getClocksModel()), activeCase, changedSettings) && !OutputEnabler.trySetRangeValues(dependencySetting, tempConfig, activeCase, changedSettings) && !OutputEnabler.trySetDefaultValue(dependencySetting, tempConfig, activeCase, changedSettings)) continue;
            for (Map.Entry<ISetting, SettingValue> entry : changedSettings.entrySet()) {
                ISetting setting = entry.getKey();
                OutputEnabler.setSettingValue(setting, entry.getValue(), config);
            }
            return true;
        }
        return false;
    }

    private static List<ISetting> collectDependencies(EnableSetting enableSetting, ClocksConfig config) {
        IMcu mcu = config.getMcu();
        HashSet<String> dependencyIds = new HashSet<String>();
        dependencyIds.addAll(enableSetting.getDependencies(mcu));
        Set<String> controlSettingIds = mcu.getControlSettings(enableSetting.getId());
        if (controlSettingIds != null) {
            dependencyIds.addAll(controlSettingIds);
        }
        Set<ISetting> dependencySettings = OutputEnabler.dependencySettingsFromIDs(config, dependencyIds);
        return OutputEnabler.orderDependencySettings(dependencySettings);
    }

    private static Set<ISetting> dependencySettingsFromIDs(ClocksConfig config, Set<String> dependencyIds) {
        IMcu mcu = config.getMcu();
        HashSet<ISetting> dependencySettings = new HashSet<ISetting>();
        for (String id : dependencyIds) {
            ISetting dependencySetting = SettingProvider.getSettingById(id, mcu);
            if (!Objects.nonNull(dependencySetting)) continue;
            if (dependencySetting.getType().equals((Object)SettingType.BIT_FIELD)) {
                Set<String> controlSettingIds = mcu.getControlSettings(dependencySetting.getId());
                if (controlSettingIds == null) continue;
                dependencySettings.addAll(OutputEnabler.dependencySettingsFromIDs(config, controlSettingIds));
                continue;
            }
            if (dependencySetting instanceof EnableSetting) {
                dependencySettings.addAll(OutputEnabler.collectDependencies((EnableSetting)dependencySetting, config));
                continue;
            }
            dependencySettings.add(dependencySetting);
        }
        return dependencySettings;
    }

    private static List<ISetting> orderDependencySettings(Set<ISetting> dependencySettings) {
        ArrayList<ISetting> result = new ArrayList<ISetting>();
        ArrayList<ISetting> other = new ArrayList<ISetting>();
        ArrayList<ISetting> global = new ArrayList<ISetting>();
        for (ISetting setting : dependencySettings) {
            switch (setting.getType()) {
                case LOCAL_CONFIG_ELEMENT: {
                    result.add(setting);
                    break;
                }
                case GLOBAL_CONFIG_ELEMENT: {
                    global.add(setting);
                    break;
                }
                default: {
                    other.add(setting);
                }
            }
        }
        result.addAll(other);
        result.addAll(global);
        return result;
    }

    private static boolean trySetListValues(ISetting setting, ClocksConfig config, EnableDisableCondition condition, Map<ISetting, SettingValue> settingsToChange) {
        List<SettingValue> values = setting.getValues(config);
        if (values != null && !values.isEmpty()) {
            values = new ArrayList<SettingValue>(values);
            values.sort((o1, o2) -> o1.getUiValue().compareTo(o2.getUiValue()));
            for (SettingValue value : values) {
                if (!OutputEnabler.testSettingValueForCondition(setting, value, config, condition, settingsToChange)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean trySetRangeValues(ISetting setting, ClocksConfig config, EnableDisableCondition condition, Map<ISetting, SettingValue> settingsToChange) {
        BigInteger rangeSize;
        Range valueRange = setting.getRangeOfValues(config);
        BigInteger bigInteger = rangeSize = valueRange != null ? valueRange.getSize() : null;
        if (valueRange != null && rangeSize != null) {
            BigRational step = new BigRational(rangeSize).divide(BigInteger.valueOf(10L));
            BigRational i = valueRange.min;
            while (i.compareTo(valueRange.max) <= 0) {
                SettingValue value = new SettingValue(i);
                if (OutputEnabler.testSettingValueForCondition(setting, value, config, condition, settingsToChange)) {
                    return true;
                }
                i = i.add(step);
            }
        }
        return false;
    }

    private static boolean trySetDefaultValue(ISetting setting, ClocksConfig config, EnableDisableCondition condition, Map<ISetting, SettingValue> settingsToChange) {
        SettingValue defaultValue = setting.getDefaultValue(config);
        return defaultValue != null && OutputEnabler.testSettingValueForCondition(setting, defaultValue, config, condition, settingsToChange);
    }

    private static boolean testSettingValueForCondition(ISetting setting, SettingValue value, ClocksConfig config, EnableDisableCondition condition, Map<ISetting, SettingValue> settingsToChange) {
        OutputEnabler.setSettingValue(setting, value, config);
        boolean result = condition.isEnabled(config);
        if (result) {
            settingsToChange.put(setting, value);
        }
        return result;
    }

    private static void setSettingValue(ISetting setting, SettingValue value, ClocksConfig config) {
        config.setSettingValue(setting, value, false, config.isLocked(setting));
        if (setting.isWritable()) {
            try {
                for (Map.Entry<ISetting, SettingValue> entry : setting.getBitFieldsToWrite(config, value).entrySet()) {
                    config.setSettingValue(entry.getKey(), entry.getValue(), false, config.isLocked(entry.getKey()));
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    private List<SettingValue> getSortedSelectorValue(ClockSelect clockSelect, ClocksConfig config) {
        ArrayList<SettingValue> settingsValues = new ArrayList<SettingValue>();
        ISetting setting = clockSelect.getSetting(SettingType.FREQUENCY_MODIFIER);
        if (setting != null) {
            ArrayList<IClockElement> predecessors = new ArrayList<IClockElement>(clockSelect.getPredecessors());
            predecessors.sort((o1, o2) -> o1.getID().compareTo(o2.getID()));
            SettingValue originalValue = this.clocksConfig.getSettingsConfig().getSettingValue(setting);
            for (IClockElement predecessor : predecessors) {
                SettingValue settingValue;
                if (predecessor instanceof NoClock || (settingValue = setting.parseValue(predecessor.getID(), config)) == null || originalValue.equals(settingValue)) continue;
                if (predecessor.isEnabled(config)) {
                    settingsValues.add(0, settingValue);
                    continue;
                }
                settingsValues.add(settingValue);
            }
            settingsValues.add(0, originalValue);
        }
        return settingsValues;
    }

    private ClocksConfig branchSelector(ClocksConfig config, ISetting setting, SettingValue settingValue) {
        ClocksConfig configClone = config.clone(config.getClocksModel());
        configClone.setSettingValue(setting, settingValue, true, config.isLocked(setting));
        HashMap<ISetting, SettingValue> changedSettings = this.changedSettingsStorage.containsKey(config) ? new HashMap<ISetting, SettingValue>(this.changedSettingsStorage.get(config)) : new HashMap();
        changedSettings.put(setting, settingValue);
        this.changedSettingsStorage.put(configClone, changedSettings);
        return configClone;
    }

    private boolean containsErrors(ClocksConfig config) {
        for (ClocksProblem problem : config.getProblems()) {
            if (problem.getProblemLevel() < 2) continue;
            boolean contains = true;
            for (ClocksProblem originProblem : this.problems) {
                if (originProblem.getProblemLevel() < 2 || !originProblem.getResource().equals(problem.getResource())) continue;
                contains = false;
            }
            if (!contains) continue;
            return true;
        }
        return false;
    }

    private int errorCount(ClocksConfig config) {
        int errors = 0;
        for (ClocksProblem problem : config.getProblems()) {
            if (problem.getProblemLevel() < 2) continue;
            boolean newError = true;
            for (ClocksProblem originProblem : this.problems) {
                if (originProblem.getProblemLevel() < 2 || !originProblem.getResource().equals(problem.getResource())) continue;
                newError = false;
                break;
            }
            if (!newError) continue;
            ++errors;
        }
        return errors;
    }

    private boolean isErrorInOutput(ClocksConfig config) {
        return !config.getProblemsOfElement(this.clockOutput.getID(), 2).isEmpty();
    }

    private void updateLastlyChangedSettings(IClocksConfig config) {
        Map<ISetting, SettingValue> changedSettings = this.changedSettingsStorage.get(config);
        if (changedSettings != null) {
            SettingsConfig settingsConfig = config.getSettingsConfig();
            for (Map.Entry<ISetting, SettingValue> entry : changedSettings.entrySet()) {
                ISetting setting = entry.getKey();
                SettingValue newValue = entry.getValue();
                SettingValue lastValue = this.clocksConfig.getSettingsConfig().getSettingValue(setting);
                settingsConfig.addLastlyChangedSetting(setting, lastValue);
                if (!setting.isWritable()) continue;
                Map<ISetting, SettingValue> bitfields = setting.getBitFieldsToWrite(config, newValue);
                bitfields.forEach(settingsConfig::addLastlyChangedSetting);
            }
        }
    }
}

