/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.model;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.IMcuDescriptor;
import com.nxp.swtools.clocks.data.McuDB;
import com.nxp.swtools.clocks.data.McuDescriptor;
import com.nxp.swtools.clocks.data.elements.ComputationalModel;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.EmptyMcu;
import com.nxp.swtools.clocks.data.model.EmptyProfile;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.settings.BitFieldSetting;
import com.nxp.swtools.clocks.data.settings.ClockSourceSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.resources.DataDirectory;
import com.nxp.swtools.clocks.script.RegistersDefinesGenerator;
import com.nxp.swtools.clocks.script.ScriptProfileProvider;
import com.nxp.swtools.codemanager.CodeManager;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.IStorageConfigurationPreferencesRead;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksConfiguration;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksIdValue;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksOutput;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksProfile;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksSource;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksTool;
import com.nxp.swtools.utils.registers.BitFieldInfo;
import com.nxp.swtools.utils.scripting.CodeGenerator;
import com.nxp.swtools.utils.scripting.ScriptFileProvider;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.scripting.api.IProfileProvider;
import com.nxp.swtools.utils.scripting.api.IScriptFileProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.script.CompiledScript;

public class ClocksProfile
implements IClocksProfile {
    @NonNull
    public static final String DEFAULT_CONFIG_NAME_PREFIX = "ClocksFunc_";
    @NonNull
    public static final String INIT_FUNCTION_NAME = "BOARD_InitBootClocks";
    @NonNull
    public static final String DEFAULT_CONFIG_NAME = "BOARD_BootClockRUN";
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ClocksProfile.class);
    @NonNull
    private final ComputationalModel model;
    @NonNull
    private final @NonNull List<@NonNull IClocksConfig> configs;
    @Nullable
    private IClocksConfig activeConfig;
    @Nullable
    private final String board;
    @Nullable
    private final String kit;
    @NonNull
    private ScriptResult codeGenerationResult;
    @NonNull
    private ScriptResult lastWorkingGenerationResult;
    private boolean yamlEnabled;

    public ClocksProfile(@NonNull IMcu mcu, @Nullable String board, @Nullable String kit) {
        this.lastWorkingGenerationResult = this.codeGenerationResult = new ScriptResult.Builder().build();
        this.model = ComputationalModel.createFor(mcu);
        this.configs = new ArrayList<IClocksConfig>();
        this.board = board;
        this.kit = kit;
        this.yamlEnabled = SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().isYamlOutputEnabled();
    }

    private ClocksProfile(@NonNull ClocksProfile original, boolean useSameModel) {
        this.lastWorkingGenerationResult = this.codeGenerationResult = new ScriptResult.Builder().build();
        this.model = useSameModel ? original.model : ComputationalModel.createFor(original.getMcu());
        int idxOfActiveConfig = original.configs.indexOf(original.activeConfig);
        this.configs = new ArrayList<IClocksConfig>(original.configs.size());
        for (IClocksConfig originalConfig : original.configs) {
            IClocksConfig configClone = originalConfig.clone(this.model);
            configClone.setProfile(this);
            this.configs.add(configClone);
        }
        if (idxOfActiveConfig >= 0) {
            this.activeConfig = this.configs.get(idxOfActiveConfig);
        }
        this.board = original.board;
        this.kit = original.kit;
        this.yamlEnabled = SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().isYamlOutputEnabled();
    }

    @Override
    public IMcu getMcu() {
        return this.model.getMcu();
    }

    @Override
    public IMcuDescriptor getMcuDescriptor() {
        return this.model.getMcu().getMcuDescriptor();
    }

    @Override
    public List<@NonNull IClocksConfig> getConfigs() {
        return CollectionsUtils.unmodifiableList(this.configs);
    }

    @Override
    public @NonNull ComputationalModel getModel() {
        return this.model;
    }

    @Override
    public IClocksConfig getActiveConfig() {
        return this.activeConfig;
    }

    @Override
    public @NonNull IClocksConfig resetToDefaults(@NonNull IClocksConfig config) {
        int configIdx = this.configs.indexOf(config);
        if (configIdx == -1) {
            throw new IllegalArgumentException("The config is not part of a clocks profile.");
        }
        this.configs.remove(configIdx);
        IClocksConfig copy = this.model.getMcu().getDefaultConfig().clone(this.model);
        copy.setName(config.getName());
        copy.setDescription(config.getDescription());
        copy.setCalledFromDefaultInit(config.isCalledFromDefaultInit());
        copy.setPrefixUserDefined(config.isPrefixUserDefined());
        copy.setIdPrefix(config.getIdPrefix());
        copy.setProfile(config.getProfile());
        this.configs.add(configIdx, copy);
        if (this.activeConfig == config) {
            this.activeConfig = copy;
        }
        return copy;
    }

    @Override
    public @NonNull IClocksConfig resetToStorageConfig(@NonNull IClocksConfig config, @NonNull StorageClocksConfiguration storageConfig) {
        int configIdx = this.configs.indexOf(config);
        if (configIdx == -1) {
            throw new IllegalArgumentException("The config is not part of a clocks profile.");
        }
        this.configs.remove(configIdx);
        IClocksConfig copy = ClocksProfile.fromStorageConfig(this.getMcu(), this, storageConfig);
        copy.setName(config.getName());
        copy.setDescription(config.getDescription());
        copy.setCalledFromDefaultInit(config.isCalledFromDefaultInit());
        copy.setPrefixUserDefined(config.isPrefixUserDefined());
        copy.setIdPrefix(config.getIdPrefix());
        copy.setProfile(this);
        copy.getSettingsConfig().clearChanges();
        this.configs.add(configIdx, copy);
        if (this.activeConfig == config) {
            this.activeConfig = copy;
        }
        return copy;
    }

    @Override
    public @NonNull IClocksConfig resetActiveConfigToDefaults() {
        if (this.activeConfig != null) {
            return this.resetToDefaults(this.activeConfig);
        }
        throw new IllegalStateException("No active config");
    }

    @Override
    public @NonNull IClocksConfig resetActiveConfigToStorageConfig(@NonNull StorageClocksConfiguration storageConfig) {
        if (this.activeConfig != null) {
            return this.resetToStorageConfig(this.activeConfig, storageConfig);
        }
        throw new IllegalStateException("No active config");
    }

    @Override
    public void recomputeActiveConfig(boolean forceAuto) {
        if (this.activeConfig == null) {
            throw new IllegalStateException("No active config");
        }
        this.activeConfig.recompute(forceAuto, null);
    }

    @Override
    public boolean containsErrors() {
        for (IClocksConfig config : this.configs) {
            if (!config.getProblems().stream().anyMatch(x -> x.getProblemLevel() == 2)) continue;
            return true;
        }
        return false;
    }

    private List<@NonNull String> getErrors() {
        ArrayList<@NonNull String> errors = new ArrayList<String>();
        for (IClocksConfig config : this.configs) {
            if (!config.getProblems().stream().anyMatch(x -> x.getProblemLevel() == 2) || config.getErrorText() == null) continue;
            errors.add(MessageFormat.format("Functional group {0}: {1}", config.getName(), config.getErrorText()));
        }
        return errors;
    }

    @Override
    public @NonNull IClocksProfile clone(boolean useSameModel) {
        return new ClocksProfile(this, useSameModel);
    }

    @Override
    public @NonNull IClocksConfig createDefaultConfig() {
        IClocksConfig defaultConfig = this.model.getMcu().getDefaultConfig();
        IClocksConfig defaultConfigCopy = defaultConfig.clone(this.model);
        defaultConfigCopy.setName(DEFAULT_CONFIG_NAME);
        defaultConfigCopy.setCalledFromDefaultInit(true);
        defaultConfigCopy.setPrefixUserDefined(false);
        defaultConfigCopy.setIdPrefix(DEFAULT_CONFIG_NAME);
        return defaultConfigCopy;
    }

    @Override
    public void setActiveConfig(@NonNull IClocksConfig config) {
        if (!this.configs.contains(config)) {
            LOGGER.warning("Cannot set configuration " + config.getName() + " as active configuration of the profile, because this configuration is not registered in the profile");
        } else {
            this.activeConfig = config;
        }
    }

    @Override
    public @Nullable IClocksConfig removeConfig(@NonNull IClocksConfig config) {
        IClocksConfig newActiveConfig = null;
        int removedConfigIndex = this.configs.indexOf(config);
        if (!this.configs.remove(config)) {
            LOGGER.warning("Cannot remove configuration " + config.getName() + " from the profile, because this configuration is not registered in the profile");
        } else {
            config.setProfile(null);
        }
        if (removedConfigIndex >= this.configs.size()) {
            --removedConfigIndex;
        }
        if (removedConfigIndex >= 0 && removedConfigIndex < this.configs.size()) {
            newActiveConfig = this.configs.get(removedConfigIndex);
        }
        return newActiveConfig;
    }

    @Override
    public @NonNull StorageClocksTool toStorageProfile(@Nullable StorageClocksTool prevProfile) {
        StorageClocksTool clocks = new StorageClocksTool();
        if (prevProfile != null) {
            clocks.setUpdateCode(prevProfile.getUpdateCode());
            clocks.setGeneratedProjectFiles(prevProfile.getGeneratedProjectFiles());
        }
        StorageClocksProfile profile = clocks.getClocksProfile();
        profile.setProcessorVersion(this.model.getMcu().getVersion());
        ArrayList configurations = clocks.getConfigurations();
        for (IClocksConfig config : this.configs) {
            StorageClocksConfiguration configuration = config.getStorageConfig();
            configurations.add(configuration);
        }
        return clocks;
    }

    public static @NonNull IClocksProfile fromStorageProfile(@NonNull StorageClocksTool clocks, @NonNull IMcuDescriptor mcuDescriptor, @Nullable String board, @Nullable String kit) {
        IMcu mcu = McuDB.getInstance().getMcu(mcuDescriptor);
        if (mcu instanceof EmptyMcu) {
            return new EmptyProfile(UtilsText.safeString((String)Messages.get().ClocksProfile_McuNotSupported));
        }
        ClocksProfile clocksProfile = new ClocksProfile(mcu, board, kit);
        for (StorageClocksConfiguration configuration : clocks.getConfigurations()) {
            IClocksConfig config = ClocksProfile.fromStorageConfig(mcu, clocksProfile, configuration);
            clocksProfile.addConfig(config);
        }
        if (clocksProfile.getConfigs().size() <= 0) {
            clocksProfile.addConfig(clocksProfile.createDefaultConfig());
        }
        if ("1.0".equals(clocks.getVersion()) || clocks.getVersion().isEmpty()) {
            clocksProfile.getConfigs().forEach(c -> {
                if (DEFAULT_CONFIG_NAME.equals(c.getName())) {
                    c.setCalledFromDefaultInit(true);
                }
            });
        }
        Optional<IClocksConfig> initConfig = clocksProfile.getConfigs().stream().filter(IClocksConfig::isCalledFromDefaultInit).findFirst();
        IClocksConfig activeConfigToSet = initConfig.orElse(clocksProfile.getConfigs().get(0));
        assert (activeConfigToSet != null);
        clocksProfile.setActiveConfig(activeConfigToSet);
        return clocksProfile;
    }

    public static @NonNull IClocksConfig fromStorageConfig(@NonNull IMcu mcu, @NonNull IClocksProfile clocksProfile, @NonNull StorageClocksConfiguration configuration) {
        IClocksConfig config = clocksProfile.createDefaultConfig();
        config.setName(configuration.getName());
        config.setDescription(configuration.getDescription());
        config.setCalledFromDefaultInit(configuration.isCalledFromInit());
        config.setPrefixUserDefined(configuration.isPrefixUserDefined());
        if (configuration.isPrefixUserDefined()) {
            config.setIdPrefix(configuration.getIdPrefix());
        } else {
            config.setIdPrefix(configuration.getName());
        }
        Map<@NonNull ISetting, @NonNull StorageClocksIdValue> storageValues = ClocksProfile.createStorageValuesMap(mcu, configuration, config);
        config.recompute(false, null, storageValues);
        return config;
    }

    public static @NonNull IClocksConfig fromBitFieldConfig(@NonNull IMcu mcu, @NonNull IClocksProfile clocksProfile, @NonNull Collection<@NonNull BitFieldInfo> bitFieldInfo, @NonNull String origName, boolean overrideLocks) {
        IClocksConfig config = clocksProfile.getConfigByName(origName);
        if (config == null) {
            config = clocksProfile.createDefaultConfig();
            config.recompute(null);
            config.setName(origName);
            config.setCalledFromDefaultInit(false);
        }
        IClocksConfig configLoc = config;
        bitFieldInfo.forEach(x -> {
            ISetting setting = SettingProvider.getBitFieldSetting(new BitFieldElement(x.getBitField()), mcu);
            SettingValue value = BitFieldSetting.createValue(x);
            if (setting != null && value != null) {
                configLoc.setSettingValue(setting, value, false, true);
            } else {
                LOGGER.fine("Not able to find bit field: " + x.getBitFieldName());
            }
        });
        if (overrideLocks) {
            configLoc.unlockBitFieldDependencies();
        }
        config.recompute(false, null, true);
        config.lockBitFieldDependencies();
        bitFieldInfo.forEach(x -> {
            ISetting setting = SettingProvider.getBitFieldSetting(new BitFieldElement(x.getBitField()), mcu);
            if (setting != null) {
                configLoc.unlockSetting(setting, false);
            } else {
                LOGGER.fine("Not able to find bit field: " + x.getBitFieldName());
            }
        });
        return config;
    }

    public static @NonNull IClocksProfile fromStorageProfile(@NonNull StorageClocksTool clocks, @NonNull ICommonConfig mcuSelection) {
        McuDescriptor mcu = McuDescriptor.fromSharedConfig(mcuSelection);
        if (mcu == null) {
            throw new IllegalStateException("MCU is not selected");
        }
        return ClocksProfile.fromStorageProfile(clocks, mcu, mcuSelection.getBoard(), mcuSelection.getKit());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull Map<@NonNull ISetting, @NonNull StorageClocksIdValue> createStorageValuesMap(@NonNull IMcu mcu, @NonNull StorageClocksConfiguration storageClocksConfiguration, @NonNull IClocksConfig config) {
        Collection<@NonNull ISetting> powerModeSpecificSettingsCollection = mcu.getSettings().getPowerModeSpecificAllSettings();
        HashMap<@NonNull ISetting, @NonNull StorageClocksIdValue> storageValues = new HashMap<ISetting, StorageClocksIdValue>();
        @NonNull List sources = storageClocksConfiguration.getSources();
        @NonNull List outputs = storageClocksConfiguration.getOutputs();
        @NonNull List settings = storageClocksConfiguration.getSettings();
        Stream<@NonNull R> streamOfValues = Stream.of(sources, outputs, settings).flatMap(Collection::stream);
        streamOfValues.forEach(x -> {
            ISetting setting = SettingProvider.getSettingById(x.getId(), mcu);
            if (setting == null) {
                try {
                    setting = powerModeSpecificSettingsCollection.stream().filter(y -> y.getId().equals(x.getId())).findFirst().get();
                    @NonNull SettingValue value = ClocksProfile.restoreSetting(config, x);
                    if (value == null) {
                        return;
                    }
                    config.setSettingValue(setting, value, false, config.isLocked(setting));
                    storageValues.put(setting, (StorageClocksIdValue)x);
                }
                catch (NoSuchElementException noSuchElementException) {
                    LOGGER.warning("Cannot find setting with ID: " + x.getId());
                }
            } else {
                storageValues.put(setting, (StorageClocksIdValue)x);
            }
        });
        return storageValues;
    }

    public static @NonNull IClocksProfile createProfileForMcu(@NonNull ICommonConfig mcuSelection) {
        McuDescriptor descriptor = McuDescriptor.fromSharedConfig(mcuSelection);
        if (descriptor == null) {
            return new EmptyProfile(UtilsText.safeString((String)Messages.get().ClocksProfile_McuNotSelected));
        }
        IMcu mcu = McuDB.getInstance().getMcu(descriptor);
        if (mcu instanceof EmptyMcu) {
            return new EmptyProfile(UtilsText.safeString((String)Messages.get().ClocksProfile_McuNotSupported));
        }
        return new ClocksProfile(mcu, mcuSelection.getBoard(), mcuSelection.getKit());
    }

    public static @Nullable SettingValue restoreSetting(@NonNull IClocksConfig config, @NonNull StorageClocksIdValue val) {
        String[] split = val.getId().split(":");
        ISetting setting = split.length == 2 ? SettingProvider.getPowerModeSpecificSettingById(split[1], split[0], config.getMcu()) : SettingProvider.getSettingById(split[0], config.getMcu());
        if (setting == null) {
            setting = SettingProvider.getSettingById(val.getId(), config.getMcu());
        }
        if (setting != null) {
            SettingValue value = null;
            value = setting instanceof ClockSourceSetting && val instanceof StorageClocksSource ? ((ClockSourceSetting)setting).fromStorage((StorageClocksSource)val, config) : setting.fromString(val.getValue(), config);
            if (value == null) {
                LOGGER.warning("Cannot restore value (" + val.getValue() + ") of setting: " + setting.getId());
            } else {
                if (split.length == 2) {
                    config.getSettingsConfig().setSettingValue(setting, value);
                } else {
                    config.setSettingValue(setting, value, false, false);
                }
                if (setting.isUserLockable()) {
                    if (val.isLocked()) {
                        config.lockSetting(setting);
                        if (val instanceof StorageClocksOutput) {
                            String accuracyString = ((StorageClocksOutput)val).getAccuracy();
                            BigRational accuracy = BigRational.tryParse((String)accuracyString);
                            if (accuracy == null) {
                                accuracy = SettingsConfig.DEFAULT_ACCURACY;
                            }
                            config.changeLockAccuracy(setting, accuracy, false);
                        }
                    } else {
                        config.unlockSetting(setting, false);
                    }
                } else {
                    LockState lockState = config.getSettingsConfig().getLockState(setting);
                    if (lockState != null) {
                        lockState = new LockState(lockState, value);
                        config.getSettingsConfig().setLockState(setting, lockState);
                    }
                }
                if (val instanceof StorageClocksSource) {
                    boolean enabled = ((StorageClocksSource)val).isEnabled();
                    config.getSettingsConfig().setUserEnabled(setting, enabled);
                }
                return value;
            }
        }
        return null;
    }

    public static void restoreUserEnabled(@NonNull IClocksConfig config, @NonNull StorageClocksIdValue val) {
        ISetting setting;
        if (val instanceof StorageClocksSource && (setting = SettingProvider.getSettingById(val.getId(), config.getMcu())) != null) {
            boolean enabled = ((StorageClocksSource)val).isEnabled();
            config.getSettingsConfig().setUserEnabled(setting, enabled);
        }
    }

    public ScriptResult generateRegistersDefinesFile(ScriptResult scriptResult) {
        return scriptResult.addFile("clock_registers.h", RegistersDefinesGenerator.generateContent(this.configs));
    }

    @Override
    public void addConfig(@NonNull IClocksConfig config) {
        this.configs.add(config);
        config.setProfile(this);
    }

    @Override
    public boolean updateConfig(@NonNull IClocksConfig config) {
        IClocksConfig originalConfig = this.getConfigByName(config.getName());
        if (originalConfig != null) {
            int originalIndex = this.configs.indexOf(originalConfig);
            boolean isActive = originalConfig == this.activeConfig;
            this.removeConfig(originalConfig);
            this.addConfigToPos(config, originalIndex);
            config.setProfile(this);
            if (isActive) {
                this.activeConfig = config;
            }
            return true;
        }
        return false;
    }

    @Override
    public void switchPositionsOf(@NonNull IClocksConfig config1, @NonNull IClocksConfig config2) {
        int idx1 = this.configs.indexOf(config1);
        int idx2 = this.configs.indexOf(config2);
        if (idx1 >= 0 && idx2 >= 0) {
            Collections.swap(this.configs, idx1, idx2);
        }
    }

    @Override
    public void addConfigToPos(@NonNull IClocksConfig config, int position) {
        if (!this.configs.contains(config) && position <= this.configs.size()) {
            this.configs.add(position, config);
            config.setProfile(this);
        }
    }

    @Override
    public @Nullable String getBoard() {
        return this.board;
    }

    @Override
    public @Nullable String getKit() {
        return this.kit;
    }

    @Override
    public void forceCodeRegeneration() {
        long executionTime;
        long forceCodeRegenerationStart = System.nanoTime();
        ScriptResult scriptResult = null;
        if (this.containsErrors()) {
            String message = UtilsText.safeString((String)Messages.get().ClocksProfile_CannotGenerateCode);
            ScriptResult.Builder builder = new ScriptResult.Builder();
            List<@NonNull String> errors = this.getErrors();
            if (errors.isEmpty()) {
                builder.appendError(message);
            } else {
                errors.forEach(arg_0 -> ((ScriptResult.Builder)builder).appendError(arg_0));
            }
            scriptResult = builder.build();
        } else {
            IMcu mcu = this.getMcu();
            CompiledScript script = mcu.getCodeGeneratingScript();
            ScriptFileProvider fileProvider = new ScriptFileProvider(new String[]{DataDirectory.getClocksJavaScriptDir(mcu.getMcuDescriptor())});
            ScriptProfileProvider profileProvider = new ScriptProfileProvider(this);
            ISharedConfiguration sharedConfiguration = SharedConfigurationFactory.getSharedConfigurationSingleton();
            CodeGenerator codeGenerator = new CodeGenerator((IProfileProvider)profileProvider, (IScriptFileProvider)fileProvider, (IStorageConfigurationPreferencesRead)sharedConfiguration.getPreferences());
            codeGenerator.setTimeoutMs(CodeManager.TIMEOUT_GENERATION_MS);
            scriptResult = codeGenerator.generate(script);
            if (sharedConfiguration.getPreferences().isGenerateRegistersDefines()) {
                scriptResult = this.generateRegistersDefinesFile(scriptResult);
            }
            profileProvider.close(!scriptResult.containsAnyError());
        }
        if (!scriptResult.containsAnyError()) {
            this.lastWorkingGenerationResult = scriptResult;
        }
        this.codeGenerationResult = scriptResult;
        if (SWToolsProperties.isVerificationOn() && (executionTime = (System.nanoTime() - forceCodeRegenerationStart) / 1000000L) >= 150L) {
            LOGGER.warning("Force code regeneration is executed for a long time (more than 150 ms).");
        }
    }

    @Override
    public void regenerateCode() {
        ISharedConfiguration sharedConfiguration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        if (sharedConfiguration.getPreferences().isCodePreviewEnabled() || SWToolsProperties.isHeadlessOn()) {
            this.forceCodeRegeneration();
        }
    }

    @Override
    public @NonNull ScriptResult getGeneratedCode() {
        return this.codeGenerationResult;
    }

    @Override
    public @NonNull ScriptResult getLastWorkingGeneratedCode() {
        return this.lastWorkingGenerationResult;
    }

    @Override
    public @NonNull String createUniqueConfigName() {
        int i = 1;
        while (i <= 20) {
            String newConfigName = DEFAULT_CONFIG_NAME_PREFIX + i;
            Stream<@NonNull IClocksConfig> matchingConfigNames = this.getConfigs().stream().filter(x -> x.getName().equals(newConfigName));
            if (matchingConfigNames.count() == 0L) {
                return newConfigName;
            }
            ++i;
        }
        LOGGER.warning("No config names availible.");
        return DEFAULT_CONFIG_NAME_PREFIX;
    }

    @Override
    public void removeAllConfigs() {
        this.configs.clear();
    }

    @Override
    public void addConfigs(@NonNull List<@NonNull IClocksConfig> configurations) {
        this.configs.addAll(configurations);
        configurations.forEach(x -> x.setProfile(this));
    }

    @Override
    public @Nullable IClocksConfig getConfigByName(@NonNull String configName) {
        Optional<@NonNull IClocksConfig> optional = this.configs.stream().filter(x -> Objects.equals(x.getName(), configName)).findFirst();
        return (IClocksConfig)CollectionsUtils.nullableOptionalGet(optional);
    }

    @Override
    public boolean isYamlEnabled() {
        return this.yamlEnabled;
    }

    @Override
    public void setYamlEnabled(boolean generateYaml) {
        this.yamlEnabled = generateYaml;
    }
}

