/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.elements.IPowerModeSpecificElement;
import com.nxp.swtools.clocks.data.elements.PowerMode;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

@NonNullByDefault
public class PowerModeSpecificElement
implements IPowerModeSpecificElement {
    private boolean isPowerModeSpecific;
    private final Map<String, ISetting> powerModeSpecificSettings = new LinkedHashMap<String, ISetting>();
    private final Supplier<Collection<? extends IPowerModeSpecificElement>> nestedElementsSupplier;
    final Supplier<@Nullable ISetting> settingCreator;

    public PowerModeSpecificElement(Supplier<@Nullable ISetting> settingCreator, Supplier<Collection<? extends IPowerModeSpecificElement>> configElementsSupplier) {
        this.settingCreator = settingCreator;
        this.nestedElementsSupplier = configElementsSupplier;
    }

    @Override
    public @NonNull List<@NonNull ISetting> getPowerModeSpecificSettings() {
        return new ArrayList<ISetting>(this.powerModeSpecificSettings.values());
    }

    @Override
    public boolean isPowerModeSpecific() {
        return this.isPowerModeSpecific;
    }

    @Override
    public void setPowerModeSpecific(boolean isPowerModeSpecific) {
        this.isPowerModeSpecific = isPowerModeSpecific;
    }

    @Override
    public @NonNull Map<@NonNull String, @NonNull ISetting> createPowerModeSpecificSettings(@NonNull List<@NonNull PowerMode> powerModes) {
        HashMap<@NonNull String, @NonNull ISetting> result = new HashMap<String, ISetting>();
        if (this.isPowerModeSpecific()) {
            powerModes.forEach(powerMode -> {
                ISetting powerModeSpecificSetting = this.settingCreator.get();
                if (powerModeSpecificSetting != null) {
                    powerModeSpecificSetting.setPowerMode(powerMode.getID());
                    result.put(powerModeSpecificSetting.getId(), powerModeSpecificSetting);
                }
            });
        }
        CollectionsUtils.safeCollection(this.nestedElementsSupplier.get()).forEach(nestedElement -> {
            if (this.isPowerModeSpecific() || nestedElement.isPowerModeSpecific()) {
                nestedElement.setPowerModeSpecific(true);
                result.putAll(nestedElement.createPowerModeSpecificSettings(powerModes));
            }
        });
        this.powerModeSpecificSettings.putAll(result);
        return result;
    }
}

