/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.DefaultErrorHandler;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.model.ClocksProblem;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ClockOutputSetting;
import com.nxp.swtools.clocks.model.ClockModel;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ComputationalModel {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ComputationalModel.class);
    @NonNull
    private final IMcu mcu;
    @NonNull
    private final ClockModel model;

    private ComputationalModel(@NonNull IMcu mcu, boolean empty) {
        this.mcu = mcu;
        if (empty) {
            this.model = new ClockModel();
        } else {
            this.model = ClockModel.createModel(mcu.getAllModelElements());
            this.model.excludeDefaults();
        }
    }

    private ComputationalModel(@NonNull IMcu mcu, @NonNull ClockModel model) {
        this.mcu = mcu;
        this.model = model;
    }

    public static @NonNull ComputationalModel createForTesting(@NonNull IMcu mcu, @NonNull ClockModel model) {
        return new ComputationalModel(mcu, model);
    }

    public static @NonNull ComputationalModel createFor(@NonNull IMcu mcu) {
        return new ComputationalModel(mcu, false);
    }

    public static @NonNull ComputationalModel createEmptyFor(@NonNull IMcu mcu) {
        return new ComputationalModel(mcu, true);
    }

    protected ClockModel checkModel(@NonNull ClockModel clockModel, @NonNull IClocksConfig config) {
        ArrayList<@NonNull E> ls = new ArrayList();
        if (!clockModel.isEverySetOrDisabled(ls)) {
            List<@NonNull String> errorElems = ls.stream().map(Node::getID).collect(Collectors.toList());
            errorElems.forEach(x -> config.addError((String)x, "Computation failed for element", ClocksProblem.Type.OTHER));
            LOGGER.severe("There is/are error(s) in computation model. Unknown error in " + errorElems);
            LOGGER.severe("Computational model has not been created due to some errors. Demo model will be used instead.");
            return ClockModel.makeDemoModel();
        }
        return this.model;
    }

    public @NonNull Map<@NonNull String, @NonNull String> recompute(@NonNull IClocksConfig config) {
        DefaultErrorHandler errorHandler = new DefaultErrorHandler(this.mcu, config);
        this.model.setFreqLimitErrorLogger((FreqLimitErrorI)errorHandler);
        ArrayList<@NonNull E> ls = new ArrayList();
        ClockModel modelLoc = this.checkModel(this.model, config);
        modelLoc.computeDisabled(ls);
        LOGGER.fine(() -> ((ClockModel)modelLoc).stringTree());
        return errorHandler.getErrors();
    }

    public @NonNull Map<@NonNull String, EErrorType> recomputeAuto() {
        return (Map)this.model.computeAutoWRPerClock().entrySet().stream().filter(x -> x.getValue() != EErrorType.None).filter(x -> x.getValue() != EErrorType.NotEnabled).collect(CollectorsUtils.toMap(e -> ((Node)e.getKey()).getID(), Map.Entry::getValue));
    }

    public @NonNull IMcu getMcu() {
        return this.mcu;
    }

    public @NonNull Map<@NonNull String, @NonNull String> fill(@NonNull IClocksConfig config, boolean lockedOnly) {
        DefaultErrorHandler errorHandler = new DefaultErrorHandler(this.mcu, config);
        this.model.setFreqLimitErrorLogger((FreqLimitErrorI)errorHandler);
        this.mcu.getAllElements().values().forEach(element -> element.cleanModel(config));
        this.mcu.getAllElements().values().forEach(element -> element.configureModel(config, lockedOnly));
        HashMap<@NonNull String, @NonNull String> errors = new HashMap<String, String>(errorHandler.getErrors());
        Iterator<@NonNull K> erroneousElementIterator = errors.keySet().iterator();
        while (erroneousElementIterator.hasNext()) {
            IClockElement erroneousElement = this.mcu.getClockElement((String)erroneousElementIterator.next());
            if (!(erroneousElement instanceof ClockOutput)) continue;
            erroneousElementIterator.remove();
        }
        this.disableErrorneousElements(errors);
        return errors;
    }

    private void disableErrorneousElements(@NonNull Map<@NonNull String, @NonNull String> errors) {
        for (String elementID : errors.keySet()) {
            Node computationNode;
            IClockElement clockElement = this.mcu.getClockElement(elementID);
            if (clockElement == null || clockElement instanceof ClockOutput || (computationNode = this.model.getNode(clockElement.getID())) == null) continue;
            computationNode.disable();
        }
    }

    public @NonNull Map<@NonNull String, @NonNull List<@NonNull IClockElement>> loadPaths() {
        HashMap<@NonNull String, @NonNull List<@NonNull IClockElement>> paths = new HashMap<String, List<IClockElement>>();
        for (ClockOutputSetting outputSetting : this.mcu.getSettings().getClockOutputs()) {
            ClockOutput outputElement = outputSetting.getClockOutput();
            Node outputNode = this.model.getNode(outputElement.getID());
            ArrayList<Node> outputPath = new ArrayList<Node>();
            this.model.getReversePathFrom(outputNode, outputPath);
            Collections.reverse(outputPath);
            List<@NonNull IClockElement> elementsPath = ComputationalModel.toElementsList(this.mcu, outputPath);
            paths.put(outputElement.getID(), elementsPath);
        }
        return paths;
    }

    private static @NonNull List<@NonNull IClockElement> toElementsList(@NonNull IMcu mcu, @Nullable List<Node> nodeList) {
        ArrayList<@NonNull IClockElement> result = new ArrayList<IClockElement>();
        if (nodeList != null) {
            Map<String, IClockElement> elementsMap = mcu.getAllElements();
            for (Node node : nodeList) {
                IClockElement element = elementsMap.get(node.getID());
                if (element == null) continue;
                result.add(element);
            }
        }
        return result;
    }

    public @Nullable BigRational findMatchingAccuracy(@NonNull IClockElement element) {
        Node node = this.model.getNode(element.getID());
        if (node == null) {
            LOGGER.warning("Computation node of element: " + element.getID() + " is not set.");
            return null;
        }
        return this.model.runSearchInterval(node);
    }

    public @Nullable Node getNode(@NonNull String id) {
        return this.model.getNode(id);
    }
}

