/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data;

import com.nxp.swtools.clocks.data.DiagramData;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.ui.diagramsymbols.CompositeSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.InvisibleConnectionSymbol;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;

public class ClockSlice
implements IElement {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ClockSlice.class);
    @NonNull
    private String id;
    @NonNull
    private String name;
    @NonNull
    private @NonNull Collection<@NonNull DiagramSymbol> diagramSymbols = new ArrayList<DiagramSymbol>();
    @NonNull
    private @NonNull Map<@NonNull String, IClockElement> elements;
    @NonNull
    private EnableSetting enableSetting;
    @Nullable
    private DiagramData diagramData = null;
    @NonNull
    private @NonNull Map<@NonNull String, @NonNull String> sliceSignalMapping;
    @NonNull
    private @NonNull Map<@NonNull String, @NonNull String> pinMapping;
    @NonNull
    private @NonNull Map<@NonNull String, @NonNull String> unavailableElements;

    public ClockSlice(@NonNull String id, @NonNull String name, @NonNull Map<@NonNull String, IClockElement> elements, @NonNull Collection<@NonNull DiagramSymbol> diagramSymbols, @NonNull Map<@NonNull String, @NonNull String> sliceSignalMapping, @NonNull Map<@NonNull String, @NonNull String> pinMapping, @NonNull Map<@NonNull String, @NonNull String> unavailableElements) {
        this.id = id;
        this.name = name;
        this.elements = elements;
        this.sliceSignalMapping = sliceSignalMapping;
        this.pinMapping = pinMapping;
        this.enableSetting = new EnableSetting(name, this);
        this.unavailableElements = unavailableElements;
        this.setDiagramSymbols(diagramSymbols);
        if (!diagramSymbols.isEmpty()) {
            String componentID = id.substring(0, id.indexOf("."));
            for (Map.Entry<String, String> entry : this.pinMapping.entrySet()) {
                String sliceID = entry.getKey();
                String mcuID = entry.getValue();
                String searchedPinId = "@" + sliceID;
                Optional<@NonNull DiagramSymbol> searchedPin = diagramSymbols.stream().filter(x -> searchedPinId.equals(x.getId())).findAny();
                if (searchedPin.isPresent()) {
                    CompositeSymbol pin = (CompositeSymbol)searchedPin.get();
                    pin.setId(String.valueOf(componentID) + "." + mcuID);
                    pin.setDisplayName(mcuID);
                    continue;
                }
                LOGGER.severe(MessageFormat.format("Clock slice {0} doesnt have pin with ID {1} in its diagram, but it has pin {2} in its signal map.", this.getID(), searchedPinId, sliceID));
            }
            for (DiagramSymbol symbol : diagramSymbols) {
                if (!(symbol instanceof CompositeSymbol) || !symbol.getId().startsWith("@")) continue;
                LOGGER.severe(MessageFormat.format("Clock slice {0} has pin with ID {1} and failed to match it. Maybe there is a wrong or missing entry in signal map?", this.getID(), symbol.getId()));
            }
        }
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull String getID() {
        return this.id;
    }

    @Override
    public boolean isEnabled(@NonNull IClocksConfig config) {
        return true;
    }

    @Override
    public @Nullable EnableSetting getEnableSetting() {
        return this.enableSetting;
    }

    public @NonNull Map<@NonNull String, IClockElement> getElements() {
        return this.elements;
    }

    public @NonNull Collection<@NonNull DiagramSymbol> getDiagramSymbols() {
        return this.diagramSymbols;
    }

    public @NonNull Set<@NonNull String> getUnavailableElementsIDs() {
        return this.unavailableElements.keySet();
    }

    private void setDiagramSymbols(@NonNull Collection<@NonNull DiagramSymbol> diagramSymbols) {
        for (DiagramSymbol symbol : diagramSymbols) {
            if (!(symbol instanceof InvisibleConnectionSymbol) || !((InvisibleConnectionSymbol)symbol).isInput() || symbol.getId().contains(".")) continue;
            symbol.setId(String.valueOf(this.getID().split("\\.")[1]) + "." + symbol.getId());
        }
        this.diagramSymbols = diagramSymbols;
    }

    public @NonNull DiagramData getDiagramData(@NonNull IMcu mcu) {
        if (this.diagramData != null) {
            return this.diagramData;
        }
        this.diagramData = new DiagramData(this.diagramSymbols, mcu, true);
        return this.diagramData;
    }

    public @NonNull String toString() {
        return this.getID();
    }

    public void applySignalMapping(IMcu mcu) {
        if (this.diagramData != null) {
            LOGGER.severe("Method applySignalMapping should be called before diagram data for this clock slice are created (before getDiagramData is called). This could lead to incorrect behaviour of Diagram connections.");
        }
        for (Map.Entry<String, String> entry : this.sliceSignalMapping.entrySet()) {
            String sliceSignal = entry.getKey();
            String mcuSignal = entry.getValue();
            InvisibleConnectionSymbol teleport = mcu.getDiagramDataCopy().getTeleportConnectedTo(mcuSignal);
            if (teleport == null) {
                LOGGER.warning(MessageFormat.format("Clock slice {0} has signal {1} in it's signal map, but is unable to find corresponding teleport to this signal in the MCU diagram. If there is a corresponding teleport, then this is an error.", this.getID(), mcuSignal));
                continue;
            }
            String searchedTeleportId = "@" + sliceSignal;
            Optional<@NonNull DiagramSymbol> searchedTeleportOpt = this.diagramSymbols.stream().filter(x -> searchedTeleportId.equals(x.getId())).findAny();
            if (searchedTeleportOpt.isPresent()) {
                InvisibleConnectionSymbol searchedTeleport = (InvisibleConnectionSymbol)searchedTeleportOpt.get();
                searchedTeleport.setId(teleport.getId());
                String elementId = mcuSignal.endsWith(".clk") ? mcuSignal.substring(0, mcuSignal.lastIndexOf(".clk")) : mcuSignal;
                IClockElement element = mcu.getClockElement(elementId);
                if (element != null) {
                    searchedTeleport.setDisplayName(element.getName());
                    continue;
                }
                searchedTeleport.setDisplayName(mcuSignal);
                continue;
            }
            LOGGER.severe(MessageFormat.format("Clock slice {0} doesnt have teleport with ID {1} in its diagram, but it has signal {2} in its signal map.", this.getID(), searchedTeleportId, sliceSignal));
        }
        for (DiagramSymbol symbol : this.diagramSymbols) {
            if (!(symbol instanceof InvisibleConnectionSymbol) || !symbol.getId().startsWith("@")) continue;
            LOGGER.severe(MessageFormat.format("Clock slice {0} has teleport with ID {1} and failed to match it with its main diagram counterpart.", this.getID(), symbol.getId()));
        }
    }
}

