/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.ddr.importer;

import com.nxp.swtools.common.ui.utils.swt.UtilsImage;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.integration.ddr.Messages;
import com.nxp.swtools.mem.validation.integration.ddr.importer.RPAImportedData;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.data.IQuickSelection;
import com.nxp.swtools.resourcetables.model.data.IQuickSetting;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportDDRConfigDialog
extends Dialog {
    private static final Logger LOGGER = LogManager.getLogger(ImportDDRConfigDialog.class);
    private static final URL IMPORT_IMAGE_FILE;
    private static final int TEXT_WIDTH_HINT = 550;
    private static final int TEXT_HEIGHT_HINT = 100;
    @Nullable
    Text textInputFile;
    @Nullable
    Text textInputData;
    RPAImportedData importedData = RPAImportedData.getInstance();

    static {
        URL url = null;
        try {
            url = new URL("platform:/plugin/org.eclipse.ui.ide/icons/full/etool16/import_wiz.png");
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, "Failed to load import image", e);
        }
        assert (url != null);
        IMPORT_IMAGE_FILE = url;
    }

    public ImportDDRConfigDialog(Shell parent) {
        super(parent);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ImportDDRConfigDialog_0);
        newShell.setImage(UtilsImage.getImage((URL)IMPORT_IMAGE_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        final Composite mainComposite = (Composite)super.createDialogArea(parent);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)new GridLayout());
        Composite fileComposite = new Composite(mainComposite, 0);
        fileComposite.setLayout((Layout)new GridLayout(3, false));
        GridData gdFileComposite = new GridData(4, 0x1000000, true, false, 1, 1);
        gdFileComposite.widthHint = 550;
        fileComposite.setLayoutData((Object)gdFileComposite);
        Label lblFile = new Label(fileComposite, 0);
        lblFile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFile.setToolTipText(Messages.ImportDDRConfigDialog_FileInputTooltip);
        lblFile.setText(Messages.ImportDDRConfigDialog_FileInputLabel);
        Text textInputFileLoc = this.textInputFile = new Text(fileComposite, 2048);
        textInputFileLoc.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        textInputFileLoc.setToolTipText("Select the input file");
        textInputFileLoc.setEditable(false);
        Button btnBrowse = new Button(fileComposite, 0);
        btnBrowse.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        btnBrowse.setText(Messages.ImportDDRConfigDialog_BrowseLabel);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                FileDialog dlg = new FileDialog(mainComposite.getShell(), 4096);
                dlg.setFilterExtensions(new String[]{Messages.ImportDDRConfigDialog_DefaultFileExtension});
                String filepath = dlg.open();
                if (filepath != null) {
                    ImportDDRConfigDialog.this.importedData.clean();
                    if (ImportDDRConfigDialog.this.textInputFile != null) {
                        ImportDDRConfigDialog.this.textInputFile.setText(filepath);
                    }
                    ImportDDRConfigDialog.this.importedData.loadDataFromFile(filepath);
                    Text textInputDataLoc = ImportDDRConfigDialog.this.textInputData;
                    if (textInputDataLoc != null && !textInputDataLoc.isDisposed()) {
                        String selectedMemType = ImportDDRConfigDialog.this.importedData.getMemType();
                        textInputDataLoc.setText(String.format(Messages.ImportDDRConfigDialog_1, selectedMemType));
                    }
                }
            }
        });
        Group textAreaGroup = new Group(mainComposite, 0);
        textAreaGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gdTestArea = new GridData(4, 4, true, true);
        gdTestArea.heightHint = 100;
        textAreaGroup.setLayoutData((Object)gdTestArea);
        this.textInputData = new Text((Composite)textAreaGroup, 2826);
        this.textInputData.setLayoutData((Object)new GridData(4, 4, true, true));
        return mainComposite;
    }

    protected @Nullable IQuickSelection findQuickSelection(IConfigSetConfig configSet, String id, String value) {
        IQuickSelection quickSelection = null;
        String settingValue = null;
        List quickSelections = configSet.getQuickSelectionGroup().getQuickSelections();
        for (IQuickSelection qSelection : quickSelections) {
            IQuickSetting settingId = qSelection.getSetting(id);
            if (settingId == null) continue;
            settingValue = settingId.getValue();
            assert (settingValue != null);
            if (!settingValue.equals(value)) continue;
            quickSelection = qSelection;
            break;
        }
        return quickSelection;
    }

    protected void okPressed() {
        this.importedData.saveDsFile();
        this.importedData.apply();
        super.okPressed();
    }
}

