/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.integration.ddr.importer;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.ddr.controller.DDRController;
import com.nxp.swtools.mem.validation.integration.ddr.Messages;
import com.nxp.swtools.provider.configuration.storage.IStorageConfigurationPreferencesRead;
import com.nxp.swtools.utils.scripting.CodeGenerator;
import com.nxp.swtools.utils.scripting.ScriptFileProvider;
import com.nxp.swtools.utils.scripting.api.IProfileProvider;
import com.nxp.swtools.utils.scripting.api.IScriptFileProvider;
import java.lang.reflect.InvocationTargetException;
import javax.script.CompiledScript;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class DdrImportMemoryRunnable
implements IRunnableWithProgress {
    IProfileProvider profileProvider;
    @Nullable
    CompiledScript compiled;
    ScriptFileProvider resourceFileProvider;
    boolean importFinished;
    public static final long IMPORT_TIMEOUT = 500000L;

    public DdrImportMemoryRunnable(IProfileProvider profileProvider, @Nullable CompiledScript compiled, ScriptFileProvider resourceFileProvider) {
        this.profileProvider = profileProvider;
        this.compiled = compiled;
        this.resourceFileProvider = resourceFileProvider;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.beginTask(Messages.ImportDDRConfigDialog_2, 100);
        if (this.compiled != null) {
            final CompiledScript compiledScript = this.compiled;
            final DDRController controller = DDRController.getInstance();
            this.importFinished = false;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    new CodeGenerator(DdrImportMemoryRunnable.this.profileProvider, (IScriptFileProvider)DdrImportMemoryRunnable.this.resourceFileProvider, (IStorageConfigurationPreferencesRead)controller.getSharedConfiguration().getPreferences()).generate(compiledScript);
                    DdrImportMemoryRunnable.this.importFinished = true;
                }
            }).start();
            boolean importFinished = this.waitImportFinished((IProgressMonitor)subMonitor);
            if (!importFinished) {
                throw new InterruptedException(Messages.ImportDDRTargetFailedTimeout);
            }
            subMonitor.done();
            monitor.done();
        }
    }

    public boolean waitImportFinished(IProgressMonitor monitor) throws InterruptedException {
        int step = 1;
        long total = 0L;
        while (!this.importFinished) {
            Thread.sleep(900L);
            monitor.worked(step);
            if (500000L >= (total += (long)step)) continue;
            return false;
        }
        return true;
    }
}

