/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.table.params;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.model.scripts.Scripts;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.table.params.BeanPropertyParam;
import com.nxp.swtools.mem.validation.table.params.RegFieldParam;
import com.nxp.swtools.mem.validation.table.params.TestScriptParam;
import java.util.List;
import java.util.Map;

public class ParamBuilder {
    public static BeanPropertyParam assembleBeanPropertyParam(Map<String, String> properties, BeanPropertyParam.BeanSymbol[] symbols, String[] values, String[] excludedValues) throws Exception {
        String id = properties.get("id");
        String name = properties.get("name");
        boolean horizontal = true;
        String horizontalStr = properties.get("orientation");
        horizontal = "horizontal".equalsIgnoreCase(horizontalStr);
        BeanPropertyParam param = new BeanPropertyParam(UtilsText.safeString((String)id), UtilsText.safeString((String)name), horizontal);
        param.symbols = symbols;
        param.pattern = properties.get("pattern");
        param.prefix = properties.get("prefix");
        param.postfix = properties.get("postfix");
        param.unit = properties.get("unit");
        if (param.prefix == null) {
            param.prefix = "";
        }
        if (param.postfix == null) {
            param.postfix = "";
        }
        param.optValues = values;
        param.excludedOptValues = excludedValues;
        return param;
    }

    public static RegFieldParam assembleRegFieldParam(Map<String, String> properties) {
        String iteratorType;
        String id = properties.get("id");
        String name = properties.get("name");
        boolean horizontal = true;
        String horizontalStr = properties.get("orientation");
        horizontal = "horizontal".equalsIgnoreCase(horizontalStr);
        RegFieldParam param = new RegFieldParam(UtilsText.safeString((String)id), UtilsText.safeString((String)name), horizontal);
        param.dynamic = false;
        String dynamicStr = properties.get("dynamic");
        if (dynamicStr != null) {
            param.dynamic = ParamBuilder.parseBool(dynamicStr);
        }
        param.standardIterator = "standard".equalsIgnoreCase(iteratorType = properties.get("iterator"));
        if (param.standardIterator) {
            param.minValue = ParamBuilder.parseInt(UtilsText.safeString((String)properties.get("min-value")));
            param.maxValue = ParamBuilder.parseInt(UtilsText.safeString((String)properties.get("max-value")));
        }
        param.doubleMode = false;
        String doubleMode = properties.get("mode");
        if ("2x".equalsIgnoreCase(doubleMode)) {
            param.doubleMode = true;
        }
        return param;
    }

    public static TestScriptParam assembleTestScriptParam(Map<String, String> properties, Scripts scripts) {
        String id = properties.get("id");
        String name = properties.get("name");
        boolean horizontal = true;
        String horizontalStr = properties.get("orientation");
        horizontal = "horizontal".equalsIgnoreCase(horizontalStr);
        return new TestScriptParam(UtilsText.safeString((String)id), UtilsText.safeString((String)name), horizontal, scripts);
    }

    public static TestScriptParam assembleTestTestsParam(Map<String, String> properties, Scripts scripts, @Nullable List<VScriptConfig> scriptConfigs) {
        String id = properties.get("id");
        String name = properties.get("name");
        boolean horizontal = true;
        String horizontalStr = properties.get("orientation");
        horizontal = "horizontal".equalsIgnoreCase(horizontalStr);
        return new TestScriptParam(UtilsText.safeString((String)id), UtilsText.safeString((String)name), horizontal, scripts, scriptConfigs);
    }

    public static boolean parseBool(String boolStr) {
        return Boolean.parseBoolean(boolStr);
    }

    public static int parseInt(String intStr) {
        int radix = 10;
        if (intStr.startsWith("0x")) {
            intStr = intStr.substring(2);
            radix = 16;
        }
        return Integer.valueOf(intStr, radix);
    }

    public static long parseLong(String longStr) {
        int radix = 10;
        if (longStr.startsWith("0x")) {
            longStr = longStr.substring(2);
            radix = 16;
        }
        return Long.valueOf(longStr, radix);
    }
}

