/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.reports;

import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.reports.IReportGenerator;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.utils.TestResultsLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.logging.Logger;

public class LogReportGenerator
implements IReportGenerator {
    private static final Logger LOGGER = LogManager.getLogger(LogReportGenerator.class);
    private IReportGenerator.ReportType type = IReportGenerator.ReportType.LOG;
    private VPresentationModel model;

    public LogReportGenerator(VPresentationModel model, IReportGenerator.ReportType type) {
        this.type = type;
        this.model = model;
    }

    @Override
    public boolean generateReport(VTable[] tables, IReportGenerator.ReportData data) {
        VParamVariation cell;
        VScenarioPresentation scenData = this.model.getSelectedScenario();
        if (scenData != null && (cell = scenData.getSelectedCell()) != null) {
            String testPHYLogFilePath;
            VRunResult runResult;
            String testLogFilePath;
            String dataFilePath = data.getConcreteFilePath();
            VRunResult[] results = cell.getResults();
            if (results != null && results.length > 0 && Files.exists(Paths.get(testLogFilePath = TestResultsLogger.getLogFilePath(runResult = results[0]), new String[0]), new LinkOption[0])) {
                File src = new File(testLogFilePath);
                File dest = new File(dataFilePath);
                try {
                    UtilsFile.copy((File)src, (File)dest, (boolean)true);
                }
                catch (IOException e) {
                    LOGGER.severe(e.getLocalizedMessage());
                    return false;
                }
            }
            if (Files.exists(Paths.get(testPHYLogFilePath = TestResultsLogger.getPhyTrainingLogFilePath(cell), new String[0]), new LinkOption[0])) {
                File src = new File(testPHYLogFilePath);
                String destFile = UtilsFile.getFileNameWithExtension((String)dataFilePath);
                String destFolder = dataFilePath.substring(0, dataFilePath.length() - destFile.length());
                destFile = "phy_training_" + UtilsFile.getFileNameWithExtension((String)dataFilePath);
                File dest = new File(destFolder, destFile);
                try {
                    UtilsFile.copy((File)src, (File)dest, (boolean)true);
                }
                catch (IOException e) {
                    LOGGER.severe(e.getLocalizedMessage());
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public IReportGenerator.ReportType getReportType() {
        return this.type;
    }
}

