/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.presenter.updaters;

import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.swt.ScrolledCompositeHelper;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.ui.ConnectionView;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.presenter.updaters.AUIRunnable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.ui.CellResultsMainView;
import com.nxp.swtools.mem.validation.ui.ExecutionView;
import com.nxp.swtools.mem.validation.ui.MainView;
import com.nxp.swtools.mem.validation.ui.VScenarioOptionsView;
import com.nxp.swtools.mem.validation.ui.VScenarioView;
import com.nxp.swtools.mem.validation.views.VStagesView;
import com.nxp.swtools.utils.events.IEventListener;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class RefreshUIRunnable
extends AUIRunnable {
    private static final Logger LOGGER = LogManager.getLogger(RefreshUIRunnable.class);
    protected VPresentationModel model;
    @Nullable
    private MainView view;
    @Nullable
    private VStagesView stagesView;
    @Nullable
    private VScenarioView scenarioView;
    @Nullable
    private VScenarioOptionsView scenarioOptionsView;
    @Nullable
    protected ExecutionView execView;
    @Nullable
    private ConnectionView connView;
    @Nullable
    private CellResultsMainView cellsView;
    private RefreshMode mode;
    private boolean updateChecked;
    IEventListener execViewRefreshListener = event -> {
        ExecutionView execViewLoc = this.execView;
        if (execViewLoc != null && !execViewLoc.isDisposed()) {
            ExecutionPresentationModel execModel;
            IConfigProvider provider = ValidationContext.getInstance().getConfigController();
            if (provider != null) {
                UIJobHelper.runNowOrInJob(() -> {
                    VStagePresentation selectedStage = this.model.getSelectedStage();
                    VScenarioOptionsView paramView = this.model.getView().getScenarioOptionsView();
                    if (selectedStage != null && paramView != null) {
                        VScenarioPresentation selectedScenario = selectedStage.getSelectedScenario();
                        if (selectedScenario != null) {
                            VScriptConfig[] scripts;
                            VScriptConfig[] vScriptConfigArray = scripts = selectedScenario.getVisibleScriptConfigs();
                            int n = scripts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                VScriptConfig script = vScriptConfigArray[n2];
                                this.model.validateScript(script);
                                ++n2;
                            }
                        }
                        paramView.setInput(selectedScenario, false);
                    }
                }, (String)Messages.ExecViewRefreshMsg, (Display)Display.getCurrent());
            }
            if ((execModel = this.model.getExecution()) != null) {
                UIJobHelper.runNowOrInJob(() -> {
                    execViewLoc.setInput(execModel);
                    execModel.getParent().updateExecutionPresentationModel(false);
                }, (String)Messages.ExecViewRefreshMsg, null);
            }
        }
    };
    private boolean execListenerApplied = false;

    private static void trace(String message) {
        LOGGER.warning(message);
    }

    public RefreshUIRunnable(VPresentationModel _model) {
        this(_model, RefreshMode.ALL, false);
    }

    public RefreshUIRunnable(VPresentationModel _model, RefreshMode _mode, boolean _updateChecked) {
        this.model = _model;
        if (!this.model.isViewDisposed()) {
            MainView viewLoc = this.view = this.model.getView();
            this.stagesView = viewLoc.getStagesView();
            this.scenarioView = viewLoc.getScenarioView();
            this.scenarioOptionsView = viewLoc.getScenarioOptionsView();
            this.execView = viewLoc.getExecutionView();
            this.connView = viewLoc.getConnView();
            this.cellsView = viewLoc.getCellResultsMainView();
            IConfigProvider provider = ValidationContext.getInstance().getConfigController();
            if (provider != null && !this.execListenerApplied) {
                this.execListenerApplied = true;
                provider.getControllerWrapper().getController().addListener(provider.getControllerWrapper().getController().getSettingsChangedEvent(), this.execViewRefreshListener);
            }
        } else {
            RefreshUIRunnable.trace(UtilsText.safeString((String)Messages.RefreshUIRunnable_0));
        }
        this.mode = _mode;
        this.updateChecked = _updateChecked;
    }

    @Override
    public void run() {
        if (this.model.isViewDisposed() || this.model.getModel() == null) {
            LOGGER.warning(Messages.RefreshUIRunnable_dataErrorTxt);
            return;
        }
        ValidationPresentationModel stages = this.model.getValidationModel();
        VStagePresentation stage = this.model.getSelectedStage();
        if (stage == null) {
            return;
        }
        VScenarioPresentation scenario = this.model.getSelectedScenario();
        ExecutionPresentationModel execData = this.model.getExecution();
        VScenarioView scenarioViewLoc = this.scenarioView;
        if (scenarioViewLoc != null && stages != null) {
            scenarioViewLoc.setRestorePropertiesEnabled(!this.model.isValidationInProgress());
            VParamVariation paramVariationLoc = this.model.getSelectedCell();
            switch (this.mode) {
                case ALL: {
                    MainView viewLoc = this.view;
                    if (viewLoc == null) break;
                    viewLoc.setInput(this.model);
                    ScrolledCompositeHelper.updateScrollMinSize((Composite)viewLoc.getConnView());
                    viewLoc.layout(true, true);
                    break;
                }
                case SELECT_STAGE: {
                    if (this.stagesView == null) break;
                    this.stagesView.updateCheckedState(stages);
                    if (this.scenarioView != null) {
                        this.scenarioView.updateTabs(stage);
                    }
                    scenarioViewLoc.setInput(stage, false);
                    VScenarioOptionsView scenarioOptionsViewLoc = this.scenarioOptionsView;
                    if (scenario == null || scenarioOptionsViewLoc == null) break;
                    scenarioOptionsViewLoc.setInput(scenario);
                    scenarioOptionsViewLoc.enable(!stages.isAnyJobRunning());
                    if (this.cellsView == null) break;
                    if (paramVariationLoc != null) {
                        this.cellsView.setInput(paramVariationLoc, scenario.showAllLogs(), true);
                    }
                    if (this.execView != null && execData != null) {
                        this.execView.setInput(execData);
                    }
                    if (this.connView == null || execData == null) break;
                    this.connView.setInput(execData);
                    break;
                }
                case RESUMED: {
                    scenarioViewLoc.setRestorePropertiesEnabled(false);
                    scenarioViewLoc.setReportToolsEnabled(false);
                    scenarioViewLoc.setSelectionToolsEnabled(false);
                    if (this.execView != null && execData != null) {
                        this.execView.setInput(execData);
                    }
                    if (this.connView == null || execData == null) break;
                    this.connView.setInput(execData);
                    break;
                }
                case SELECT_SCENARIO: {
                    CTabItem tabItemLoc;
                    if (this.updateChecked && this.stagesView != null && execData != null) {
                        this.stagesView.updateCheckedState(stages);
                        if (this.execView != null) {
                            this.execView.setInput(execData);
                            if (this.connView != null) {
                                this.connView.setInput(execData);
                            }
                        }
                    }
                    scenarioViewLoc.setInput(stage, false);
                    VScenarioOptionsView scenarioOptionsViewLoc = this.scenarioOptionsView;
                    if (scenario != null && scenarioOptionsViewLoc != null) {
                        scenarioOptionsViewLoc.setInput(scenario);
                        scenarioOptionsViewLoc.enable(!stages.isAnyJobRunning());
                    }
                    if (this.cellsView != null && scenario != null && paramVariationLoc != null) {
                        this.cellsView.setInput(paramVariationLoc, null, true);
                    }
                    if ((tabItemLoc = scenarioViewLoc.getResultsTab()) == null) break;
                    tabItemLoc.setData("qcs.validation.ddr.model", (Object)scenario);
                    break;
                }
                case SELECT_CELL: {
                    RefreshUIRunnable.trace(UtilsText.safeString((String)Messages.RefreshUIRunnable_2));
                    scenarioViewLoc.redrawScenarioFigure();
                    if (this.cellsView == null || paramVariationLoc == null) break;
                    this.cellsView.setInput(paramVariationLoc, null, true);
                    break;
                }
                case SELECT_TEST_RUN: {
                    break;
                }
                case SELECT_SCRIPT_CONFIG: {
                    break;
                }
                case SV_BUTTON_STATE: {
                    if (this.execView == null || execData == null) break;
                    this.execView.setInput(execData);
                }
            }
        }
    }

    public static enum RefreshMode {
        ALL,
        SELECT_STAGE,
        SELECT_SCENARIO,
        SELECT_CELL,
        SELECT_TEST_RUN,
        SELECT_SCRIPT_CONFIG,
        RESUMED,
        SV_BUTTON_STATE;

    }
}

