/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.scenarios;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.model.scenarios.IScenarioElement;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import java.util.ArrayList;

public class VScenarioGroup
implements IScenarioElement {
    @Nullable
    protected IScenarioElement parent;
    protected IScenarioElement[] children;
    protected boolean selected;
    protected String id;
    protected String name;
    protected String description;

    public VScenarioGroup(String _id, String _name, @Nullable IScenarioElement _parent, IScenarioElement[] _children) {
        this.id = _id;
        this.name = _name;
        this.parent = _parent;
        this.children = (IScenarioElement[])_children.clone();
        this.description = "";
    }

    public VScenarioGroup(VScenarioGroup proto, @Nullable IScenarioElement _parent) {
        this.selected = proto.selected;
        this.id = proto.id;
        this.name = proto.name;
        this.description = proto.description;
        this.parent = _parent;
        this.children = new IScenarioElement[proto.children.length];
        int i = 0;
        while (i < this.children.length) {
            this.children[i] = proto.children[i].clone(this);
            ++i;
        }
    }

    @Override
    public IScenarioElement clone(IScenarioElement parent) {
        return new VScenarioGroup(this, parent);
    }

    @Override
    public IScenarioElement[] getChildren() {
        return (IScenarioElement[])this.children.clone();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public @Nullable IScenarioElement getParent() {
        return this.parent;
    }

    @Override
    public String getQualifiedName() {
        if (this.parent != null) {
            return String.valueOf(this.parent.getQualifiedName()) + ", " + this.name;
        }
        return this.name;
    }

    public IScenarioElement[] getVisibleChildren() {
        ArrayList<IScenarioElement> visibleChildren = new ArrayList<IScenarioElement>();
        IScenarioElement[] iScenarioElementArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            IScenarioElement child = iScenarioElementArray[n2];
            if (child instanceof VScenario && ((VScenario)child).isVisible()) {
                visibleChildren.add(child);
            }
            ++n2;
        }
        return visibleChildren.toArray(new IScenarioElement[visibleChildren.size()]);
    }

    private boolean hasVisibleScenarios(IScenarioElement root, IScenarioElement parent, IScenarioElement[] elems) {
        if (elems == null) {
            if (parent.equals(root)) {
                return false;
            }
        } else {
            IScenarioElement[] iScenarioElementArray = elems;
            int n = elems.length;
            int n2 = 0;
            while (n2 < n) {
                IScenarioElement elem = iScenarioElementArray[n2];
                if (elem instanceof VScenarioGroup) {
                    return this.hasVisibleScenarios(root, elem, elem.getChildren());
                }
                if (elem instanceof VScenario && ((VScenario)elem).isVisible()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean isReadMargins() {
        return false;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean isVisible() {
        return this.hasVisibleScenarios(this, this, this.children);
    }

    public void setChildren(IScenarioElement[] _children) {
        this.children = (IScenarioElement[])_children.clone();
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

