/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.listeners.IValidationSessionEventListener;
import com.nxp.swtools.mem.validation.model.ARunResultsUpdaterListener;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.VSessionModel;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.utils.VLoggingUtils;
import java.util.Map;
import java.util.logging.Logger;

public class RunResultsUpdaterListener
extends ARunResultsUpdaterListener {
    private static final String EXTRA_DATA_START_TAG = "<extra_data>";
    private static final String EXTRA_DATA_END_TAG = "</extra_data>";
    protected static final Logger LOGGER = LogManager.getLogger(RunResultsUpdaterListener.class);
    private VPresentationModel data;
    @Nullable
    private String rawOutput;
    private VLoggingUtils.ScriptResultType resultType = VLoggingUtils.ScriptResultType.PASSED;
    private String resultText = "";

    private static String extractExtraData(String rawOutput) {
        if (rawOutput.contains(EXTRA_DATA_START_TAG)) {
            int exstra_start = rawOutput.indexOf(EXTRA_DATA_START_TAG) + EXTRA_DATA_START_TAG.length();
            int extra_end = rawOutput.indexOf(EXTRA_DATA_END_TAG);
            return rawOutput.substring(exstra_start, extra_end);
        }
        return "";
    }

    @Override
    public void setResultText(String resultText) {
        this.resultText = resultText;
    }

    public RunResultsUpdaterListener(VPresentationModel data) {
        this.data = data;
    }

    @Override
    public @Nullable VSessionModel.VEvent getNextEvent() {
        return null;
    }

    @Override
    public double getProgress() {
        return 0.0;
    }

    @Override
    public @Nullable VScenario getScenario() {
        return null;
    }

    @Override
    public @Nullable VStage getStage() {
        return null;
    }

    @Override
    public @Nullable VTable getTable() {
        return null;
    }

    @Override
    public VTable[] getTables() {
        return new VTable[0];
    }

    @Override
    public IValidationSessionEventListener.VEventListenerResult onEvent(@Nullable VSessionModel session, @Nullable VSessionModel.VEvent event, @Nullable VSessionModel.VEventPhase phase) {
        if (session != null && event != null && phase == VSessionModel.VEventPhase.SCRIPT_END) {
            VRunResult[] runResultList;
            String failReason = this.isPassed() ? "" : VLoggingUtils.extractErrorMessage(UtilsText.safeString((String)this.rawOutput));
            VStage stage = session.getStage();
            VScenario scenario = event.getScenario();
            Map<Integer, VRunResult[]> runResults = event.getResults();
            if (runResults != null && (runResultList = runResults.get(event.getIteration())) != null) {
                VRunResult runResult;
                VRunResult[] vRunResultArray = runResultList;
                int n = runResultList.length;
                int n2 = 0;
                while (n2 < n) {
                    runResult = vRunResultArray[n2];
                    runResult.setType(this.isPassed() ? VRunResult.ResultType.PASSED : VRunResult.ResultType.FAILED);
                    runResult.setErrorMessage(failReason);
                    runResult.setFailureType(this.resultType);
                    runResult.setResultText(this.resultText);
                    ++n2;
                }
                if (!this.isPassed()) {
                    int iteration = event.getIteration() + 1;
                    while (iteration < event.getNumRuns()) {
                        runResultList = runResults.get(iteration);
                        if (runResultList != null) {
                            VRunResult[] vRunResultArray2 = runResultList;
                            int n3 = runResultList.length;
                            n = 0;
                            while (n < n3) {
                                VRunResult runResult2 = vRunResultArray2[n];
                                if (runResult2.getType().equals((Object)VRunResult.ResultType.QUEUED)) {
                                    runResult2.setType(VRunResult.ResultType.SKIPPED);
                                }
                                ++n;
                            }
                        }
                        ++iteration;
                    }
                }
                runResultList = runResults.get(event.getIteration());
                if (stage != null && runResultList != null) {
                    vRunResultArray = runResultList;
                    n = runResultList.length;
                    int n4 = 0;
                    while (n4 < n) {
                        runResult = vRunResultArray[n4];
                        runResult.setExtraData(RunResultsUpdaterListener.extractExtraData(UtilsText.safeString((String)this.rawOutput)));
                        this.data.onValidationRunResults(stage, scenario, runResult, true);
                        ++n4;
                    }
                    IConfigProvider configController = ValidationContext.getInstance().getConfigController();
                    if (configController != null) {
                        configController.customPostValidationEndEvent(this.rawOutput);
                    }
                }
            }
        }
        return new IValidationSessionEventListener.VEventListenerResult(event, phase, true, null);
    }

    private boolean isPassed() {
        return this.resultType.equals((Object)VLoggingUtils.ScriptResultType.PASSED);
    }

    @Override
    public void setRawOutput(String rawOutput) {
        this.rawOutput = rawOutput;
    }

    @Override
    public void setFailureType(VLoggingUtils.ScriptResultType failureType) {
        this.resultType = failureType;
    }
}

