/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model;

import com.nxp.swtools.common.utils.Nullable;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ParserUtility {
    public static final String ATTRIB_ID = "id";
    public static final String ATTRIB_NAME = "name";
    public static final String ATTRIB_VALUE = "value";
    public static final String ATTRIB_MIN = "min";
    public static final String ATTRIB_MAX = "max";
    public static final String ATTRIB_CPU_FAMILY = "family";
    public static final String ATTRIB_CPU_SUBFAMILY = "subfamily";
    public static final String ATTRIB_CPU_VARIANT = "variant";
    public static final String ATTRIB_ITERATIONS = "iterations";
    public static final String ATTRIB_TYPE = "type";
    public static final String ATTRIB_VERSION = "version";
    public static final String ATTRIB_SCENARIO = "scenario";
    public static final String ATTRIB_FILE = "file";
    public static final String ATTRIB_ENV_ID = "env-id";
    public static final String ATTRIB_SIM_ENV = "sim-env";
    public static final String ATTRIB_EXCLUSIVE = "exclusive";
    public static final String ATTRIB_ALLOW_EMPTY = "allowEmpty";

    public static @Nullable Node extractFirstChildNode(Node parentNode, String childNodeName) throws IllegalArgumentException, DOMException {
        return ParserUtility.extractFirstChildNode(parentNode, childNodeName, true);
    }

    public static @Nullable Node extractFirstChildNode(Node parentNode, String childNodeName, boolean mandatory) throws IllegalArgumentException, DOMException {
        NodeList children = parentNode.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node childNode = children.item(i);
            if (childNode != null && childNodeName.equalsIgnoreCase(childNode.getNodeName())) {
                return childNode;
            }
            ++i;
        }
        if (mandatory) {
            throw new IllegalArgumentException("Node has no child node with the supplied name!!!");
        }
        return null;
    }

    public static Node extractRootXmlNode(String xmlConfigFilePath) throws IllegalArgumentException, IOException, SAXException, ParserConfigurationException {
        DocumentBuilder db = DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder();
        Element elem = db.parse(xmlConfigFilePath).getDocumentElement();
        if (elem != null) {
            return elem;
        }
        throw new IllegalArgumentException("Root element not found in the XML file: " + xmlConfigFilePath);
    }

    public static @Nullable String getAttribValue(Node node, String attribName) throws IllegalArgumentException, DOMException {
        return ParserUtility.getAttribValue(node, attribName, true);
    }

    public static @Nullable String getAttribValue(Node node, String attribName, boolean mandatoryAttrib) throws IllegalArgumentException, DOMException {
        NamedNodeMap attribMap = node.getAttributes();
        if (attribMap == null) {
            if (mandatoryAttrib) {
                throw new IllegalArgumentException("Node has no attributes!!!");
            }
            return null;
        }
        Node attribNode = attribMap.getNamedItem(attribName);
        if (attribNode == null) {
            if (mandatoryAttrib) {
                throw new IllegalArgumentException("Node has no attribute with given name!!!");
            }
            return null;
        }
        String attribValue = attribNode.getNodeValue();
        if (attribValue == null && mandatoryAttrib) {
            throw new IllegalArgumentException("Node attribute has null value (weird, right?) !!!");
        }
        return attribValue;
    }

    public static @Nullable Integer getAttribValueAsInt(Node node, String attribName) throws IllegalArgumentException, DOMException, NumberFormatException {
        return ParserUtility.getAttribValueAsInt(node, attribName, true);
    }

    public static @Nullable Integer getAttribValueAsInt(Node node, String attribName, boolean mandatory) throws IllegalArgumentException, DOMException, NumberFormatException {
        String attribStrValue = ParserUtility.getAttribValue(node, attribName, mandatory);
        return attribStrValue == null ? null : Integer.decode(attribStrValue);
    }

    public static String getNodeTextContent(Node node) throws IllegalArgumentException, DOMException {
        Node textNode = node.getFirstChild();
        if (textNode == null) {
            throw new IllegalArgumentException("Node has no contents!!!");
        }
        String text = textNode.getNodeValue();
        if (text == null) {
            throw new IllegalArgumentException("Node contents has null value (weird, right?) !!!");
        }
        return text;
    }
}

