/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.listeners;

import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParamValue;
import com.nxp.swtools.mem.validation.model.scripts.VScriptTimeParamValue;
import com.nxp.swtools.mem.validation.ui.TimeParamView;
import com.nxp.swtools.mem.validation.ui.VScenarioOptionsView;
import java.util.Objects;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Spinner;

public class TimeParamListener
implements ModifyListener,
SelectionListener {
    VPresentationModel data;

    public TimeParamListener(VPresentationModel data) {
        this.data = data;
    }

    public void modifyText(ModifyEvent event) {
        ControlDecoration timerDecorator;
        Spinner timeSpinner = (Spinner)event.widget;
        int value = TimeParamListener.updateModel(timeSpinner);
        this.data.validateSelectedScriptConfig();
        VScenarioOptionsView vScenarioOptionsView = this.data.getView().getScenarioOptionsView();
        if (vScenarioOptionsView != null && (timerDecorator = (ControlDecoration)timeSpinner.getData("qcs.validation.ddr.widget.decorator")) != null) {
            if (vScenarioOptionsView.getTimeout() / 1000L <= (long)(value * 60)) {
                timerDecorator.show();
            } else {
                timerDecorator.hide();
            }
        }
    }

    private static int updateModel(Spinner timeSpinner) {
        VScriptTimeParamValue data = (VScriptTimeParamValue)timeSpinner.getData("qcs.validation.ddr.model");
        if (data == null) {
            return -1;
        }
        if (!timeSpinner.isEnabled()) {
            TimeParamView timeParamView;
            Composite pannel = timeSpinner.getParent();
            if (pannel != null && (timeParamView = (TimeParamView)pannel.getParent()) != null && !timeParamView.isCheckBoxSelected()) {
                data.setValue(new Integer(-1));
            }
            return -1;
        }
        int value = Integer.valueOf(data.getTimeValue().toString());
        int inputValue = timeSpinner.getSelection();
        switch ((String)Objects.requireNonNull(timeSpinner.getData("ddrv.model.time"))) {
            case "ddrv.model.time.hours": {
                value = inputValue * 60 + value % 60;
                break;
            }
            case "ddrv.model.time.minutes": {
                value = value / 60 * 60 + inputValue;
            }
        }
        data.setValue(new Integer(value));
        return value;
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent event) {
        Button enableCheckbox = (Button)event.widget;
        VScriptParamValue data = (VScriptParamValue)enableCheckbox.getData("qcs.validation.ddr.model");
        TimeParamView timeView = (TimeParamView)enableCheckbox.getParent();
        if (!enableCheckbox.getSelection()) {
            Objects.requireNonNull(data).setValue(new Integer(-1));
        } else {
            Objects.requireNonNull(data).setValue(new Integer(Objects.requireNonNull(timeView).getInputedValue()));
        }
        Objects.requireNonNull(timeView).setEnabled(enableCheckbox.getSelection());
    }
}

