/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.listeners;

import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.ui.VScenarioOptionsView;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

class RemoveScriptAction
extends Action {
    private VPresentationModel data;

    public RemoveScriptAction(VPresentationModel _data) {
        super(Messages.RemoveUserTest);
        this.data = _data;
    }

    public void run() {
        VScenarioOptionsView scenarioOptView;
        ValidationPresentationModel vModel = this.data.getValidationModel();
        if (vModel != null && (scenarioOptView = this.data.getView().getScenarioOptionsView()) != null) {
            TableViewer viewer = scenarioOptView.getScriptsTableViewer();
            TableItem[] selectedItems = viewer.getTable().getItems();
            if (selectedItems.length == 0) {
                return;
            }
            ArrayList<VScript> scList = new ArrayList<VScript>();
            TableItem[] tableItemArray = selectedItems;
            int n = selectedItems.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                VScriptConfig sc = (VScriptConfig)item.getData();
                if (sc != null && sc.isSelected() && sc.getScript().isUserScript()) {
                    scList.add(sc.getScript());
                    String scriptDir = Activator.getDefault().getConfigManager().getLogsFolder();
                    this.data.closeEditor(new File(String.valueOf(scriptDir) + File.separator + sc.getScript().getId() + ".json"));
                }
                ++n2;
            }
            boolean success = vModel.deleteScripts(scList);
            if (!success) {
                int style = 65576;
                IWorkbenchWindow activeWnd = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWnd != null) {
                    Shell shell = activeWnd.getShell();
                    MessageBox box = new MessageBox(shell, style);
                    box.setText(Messages.ScriptConfigSelectionListener_WarningText);
                    box.setMessage(Messages.UserTestNotDeleted);
                    box.open();
                }
            }
            vModel.setUserScriptsChanged(true);
            VScenarioPresentation scen = this.data.getSelectedScenario();
            if (scen != null) {
                scenarioOptView.setInput(scen);
            }
        }
    }
}

