/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.ui;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.Connection;
import com.nxp.swtools.mem.validation.connections.ConnectionFactory;
import com.nxp.swtools.mem.validation.connections.ConnectionSetting;
import com.nxp.swtools.mem.validation.connections.JTAGConnection;
import com.nxp.swtools.mem.validation.connections.TargetConnectionsSetting;
import com.nxp.swtools.mem.validation.connections.ui.ConnectionParamView;
import com.nxp.swtools.mem.validation.connections.ui.ConnectionParamViewFactory;
import com.nxp.swtools.mem.validation.connections.ui.JtagConnectionParamView;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.provider.SWToolsPlatform;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ConnectionView
extends Composite {
    private static final Logger LOGGER = LogManager.getLogger(ConnectionView.class);
    private CCombo connectionCombo;
    private Composite connConfigComposite;
    protected StackLayout stackLayout;
    protected HashMap<String, ConnectionParamView> connParamConfig;
    @Nullable
    private ExecutionPresentationModel execModel;

    public ConnectionView(Composite parentView) {
        super(parentView, 0);
        this.setLayout((Layout)new GridLayout(2, true));
        this.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        Composite connectionTypes = new Composite((Composite)this, 0);
        connectionTypes.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        connectionTypes.setLayout((Layout)new GridLayout());
        Group connectionGroup = new Group(connectionTypes, 0);
        connectionGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        connectionGroup.setLayout((Layout)new GridLayout(1, true));
        connectionGroup.setText(Messages.ExecutionView_ConnectionsGroupLabel);
        Label connLabel = new Label((Composite)connectionGroup, 0);
        connLabel.setText(Messages.SelectConnectionLabel);
        this.connectionCombo = new CCombo((Composite)connectionGroup, 2048);
        this.connectionCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.connectionCombo.setEditable(false);
        this.connConfigComposite = new Composite((Composite)connectionGroup, 0);
        this.connConfigComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.stackLayout = new StackLayout();
        this.connConfigComposite.setLayout((Layout)this.stackLayout);
        this.connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                int selIdx;
                CCombo connComboLoc = ConnectionView.this.getConnectionCombo();
                String connectionName = connComboLoc.getItem(selIdx = connComboLoc.getSelectionIndex());
                if (connectionName != null) {
                    String connId = ConnectionView.this.getConnectionId(connectionName);
                    if (!connId.equals("")) {
                        ConnectionView.this.stackLayout.topControl = (Control)ConnectionView.this.connParamConfig.get(connId);
                    }
                    ConnectionView.this.setConnectionInModel();
                    ConnectionView.this.getConnConfigComposite().layout();
                }
            }
        });
        this.connParamConfig = new HashMap();
    }

    public Composite getConnConfigComposite() {
        return this.connConfigComposite;
    }

    public void setInput(ExecutionPresentationModel data) {
        boolean connectionsChanged = this.detectTargetConnectionsChange(data);
        this.execModel = data;
        if (connectionsChanged) {
            this.updateConnectionComboEntries(this.getTargetConnections());
        }
        this.updateConnectionControls(data.getStartMode());
        Connection connection = ValidationContext.getInstance().getCurrentConnection();
        if (connection != null) {
            data.setConnection(connection);
        }
        if (connection != null) {
            this.setSelectedConnection(connection);
        } else {
            this.setConnectionInModel();
        }
    }

    public @Nullable TargetConnectionsSetting getTargetConnections() {
        VModel vModel;
        if (this.execModel != null && (vModel = this.execModel.getParent().getModel()) != null) {
            return vModel.getConnections();
        }
        return null;
    }

    public void updateConnection(ConnectionSetting conn, Object connection) {
        this.connectionCombo.setData(conn.getLabel(), connection);
        this.connectionCombo.notifyListeners(13, new Event());
        this.layout();
    }

    public void updateConnectionComboEntries(@Nullable TargetConnectionsSetting targetConnections) {
        this.connectionCombo.removeAll();
        this.connParamConfig.clear();
        if (targetConnections != null) {
            int idx = 0;
            for (ConnectionSetting conn : targetConnections.getSupportedConnections()) {
                if (!conn.isAvailableInStandalone() && !SWToolsPlatform.isRunningInEclipseIde()) continue;
                this.connectionCombo.add(conn.getLabel());
                this.connectionCombo.select(idx++);
                String connId = conn.getId();
                Connection.SUPPORTED_CONNECTIONS connType = Connection.getTypeFromID(connId);
                if (conn.isSerialOverGdb()) {
                    connType = Connection.SUPPORTED_CONNECTIONS.SERIAL_OVER_GDB;
                }
                if (connType != null) {
                    this.connectionCombo.setData(conn.getLabel(), ConnectionFactory.create(connType));
                    ConnectionParamView connParamView = ConnectionParamViewFactory.create(connType, this, this.connConfigComposite);
                    if (connParamView == null) continue;
                    this.connParamConfig.put(connId, connParamView);
                    connParamView.showAdvanced(conn.isAdvancedMode());
                    connParamView.showCustomFreq(conn.hasCustomClockFrequency());
                    continue;
                }
                LOGGER.severe("Error identifying connection type - Unknown connection id: " + connId);
            }
            this.connectionCombo.select(0);
            this.connectionCombo.notifyListeners(13, new Event());
        }
    }

    private void updateConnectionControls(ExecutionPresentationModel.StartValidationMode mode) {
        switch (mode) {
            case VALIDATE: {
                this.setEnabled(true);
                break;
            }
            default: {
                this.setEnabled(false);
            }
        }
    }

    protected String getConnectionId(String connectionName) {
        TargetConnectionsSetting targetConnections;
        VModel vModel;
        if (this.execModel != null && (vModel = this.execModel.getParent().getModel()) != null && (targetConnections = vModel.getConnections()) != null) {
            for (ConnectionSetting conn : targetConnections.getSupportedConnections()) {
                if (!connectionName.equals(conn.getLabel())) continue;
                return conn.getId();
            }
        }
        return "";
    }

    protected void setConnectionInModel() {
        String currentConnection = this.connectionCombo.getText();
        if (currentConnection != null) {
            Object data = this.connectionCombo.getData(currentConnection);
            if (!(data instanceof Connection)) {
                LOGGER.severe("Connection UI creation error - each connectionCombo entry should be linked to a Connection object!");
                return;
            }
            if (this.execModel != null) {
                this.execModel.setConnection((Connection)data);
                ValidationContext.getInstance().setCurrentConnection((Connection)data);
            }
        }
    }

    public CCombo getConnectionCombo() {
        return this.connectionCombo;
    }

    public @Nullable ExecutionPresentationModel getExecPresModel() {
        return this.execModel;
    }

    private void setSelectedConnection(Connection connection) {
        Control conn;
        int idx = 0;
        while (idx < this.connectionCombo.getItemCount()) {
            String connectionName = this.connectionCombo.getItem(idx);
            if (connectionName == null || connectionName.isEmpty()) {
                LOGGER.severe("Connection UI creation error - each connection should have a name!");
                return;
            }
            Object data = this.connectionCombo.getData(connectionName);
            if (data instanceof Connection) {
                Connection connectionData = (Connection)data;
                if (connectionData.getType() == connection.getType()) {
                    this.connectionCombo.setData(connectionName, (Object)connection);
                    break;
                }
            } else {
                LOGGER.severe("Connection UI creation error - each connectionCombo entry should be linked to a Connection object!");
                return;
            }
            ++idx;
        }
        Control[] connectionChildren = this.connConfigComposite.getChildren();
        if (connectionChildren.length > 0 && (conn = connectionChildren[0]) instanceof JtagConnectionParamView && connection instanceof JTAGConnection) {
            ((JtagConnectionParamView)conn).setInput((JTAGConnection)connection);
        }
    }

    public void setEnabled(boolean enabled) {
        String connectionId;
        ConnectionParamView connParamView;
        this.connectionCombo.setEnabled(enabled);
        String currentConnection = this.connectionCombo.getText();
        if (currentConnection != null && (connParamView = this.connParamConfig.get(connectionId = this.getConnectionId(currentConnection))) != null) {
            connParamView.setEnabled(enabled);
        }
    }

    private boolean detectTargetConnectionsChange(ExecutionPresentationModel data) {
        if (this.execModel == null) {
            return true;
        }
        assert (this.execModel != null);
        VModel currentVModel = this.execModel.getParent().getModel();
        VModel newVModel = data.getParent().getModel();
        if (currentVModel != null && newVModel != null) {
            TargetConnectionsSetting newTargetConn;
            TargetConnectionsSetting currentTargetConn = currentVModel.getConnections();
            return !Objects.equals(currentTargetConn, newTargetConn = newVModel.getConnections());
        }
        return true;
    }

    public void dispose() {
        super.dispose();
        this.connectionCombo.dispose();
        this.connConfigComposite.dispose();
        for (Map.Entry<String, ConnectionParamView> entry : this.connParamConfig.entrySet()) {
            entry.getValue().dispose();
        }
    }
}

