/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.tasystem;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.tasystem.ExecutableFile;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystem;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemDescriptor;
import com.nxp.swtools.mem.validation.connections.tasystem.TargetAccessType;
import com.nxp.swtools.mem.validation.jobs.ResourceNotFoundException;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.VariablesPlugin;
import org.osgi.framework.Bundle;

public class TargetAccessDiscovery {
    private static final String EXT_POINT_TARGET_ACCESS_PROVIDER = "com.nxp.swtools.mem.validation.targetAccess";
    private static final String TAG_PLUGIN = "plugin";
    public static final String TAG_PATH = "path";
    private static final Logger LOGGER = LogManager.getLogger(TargetAccessDiscovery.class);
    @Nullable
    private static String lastErrMsg = null;
    protected static final String NO_ERROR = UtilsText.safeString((String)Messages.TargetAccessDiscovery_0);
    private static final String ERR_FILE_NOT_EXISTS = UtilsText.safeString((String)Messages.TargetAccessDiscovery_1);
    private static final String ERR_FILE_INVALID_PATH = UtilsText.safeString((String)Messages.TargetAccessDiscovery_2);
    private static final String ERR_FILE_NO_READ_ACCESS = UtilsText.safeString((String)Messages.TargetAccessDiscovery_3);
    private static final String ERR_FILE_NO_EXEC_ACCESS = UtilsText.safeString((String)Messages.TargetAccessDiscovery_4);
    public static final String REUSE_COMMON_SOFTWARE_PROPERTY = "REUSE_COMMON_SOFTWARE";
    private static final String USE_CACHED_TARGET_ACCESS_PROVIDER_PROPERTY = "qcvs.usecachedtargetaccessprovider";
    private static final String PATH_TO_64B_GDB_SERVER_DIRECTORY = "${S32DS_GDB_ARM64_PY}";
    private static final String PATH_TO_32B_GDB_SERVER_DIRECTORY = "${S32DS_GDB_ARM32_PY}";

    public static TASystemDescriptor[] getDefaultDescriptors(TargetAccessType targetAccessType) {
        return new TASystemDescriptor[]{TargetAccessDiscovery.getDefaultDescriptor(targetAccessType)};
    }

    public static TASystemDescriptor getDefaultDescriptor(TargetAccessType targetAccessType) {
        TASystemDescriptor.TAProcessArgument[] args = new TASystemDescriptor.TAProcessArgument[]{};
        TASystemDescriptor.TAProcessDescriptor[] processes = new TASystemDescriptor.TAProcessDescriptor[]{new TASystemDescriptor.TAProcessDescriptor(targetAccessType, TASystemDescriptor.TAProcessMode.TRANSIENT, args, false)};
        return new TASystemDescriptor(targetAccessType.name(), targetAccessType, processes);
    }

    public static @Nullable String getErrorMessage() {
        return lastErrMsg;
    }

    /*
     * Unable to fully structure code
     */
    public static @Nullable ExecutableFile getGdbExecPaths() {
        block23: {
            block22: {
                osSuffix = "";
                osExt = "";
                gdbEnvVar = "${S32DS_GDB_ARM64_PY}";
                presentationModel = ValidationContext.getInstance().getData();
                if (presentationModel != null && (vModel = presentationModel.getModel()) != null && Boolean.parseBoolean(vModel.getCustomOption("is32Bit"))) {
                    gdbEnvVar = "${S32DS_GDB_ARM32_PY}";
                }
                if (OSDetect.isWindows()) {
                    osSuffix = "win32";
                    osExt = ".exe";
                } else if (OSDetect.isMac()) {
                    osSuffix = "macosx";
                } else if (OSDetect.isUnix()) {
                    osSuffix = "linux";
                }
                targetConfigs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.nxp.swtools.mem.validation.targetAccess");
                if (targetConfigs.length == 1) break block22;
                TargetAccessDiscovery.LOGGER.severe("Error retrieving gdb server info!");
                return null;
            }
            targetConfig = targetConfigs[0];
            pluginName = targetConfig.getAttribute("plugin");
            pathName = targetConfig.getAttribute("path");
            if (pluginName != null && !pluginName.isEmpty() && pathName != null && !pathName.isEmpty()) break block23;
            TargetAccessDiscovery.LOGGER.severe("Error retrieving gdb server info!");
            return null;
        }
        gdbServerPath = gdbEnvVar;
        try {
            gdbServerPath = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(gdbServerPath, true);
        }
        catch (CoreException v0) {
            systemDirectory = Platform.getInstallLocation().getURL().getPath();
            file = new File(String.valueOf(systemDirectory) + File.separator + gdbServerPath + osExt);
            if (!file.exists()) {
                TargetAccessDiscovery.LOGGER.severe("Error retrieving gdb server path from TargetAccessDiscovery class");
            }
            executableFile = new ExecutableFile(TargetAccessType.GDB_PY.name());
            path = new Path(String.valueOf(systemDirectory) + File.separator + gdbServerPath + osExt);
            executableFile.setAbsPath(path.toPortableString());
            return executableFile;
        }
        try {
            executableFile = new ExecutableFile(TargetAccessType.GDB_PY.name());
            path = null;
            if (!new File(gdbServerPath).isAbsolute()) {
                productDir = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution("${eclipse_home}", true);
                path = new Path(productDir, String.valueOf(gdbServerPath) + osExt);
            } else {
                path = new Path(String.valueOf(gdbServerPath) + osExt);
            }
            if (new File(UtilsText.safeString((String)path.toPortableString())).exists()) {
                executableFile.setAbsPath(UtilsText.safeString((String)path.toPortableString()));
                return executableFile;
            }
            ** GOTO lbl60
        }
        catch (Exception e1) {
            try {
                TargetAccessDiscovery.LOGGER.severe("Error retrieving gdb server path from TargetAccessDiscovery class: " + e1.getMessage());
lbl60:
                // 2 sources

                pluginId = String.valueOf(pluginName) + "." + osSuffix;
                bundle = Platform.getBundle((String)pluginId);
                if (bundle != null) {
                    path = new Path(String.valueOf(pathName) + osExt);
                    url = FileLocator.find((Bundle)bundle, (IPath)path, null);
                    if (url != null) {
                        url = FileLocator.toFileURL((URL)url);
                        executableFile = new ExecutableFile(TargetAccessType.GDB_PY.name());
                        executableFile.setAbsPath(UtilsText.safeString((String)url.getPath()));
                        return executableFile;
                    }
                } else {
                    TargetAccessDiscovery.LOGGER.severe((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$0(java.lang.String ), ()Ljava/lang/String;)((String)pluginId));
                }
            }
            catch (Exception e) {
                TargetAccessDiscovery.LOGGER.warning(e.getMessage());
            }
        }
        return null;
    }

    public static @Nullable ExecutableFile getUsbExecPaths() {
        ExecutableFile execFile = null;
        if (OSDetect.isWindows()) {
            execFile = new ExecutableFile(TargetAccessType.SERIAL.name());
            execFile.setRelPath("cmd.exe");
        } else {
            execFile = new ExecutableFile(TargetAccessType.SERIAL.name());
            execFile.setRelPath("bash");
        }
        return execFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TASystem getTASystem(TASystemDescriptor desc, @Nullable ExecutableFile file) throws ResourceNotFoundException {
        HashMap<String, String> execPaths = new HashMap<String, String>();
        if (file == null) {
            throw new ResourceNotFoundException();
        }
        String fileAbsPath = file.getAbsPath();
        if (!fileAbsPath.isEmpty()) {
            if (!new File(fileAbsPath).exists()) throw new ResourceNotFoundException();
            String filePath = file.getAbsPath();
            if (!file.getName().equals(desc.name)) return new TASystem(desc, execPaths);
            execPaths.put(file.getName(), filePath);
            return new TASystem(desc, execPaths);
        } else {
            String cmdName = file.getRelPath();
            if (cmdName == null || cmdName.isEmpty()) return new TASystem(desc, execPaths);
            execPaths.put(file.getName(), cmdName);
        }
        return new TASystem(desc, execPaths);
    }

    public static String getValidationServiceExecutingPath() throws IOException {
        File pluginsFile;
        String executingPath = null;
        try {
            URL loc;
            CodeSource codeSource = TargetAccessDiscovery.class.getProtectionDomain().getCodeSource();
            if (codeSource != null && (loc = codeSource.getLocation()) != null) {
                executingPath = loc.getPath();
            }
        }
        catch (SecurityException e) {
            LOGGER.info(e.getMessage());
        }
        if (executingPath != null && (pluginsFile = new File(executingPath).getParentFile()) != null && (pluginsFile = pluginsFile.getParentFile()) != null) {
            File parentFile = pluginsFile.getParentFile();
            if (pluginsFile.getName().equals("plugins") && parentFile != null && parentFile.getName().equals("eclipse")) {
                executingPath = pluginsFile.getParent();
            }
        }
        if (executingPath != null) {
            try {
                executingPath = new File(executingPath).getCanonicalPath();
            }
            catch (IOException e) {
                executingPath = new File(executingPath).getAbsolutePath();
                LOGGER.info(e.getMessage());
            }
            return UtilsText.safeString((String)executingPath);
        }
        throw new IOException(UtilsText.safeString((String)Messages.TargetAccessDiscovery_6));
    }

    public static boolean reuseCommonTargetAccess() {
        String reuse = System.getProperty(REUSE_COMMON_SOFTWARE_PROPERTY);
        return reuse == null || !reuse.equals("false");
    }

    private static void trace(String message) {
        LOGGER.info(message);
    }

    public static boolean updateLinuxExecFlags(String gdbPath) {
        boolean errors = true;
        File gdbFile = new File(gdbPath);
        try {
            errors = !gdbFile.exists() || !gdbFile.setExecutable(true, false);
        }
        catch (SecurityException secEx) {
            LOGGER.severe(secEx.getMessage());
            errors = true;
        }
        if (errors) {
            TargetAccessDiscovery.trace(String.format(UtilsText.safeString((String)Messages.TargetAccessDiscovery_5), gdbPath));
        }
        return !errors;
    }

    public static boolean useStoredTargetAccess() {
        return "true".equals(System.getProperty(USE_CACHED_TARGET_ACCESS_PROVIDER_PROPERTY));
    }

    public static TADiscoveryResult verifyTASystem(ArrayList<ExecutableFile> execPaths) {
        for (ExecutableFile execFileElement : execPaths) {
            String execPath = execFileElement.getAbsPath();
            File execFile = new File(execPath);
            if (!execFile.exists()) {
                return new TADiscoveryResult(false, String.format(ERR_FILE_NOT_EXISTS, execPath));
            }
            if (!execFile.isFile()) {
                return new TADiscoveryResult(false, String.format(ERR_FILE_INVALID_PATH, execPath));
            }
            if (!execFile.canRead()) {
                boolean readable = false;
                try {
                    readable = execFile.setReadable(true);
                }
                catch (SecurityException se) {
                    readable = false;
                    LOGGER.info(se.getMessage());
                }
                if (readable) continue;
                return new TADiscoveryResult(false, String.format(ERR_FILE_NO_READ_ACCESS, execPath));
            }
            if (execFile.canExecute()) continue;
            if (OSDetect.isUnix()) {
                if (TargetAccessDiscovery.updateLinuxExecFlags(execPath)) continue;
                return new TADiscoveryResult(false, String.format(ERR_FILE_NO_EXEC_ACCESS, execPath));
            }
            return new TADiscoveryResult(false, String.format(ERR_FILE_NO_EXEC_ACCESS, execPath));
        }
        return new TADiscoveryResult(true, NO_ERROR);
    }

    private static /* synthetic */ String lambda$0(String string) {
        return "Could not find bundle for " + string + " when retrieving gdb executbale path";
    }

    public static class TADiscoveryResult {
        public final boolean success;
        public final String errMsg;
        @Nullable
        public final ArrayList<ExecutableFile> path;

        public TADiscoveryResult(ArrayList<ExecutableFile> _path) {
            this.success = true;
            this.errMsg = NO_ERROR;
            this.path = _path;
        }

        public TADiscoveryResult(boolean _success, String _errMsg) {
            this.success = _success;
            this.errMsg = _errMsg;
            this.path = null;
        }
    }
}

