/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.actions;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.connections.actions.GdbPyRunAction;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystem;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemDescriptor;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemInstance;
import com.nxp.swtools.mem.validation.connections.tasystem.TASystemLauncher;
import com.nxp.swtools.mem.validation.connections.tasystem.TargetAccessDiscovery;
import com.nxp.swtools.mem.validation.connections.tasystem.TargetAccessType;
import com.nxp.swtools.mem.validation.jobs.ResourceNotFoundException;
import com.nxp.swtools.provider.SWToolsPlatform;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;

public class SerialGdbPyRunAction
extends GdbPyRunAction {
    private static String pythonBinPath = "";
    private static final String PYTHONPATH = "PYTHONPATH";

    @Override
    protected TASystemInstance aquireSysInstance() throws IOException, ResourceNotFoundException {
        TASystemDescriptor targetAccessDescriptor = TargetAccessDiscovery.getDefaultDescriptor(TargetAccessType.GDB_PY);
        TASystem system = TargetAccessDiscovery.getTASystem(targetAccessDescriptor, TargetAccessDiscovery.getGdbExecPaths());
        return TASystemLauncher.getInstance().acquire(system, new HashMap<String, String>(), SerialGdbPyRunAction.getPythonEnv(targetAccessDescriptor));
    }

    public static Map<String, String> getPythonEnv(@Nullable TASystemDescriptor targetAccessDescriptor) {
        HashMap<String, String> pythonEnv = new HashMap<String, String>();
        if (SwToolsProduct.isUctProduct()) {
            StringJoiner result = new StringJoiner(";");
            if (SWToolsProperties.isTestOn()) {
                String userHome = PEConfiguration.getUserHomeDirectory();
                String productDir = String.valueOf(userHome) + File.separator + "resources" + File.separator;
                result.add(Paths.get(productDir, "python32").toString());
                if (OSDetect.isUnix()) {
                    result.add(Paths.get(productDir, "python32", "bin").toString());
                    result.add(Paths.get(productDir, "python32", "lib").toString());
                    pythonBinPath = Paths.get(productDir, "python32", "bin", "python").toString();
                } else if (OSDetect.isWindows()) {
                    result.add(Paths.get(productDir, "python32", "Lib").toString());
                    result.add(Paths.get(productDir, "python32", "Lib/site-packages").toString());
                    result.add(Paths.get(productDir, "python32", "DLLs").toString());
                    pythonBinPath = Paths.get(productDir, "python32", "python").toString();
                }
                pythonEnv.put(PYTHONPATH, result.toString());
                return pythonEnv;
            }
            try {
                if (SWToolsPlatform.isRunningInEclipseIde()) {
                    if (OSDetect.isWindows()) {
                        String msysDir = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution("${MSYS_LOC}", true);
                        String pythonLibs = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution("${S32DS_PYTHONPATH}", true);
                        msysDir = msysDir.replaceAll("msys32/usr", "msys32/mingw32");
                        msysDir = Paths.get(msysDir, new String[0]).normalize().toString();
                        result.add(msysDir);
                        if (targetAccessDescriptor != null && targetAccessDescriptor.type.equals((Object)TargetAccessType.GDB_PY)) {
                            result.add(Paths.get(Activator.getDefault().getConfigManager().getScriptsFolder(), "DLLs").toString());
                        }
                        result.add(Paths.get(msysDir, "../lib/python2.7/lib-dynload/").normalize().toString());
                        result.add(Paths.get(msysDir, "../lib/python2.7/").normalize().toString());
                        result.add(Paths.get(msysDir, "../lib/python2.7/site-packages").normalize().toString());
                        pythonBinPath = Paths.get(msysDir, "python2").toString();
                        String[] stringArray = pythonLibs.split(";");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String pythonPath = stringArray[n2];
                            result.add(Paths.get(pythonPath, new String[0]).normalize().toString());
                            ++n2;
                        }
                        pythonEnv.put(PYTHONPATH, result.toString());
                    }
                } else {
                    String productDir = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution("${eclipse_home}", true);
                    result.add(Paths.get(productDir, "python32").toString());
                    if (OSDetect.isUnix()) {
                        result.add(Paths.get(productDir, "python32", "bin").toString());
                        result.add(Paths.get(productDir, "python32", "lib").toString());
                        pythonBinPath = Paths.get(productDir, "python32", "bin", "python").toString();
                    } else if (OSDetect.isWindows()) {
                        result.add(Paths.get(productDir, "python32", "Lib").toString());
                        result.add(Paths.get(productDir, "python32", "Lib/site-packages").toString());
                        result.add(Paths.get(productDir, "python32", "DLLs").toString());
                        pythonBinPath = Paths.get(productDir, "python32", "python").toString();
                    }
                    pythonEnv.put(PYTHONPATH, result.toString());
                }
            }
            catch (CoreException coreException) {}
        }
        return pythonEnv;
    }

    public static String getPythonBinPath(@Nullable TASystemDescriptor targetAccessDescriptor) {
        if (pythonBinPath.equals("")) {
            SerialGdbPyRunAction.getPythonEnv(targetAccessDescriptor);
        }
        return pythonBinPath;
    }
}

