/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.codgen;

import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.provider.configuration.storage.ICustomCopyrightHeaderRead;
import com.nxp.swtools.utils.scripting.ScriptResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MemValSourcesContentProvider {
    private static List<String> skipFileTypesList = Arrays.asList(".html", ".htm");

    private MemValSourcesContentProvider() {
    }

    public static MemValSourcesContentProvider getInstance() {
        try {
            return (MemValSourcesContentProvider)SWTFactoryProxy.INSTANCE.getSingletonInstance(MemValSourcesContentProvider.class);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot obtain user-singleton instance of: " + MemValSourcesContentProvider.class.getSimpleName(), e);
        }
    }

    public Collection<@NonNull ISourceFile> getContent() {
        ScriptResult scriptResult = Activator.getDefault().getCgenManager().getScriptResult();
        ICustomCopyrightHeaderRead customCopyright = SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().getCustomCopyright();
        if (scriptResult != null && !scriptResult.containsAnyError()) {
            return SourceFileProviderFactory.buildSourceFileList(this.filterFilesByType(scriptResult.getOpenedFiles()), (ICustomCopyrightHeaderRead)customCopyright);
        }
        return SourceFileProviderFactory.buildSourceFileList(new HashMap(), (ICustomCopyrightHeaderRead)customCopyright);
    }

    public Map<String, String> filterFilesByType(Map<String, String> files) {
        return files.keySet().stream().filter(f -> !skipFileTypesList.stream().anyMatch(ext -> f.endsWith((String)ext))).collect(Collectors.toMap(f -> f, f -> Objects.requireNonNull((String)files.get(f)), (f1, f2) -> f1, LinkedHashMap::new));
    }
}

