/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.internal.registry.resource;

import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component
public class ResourceSdkRegistryImplementation
extends BaseRegistry
implements ResourceSdkRegistry {
    private final Map<String, Collection<ResourceSdkDescriptor>> resource2resourceSdkDescriptors = new HashMap<String, Collection<ResourceSdkDescriptor>>();
    private final Map<String, Collection<ResourceSdkDescriptor>> sdk2resourceSdkDescriptors = new HashMap<String, Collection<ResourceSdkDescriptor>>();

    @Override
    public List<ResourceSdkDescriptor> getResourceSdkDescriptorsByResourceId(String resourceId) {
        return this.getReferenceDescriptorsBySourceId(resourceId, this.resource2resourceSdkDescriptors, ResourceSdkDescriptor.class);
    }

    @Override
    public List<ResourceSdkDescriptor> getResourceSdkDescriptorsBySdkId(String sdkId) {
        return this.getReferenceDescriptorsByTargetId(sdkId, this.sdk2resourceSdkDescriptors, ResourceSdkDescriptor.class);
    }

    @Override
    public void addResourceSdkDescriptor(ResourceSdkDescriptor descriptor) {
        this.addReferenceDescriptor(descriptor, this.resource2resourceSdkDescriptors, this.sdk2resourceSdkDescriptors, ResourceSdkDescriptor.class);
    }

    @Override
    public void removeResourceSdkDescriptor(ResourceSdkDescriptor descriptor) {
        this.removeReferenceDescriptor(descriptor, this.resource2resourceSdkDescriptors, this.sdk2resourceSdkDescriptors, ResourceSdkDescriptor.class);
    }

    @Override
    public void removeResourceSdkDescriptorsBySdkId(String sdkId) {
        Collection<ResourceSdkDescriptor> collection = this.sdk2resourceSdkDescriptors.get(sdkId);
        if (collection != null) {
            ArrayList<ResourceSdkDescriptor> descriptors = new ArrayList<ResourceSdkDescriptor>(collection);
            descriptors.forEach(this::removeResourceSdkDescriptor);
            descriptors.clear();
        }
    }

    @Override
    public List<ResourceSdkDescriptor> getResourceSdkDescriptors() {
        ArrayList<ResourceSdkDescriptor> result = new ArrayList<ResourceSdkDescriptor>();
        this.resource2resourceSdkDescriptors.values().stream().flatMap(v -> v.stream()).forEach(result::add);
        return result;
    }
}

