/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.sdk.internal.registry.hardware;

import com.nxp.s32ds.cle.runtime.sdk.registry.hardware.DeviceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.hardware.DeviceSdkRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component
public class DeviceSdkRegistryImplementation
extends BaseRegistry
implements DeviceSdkRegistry {
    private final Map<String, Collection<DeviceSdkDescriptor>> device2deviceSDKDescriptors = new HashMap<String, Collection<DeviceSdkDescriptor>>();
    private final Map<String, Collection<DeviceSdkDescriptor>> sdk2deviceSDKDescriptors = new HashMap<String, Collection<DeviceSdkDescriptor>>();

    @Override
    public List<DeviceSdkDescriptor> getDeviceSdkDescriptorsByDeviceId(String deviceId) {
        return this.getReferenceDescriptorsBySourceId(deviceId, this.device2deviceSDKDescriptors, DeviceSdkDescriptor.class);
    }

    @Override
    public List<DeviceSdkDescriptor> getDeviceSdkDescriptorsBySdkId(String sdkId) {
        return this.getReferenceDescriptorsByTargetId(sdkId, this.sdk2deviceSDKDescriptors, DeviceSdkDescriptor.class);
    }

    @Override
    public void addDeviceSdkDescriptor(DeviceSdkDescriptor descriptor) {
        this.addReferenceDescriptor(descriptor, this.device2deviceSDKDescriptors, this.sdk2deviceSDKDescriptors, DeviceSdkDescriptor.class);
    }

    @Override
    public void removeDeviceSdkDescriptor(DeviceSdkDescriptor descriptor) {
        this.removeReferenceDescriptor(descriptor, this.device2deviceSDKDescriptors, this.sdk2deviceSDKDescriptors, DeviceSdkDescriptor.class);
    }

    @Override
    public List<DeviceSdkDescriptor> getDeviceSdkDescriptors() {
        ArrayList<DeviceSdkDescriptor> result = new ArrayList<DeviceSdkDescriptor>();
        this.device2deviceSDKDescriptors.values().stream().flatMap(v -> v.stream()).forEach(result::add);
        return result;
    }

    @Override
    public void removeDeviceSdkDescriptorsBySdkId(String sdkId) {
        Collection<DeviceSdkDescriptor> collection = this.sdk2deviceSDKDescriptors.get(sdkId);
        if (collection != null) {
            ArrayList<DeviceSdkDescriptor> descriptors = new ArrayList<DeviceSdkDescriptor>(collection);
            descriptors.forEach(this::removeDeviceSdkDescriptor);
            descriptors.clear();
        }
    }
}

