/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.views.queuelist;

import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.views.queuelist.Queue;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueData;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueType;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueWaitingTask;
import com.nxp.freertos.gdb.tad.model.views.queuelist.QueueWaitingTaskOperation;
import com.nxp.freertos.gdb.tad.strings.Separator;
import com.nxp.freertos.gdb.tad.strings.Texts;
import com.nxp.freertos.gdb.tad.view.column.TadColumnId;
import com.nxp.freertos.gdb.tad.view.items.TadItem;
import com.nxp.freertos.gdb.tad.view.items.TadTreeChildItem;
import com.nxp.freertos.gdb.tad.view.views.queuelist.QueueDataItem;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class QueueItem
extends TadItem {
    private Queue queue;
    private List<TadItem> treeChildren;
    private List<QueueDataItem> queueDataItems;
    private Map<QueueWaitingTaskOperation, QueueWaitingTask> queueWaitingTasks;

    public QueueItem(Queue queue, int index) {
        super(index);
        this.queue = queue;
        this.queueWaitingTasks = queue.getWaitingTasks();
        this.treeChildren = new LinkedList<TadItem>();
        if (queue.getHead() != 0L && queue.getTail() != 0L && queue.getReadFrom() != 0L && queue.getWriteTo() != 0L) {
            this.treeChildren.add(new TadTreeChildItem(this, 1, "Head", String.format("0x%08x", queue.getHead())));
            this.treeChildren.add(new TadTreeChildItem(this, 2, "Tail", String.format("0x%08x", queue.getTail())));
            this.treeChildren.add(new TadTreeChildItem(this, 3, "Read from", String.format("0x%08x", queue.getReadFrom())));
            this.treeChildren.add(new TadTreeChildItem(this, 4, "Write to", String.format("0x%08x", queue.getWriteTo())));
        }
        this.queueDataItems = new LinkedList<QueueDataItem>();
        if (queue.getData() != null) {
            for (QueueData item : queue.getData()) {
                if (!item.hasData()) continue;
                this.queueDataItems.add(new QueueDataItem(item));
            }
        }
    }

    @Override
    public List<? extends TadItem> getTreeChildren() {
        return this.treeChildren;
    }

    @Override
    public List<? extends TadItem> getChildItems() {
        return this.queueDataItems;
    }

    @Override
    public int getTextColour() {
        if (this.queue.getCurrentLength() == this.queue.getMaxLength() && this.queue.getType() != QueueType.MUTEX) {
            return 4;
        }
        return super.getTextColour();
    }

    @Override
    public String toString(Separator separator) {
        return super.toString(new TadColumnId[]{TadColumnId.ID, TadColumnId.NAME, TadColumnId.ADDRESS, TadColumnId.LENGTH, TadColumnId.SIZE, TadColumnId.TX_WAITING, TadColumnId.RX_WAITING, TadColumnId.TYPE}, separator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getText(TadColumnId column) {
        try {
            switch (column) {
                case ID: {
                    return String.format("%d", this.index);
                }
                case NAME: {
                    String string;
                    if (this.queue.getName() != null) {
                        string = this.queue.getName();
                        return string;
                    }
                    string = Texts.get("Error.Unknown");
                    return string;
                }
                case ADDRESS: {
                    return String.format("0x%08x", this.queue.getAddress());
                }
                case LENGTH: {
                    return String.format("%d/%d", this.queue.getCurrentLength(), this.queue.getMaxLength());
                }
                case SIZE: {
                    if (this.queue.getDataItemSize() == 0) {
                        return Texts.get("Error.Empty");
                    }
                    return String.format("0x%x (%s)", this.queue.getDataItemSize(), QueueItem.formatBytes(this.queue.getDataItemSize()));
                }
                case TX_WAITING: {
                    if (!this.queueWaitingTasks.containsKey((Object)QueueWaitingTaskOperation.TX)) return "0";
                    return String.format("%d", this.queueWaitingTasks.get((Object)QueueWaitingTaskOperation.TX).getCount());
                }
                case RX_WAITING: {
                    if (!this.queueWaitingTasks.containsKey((Object)QueueWaitingTaskOperation.RX)) return "0";
                    return String.format("%d", this.queueWaitingTasks.get((Object)QueueWaitingTaskOperation.RX).getCount());
                }
                case TYPE: {
                    if (this.queue.getType() == null) return null;
                    String string = this.queue.getType().toString();
                    return string;
                }
            }
            return null;
        }
        catch (NullPointerException e) {
            Logger.exception(e, String.format(Texts.get("Exception.WhileGetTextColumn"), column.toString()));
            return null;
        }
    }

    @Override
    public Long getNumValue(TadColumnId column) {
        switch (column) {
            case ADDRESS: {
                return this.queue.getAddress();
            }
            case LENGTH: {
                return this.queue.getCurrentLength();
            }
            case SIZE: {
                return this.queue.getDataItemSize();
            }
        }
        return null;
    }
}

