/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.views.queuelist;

import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.Auxiliary;
import com.nxp.freertos.gdb.tad.strings.Separator;
import com.nxp.freertos.gdb.tad.view.column.TadColumnId;
import com.nxp.freertos.gdb.tad.view.items.TadItem;

public class QueueDataTreeChildItem
extends TadItem {
    private long address;
    private long data;
    private TadItem parent;

    public QueueDataTreeChildItem(TadItem parent, long address, long data) {
        super(1);
        this.parent = parent;
        this.address = address;
        this.data = data;
    }

    @Override
    public TadItem getParent() {
        return this.parent;
    }

    @Override
    public String toString(Separator separator) {
        return super.toString(new TadColumnId[]{TadColumnId.ADDRESS, TadColumnId.DATA_BYTES, TadColumnId.DATA_HEX, TadColumnId.DATA_BIN, TadColumnId.DATA_TEXT}, separator);
    }

    @Override
    public String getText(TadColumnId column) {
        try {
            switch (column) {
                case ADDRESS: {
                    return String.format("0x%08x", this.address);
                }
                case DATA_BYTES: {
                    return String.format("%d", this.data);
                }
                case DATA_HEX: {
                    return String.format("0x%08x", this.data);
                }
                case DATA_BIN: {
                    return String.format("%32s", Long.toBinaryString(this.data)).replace(' ', '0');
                }
                case DATA_TEXT: {
                    return Auxiliary.toASCII(this.data);
                }
            }
            return null;
        }
        catch (NullPointerException e) {
            Logger.exception(e);
            return null;
        }
    }

    @Override
    public Long getNumValue(TadColumnId column) {
        switch (column) {
            case ADDRESS: {
                return this.address;
            }
            case DATA_BYTES: 
            case DATA_HEX: 
            case DATA_BIN: 
            case DATA_TEXT: {
                return this.data;
            }
        }
        return null;
    }
}

