/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.view.views.heapusage;

import com.nxp.freertos.gdb.tad.model.Auxiliary;
import com.nxp.freertos.gdb.tad.model.views.heapusage.HeapBlock;
import com.nxp.freertos.gdb.tad.model.views.heapusage.HeapBlockStatus;
import com.nxp.freertos.gdb.tad.model.views.heapusage.HeapRegion;
import com.nxp.freertos.gdb.tad.strings.Texts;
import com.nxp.freertos.gdb.tad.view.providers.TadBarGraphProvider;
import com.nxp.freertos.gdb.tad.view.views.heapusage.Heap5TreeChildItem;
import com.nxp.freertos.gdb.tad.view.views.heapusage.HeapItem;
import java.util.List;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

class HeapUsageGraphLabelProvider
extends TadBarGraphProvider {
    HeapUsageGraphLabelProvider() {
    }

    protected void paint(Event event, Object element) {
        HeapRegion region;
        if (element == null) {
            return;
        }
        if (element instanceof Heap5TreeChildItem) {
            region = ((Heap5TreeChildItem)element).getRegion();
        } else if (element instanceof HeapItem) {
            region = ((HeapItem)element).getHeap();
        } else {
            return;
        }
        long size = region.getSize();
        Long used = region.getUsed();
        long free = region.getFree();
        List<HeapBlock> blocks = region.getHeapBlocks();
        if (used == null && free == 0L) {
            return;
        }
        GC gc = event.gc;
        int fullHeight = event.height - 1;
        int fullWidth = ((TreeViewerColumn)this.getColumn()).getColumn().getWidth() - 1;
        Color oldColour = gc.getBackground();
        if (size > 0L) {
            if (!blocks.isEmpty()) {
                double barWidth = 0.0;
                for (HeapBlock block : blocks) {
                    double percentage = Auxiliary.getPercentage(block.getSize(), size);
                    double width = (double)fullWidth * (percentage / 100.0);
                    if (!(width > 0.0)) continue;
                    gc.setBackground(block.getStatus() == HeapBlockStatus.FREE ? Auxiliary.GREEN_COLOUR : Auxiliary.RED_COLOUR);
                    gc.fillRectangle((int)Math.ceil(barWidth) + event.x, event.y, (int)Math.ceil(width), fullHeight);
                    barWidth += width;
                }
            } else {
                double percentage = Auxiliary.getPercentage(used, size);
                int width = (int)Math.ceil((double)fullWidth * (percentage / 100.0));
                gc.setBackground(Auxiliary.RED_COLOUR);
                gc.fillRectangle(event.x, event.y, width, fullHeight);
                gc.setBackground(Auxiliary.GREEN_COLOUR);
                gc.fillRectangle(width + event.x, event.y, fullWidth - width, fullHeight);
            }
        }
        gc.setForeground(Auxiliary.WHITE_COLOUR);
        gc.setFont(Display.getDefault().getSystemFont());
        String percentageString = String.format("%.2f%% " + Texts.get("Info.Used"), Auxiliary.getPercentage(used, size));
        gc.drawString(percentageString, event.x + fullWidth / 2 - gc.textExtent((String)percentageString).x / 2, event.y, true);
        gc.setBackground(oldColour);
    }
}

