/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.model;

import com.nxp.freertos.gdb.tad.Activator;
import com.nxp.freertos.gdb.tad.benchmark.Benchmark;
import com.nxp.freertos.gdb.tad.controller.TadFactory;
import com.nxp.freertos.gdb.tad.controller.TadFactoryData;
import com.nxp.freertos.gdb.tad.controller.TadFactoryDataStatus;
import com.nxp.freertos.gdb.tad.controller.heapusage.HeapFactory;
import com.nxp.freertos.gdb.tad.controller.queuelist.QueueFactory;
import com.nxp.freertos.gdb.tad.controller.tasklist.TaskFactory;
import com.nxp.freertos.gdb.tad.controller.timerlist.TimerFactory;
import com.nxp.freertos.gdb.tad.logger.Logger;
import com.nxp.freertos.gdb.tad.model.DataRequest;
import com.nxp.freertos.gdb.tad.model.IDataListener;
import com.nxp.freertos.gdb.tad.model.ITadModelListener;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOS;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOSAvailability;
import com.nxp.freertos.gdb.tad.model.freertos.FreeRTOSConfig;
import com.nxp.freertos.gdb.tad.model.readers.MemoryReader;
import com.nxp.freertos.gdb.tad.model.readers.VariableReader;
import com.nxp.freertos.gdb.tad.model.state.DMEvent;
import com.nxp.freertos.gdb.tad.model.state.TadState;
import com.nxp.freertos.gdb.tad.model.views.TadDataCache;
import com.nxp.freertos.gdb.tad.model.views.heapusage.HeapType;
import com.nxp.freertos.gdb.tad.strings.Texts;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.osgi.framework.Version;

public class TadModel
implements DsfSession.SessionStartedListener,
DsfSession.SessionEndedListener {
    public static final String TASK_LIST = "Task List";
    public static final String STACK_USAGE = "Stack Usage";
    public static final String QUEUE_LIST = "Queue List";
    public static final String TIMER_LIST = "Timer List";
    public static final String HEAP_USAGE = "Heap Usage";
    public static final Image WARNING_BIG_IMG = Activator.createImageDesc("warning_bigger.gif").createImage();
    public static final Image WARNING_IMG = Activator.createImageDesc("warning.gif").createImage();
    public static final Image ERROR_IMG = Activator.createImageDesc("error.gif").createImage();
    public static final Image NXP_LOGO_IMG = Activator.createImageDesc("nxp_big.png").createImage();
    public static final ImageDescriptor INFORMATION_IMG_DESC = Activator.createImageDesc("information.gif");
    public static final ImageDescriptor SAVE_IMG_DESC = Activator.createImageDesc("save.gif");
    public static final ImageDescriptor NXP_IMG_DESC = Activator.createImageDesc("nxp.gif");
    private static final DataRequest POISON_DATA_REQUEST = new DataRequest(0){

        @Override
        public void execute() {
        }
    };
    private BlockingQueue<DataRequest> requestQueue;
    private List<ITadModelListener> listeners;
    private Map<String, TadFactory> factories;
    private FreeRTOS freeRTOS;
    private TadState tadState;
    private TadDataCache dataCache;
    private Thread workerThread;
    private AtomicInteger ticket = new AtomicInteger(1);
    private MessageConsole tadConsole;
    private final VariableReader variableReader;
    private final MemoryReader memoryReader;

    public TadModel() {
        this.dataCache = new TadDataCache();
        this.variableReader = new VariableReader();
        this.memoryReader = new MemoryReader();
        this.freeRTOS = new FreeRTOS();
        this.factories = new HashMap<String, TadFactory>();
        this.factories.put(TASK_LIST, new TaskFactory(this.memoryReader, this.variableReader, this.freeRTOS, this.dataCache));
        this.factories.put(QUEUE_LIST, new QueueFactory(this.memoryReader, this.variableReader, this.freeRTOS));
        this.factories.put(TIMER_LIST, new TimerFactory(this.memoryReader, this.variableReader, this.freeRTOS));
        this.factories.put(HEAP_USAGE, new HeapFactory(this.memoryReader, this.variableReader, this.freeRTOS, this.dataCache));
        this.requestQueue = new LinkedBlockingQueue<DataRequest>();
        this.listeners = new LinkedList<ITadModelListener>();
        this.tadState = new TadState();
        DsfSession.addSessionStartedListener((DsfSession.SessionStartedListener)this);
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)this);
        this.tadConsole = new MessageConsole(String.format(Texts.get("Log.TadConsole"), Activator.getVersionAsString()), NXP_IMG_DESC);
        Logger.clear();
    }

    public synchronized void requestViewData(final IDataListener listener, final String viewName) {
        DataRequest req = new DataRequest(this.ticket.get()){

            @Override
            public void execute() {
                if (TadModel.this.freeRTOS.getAvailability() == FreeRTOSAvailability.UNKNOWN) {
                    FreeRTOSAvailability availability = TadModel.this.isFreeRTOSAvailable();
                    if (availability == FreeRTOSAvailability.AVAILABLE) {
                        Benchmark.start("Determine FreeRTOS version");
                        TadModel.this.freeRTOS.initStructs(TadModel.this.getFreeRTOSVersion());
                        Benchmark.stopAndLog("Determine FreeRTOS version");
                    }
                    TadModel.this.freeRTOS.setAvailability(availability);
                }
                if (TadModel.this.freeRTOS.getAvailability() != FreeRTOSAvailability.AVAILABLE) {
                    listener.dataEmpty(new TadFactoryData(null, TadFactoryDataStatus.INFORMATION, String.format(Texts.get("Info.FreeRTOSNotUsed"), viewName)));
                    return;
                }
                if (!TadModel.this.isTadReady()) {
                    listener.dataCorrupted();
                    Logger.error(String.format(Texts.get("Error.DataRequestFailed"), viewName));
                    return;
                }
                try {
                    if (TadModel.this.factories.containsKey(viewName)) {
                        TadFactoryData data;
                        Benchmark.start(viewName);
                        TadFactory factory = TadModel.this.factories.get(viewName);
                        if (viewName.equals(TadModel.TASK_LIST) && !TadModel.this.dataCache.isViewDataReady(TadModel.QUEUE_LIST)) {
                            TadModel.this.dataCache.setViewData(TadModel.QUEUE_LIST, TadModel.this.factories.get(TadModel.QUEUE_LIST).getData());
                        }
                        if (viewName.equals(TadModel.HEAP_USAGE) && !TadModel.this.dataCache.isViewDataReady(TadModel.HEAP_USAGE) && TadModel.this.freeRTOS.getHeapType() != HeapType.HEAP_1 && TadModel.this.freeRTOS.getHeapType() != HeapType.HEAP_3) {
                            if (!TadModel.this.dataCache.isViewDataReady(TadModel.QUEUE_LIST)) {
                                TadModel.this.dataCache.setViewData(TadModel.QUEUE_LIST, TadModel.this.factories.get(TadModel.QUEUE_LIST).getData());
                            }
                            if (!TadModel.this.dataCache.isViewDataReady(TadModel.TASK_LIST)) {
                                TadModel.this.dataCache.setViewData(TadModel.TASK_LIST, TadModel.this.factories.get(TadModel.TASK_LIST).getData());
                            }
                        }
                        if ((data = TadModel.this.dataCache.getViewData(viewName)) == null) {
                            data = factory.getData();
                        }
                        Benchmark.stopAndLog(viewName);
                        if (this.isTicketValid(TadModel.this.ticket.get())) {
                            if (data.isValid()) {
                                listener.dataReady(data);
                            } else {
                                if (!data.hasMessage()) {
                                    data.setStatus(TadFactoryDataStatus.INFORMATION);
                                    data.setMessage(String.format(Texts.get("Info.ViewDataEmpty"), viewName));
                                }
                                listener.dataEmpty(data);
                            }
                            TadModel.this.dataCache.setViewData(viewName, data);
                        } else {
                            listener.dataCorrupted();
                        }
                    } else {
                        Logger.error(String.format(Texts.get("Error.FactoryNotFound"), viewName));
                        listener.dataCorrupted();
                    }
                }
                catch (NullPointerException e) {
                    Logger.exception(e, String.format(Texts.get("Exception.WhileDataLoad"), viewName));
                    listener.dataCorrupted();
                }
            }
        };
        try {
            this.requestQueue.put(req);
        }
        catch (InterruptedException e) {
            listener.dataCorrupted();
            Logger.exception(e);
        }
    }

    private synchronized FreeRTOSAvailability isFreeRTOSAvailable() {
        String readyTasksListsSize = this.variableReader.getSize("pxReadyTasksLists");
        if (TadFactory.isTextValid(readyTasksListsSize)) {
            try {
                if (Long.decode(readyTasksListsSize) > 0L) {
                    return FreeRTOSAvailability.AVAILABLE;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return FreeRTOSAvailability.NOT_USED;
            }
        }
        return FreeRTOSAvailability.NOT_USED;
    }

    private synchronized Version getFreeRTOSVersion() {
        Version version = new Version(0, 0, 0);
        String text = this.variableReader.getAddressOfVariable("FreeRTOSDebugConfig");
        if (TadFactory.isTextValid(text)) {
            try {
                Long address = Long.decode(text);
                List<Integer> debugConfigStruct = this.memoryReader.getMemoryBlock(address, 8L);
                if (debugConfigStruct != null) {
                    int typeNum = debugConfigStruct.get(5);
                    if (typeNum < HeapType.values().length) {
                        HeapType type = HeapType.valueOf(typeNum);
                        this.freeRTOS.setHeapType(type);
                        this.freeRTOS.enableMacro(FreeRTOSConfig.MEMORY_SCHEME, true);
                        Logger.info(String.format(Texts.get("Info.HeapIdentifiedFrom"), "FreeRTOSDebugConfig structure", type.toString()));
                    }
                    int major = debugConfigStruct.get(2);
                    int minor = debugConfigStruct.get(3);
                    int build = debugConfigStruct.get(4);
                    version = new Version(major, minor, build);
                    Logger.info(String.format(Texts.get("Info.VersionIdentifiedFrom"), "FreeRTOSDebugConfig structure", version.toString()));
                    return version;
                }
            }
            catch (NumberFormatException | DebugException throwable) {}
        }
        String versionMajor = this.variableReader.getVariable("tskKERNEL_VERSION_MAJOR");
        String versionMinor = this.variableReader.getVariable("tskKERNEL_VERSION_MINOR");
        String versionBuild = this.variableReader.getVariable("tskKERNEL_VERSION_BUILD");
        if (TadFactory.isTextValid(versionMajor) && TadFactory.isTextValid(versionMinor) && TadFactory.isTextValid(versionBuild)) {
            version = new Version(Integer.parseInt(versionMajor), Integer.parseInt(versionMinor), Integer.parseInt(versionBuild));
            return version;
        }
        String size = this.variableReader.getStructSize("TaskControlBlock_t");
        if (TadFactory.isTextValid(size)) {
            try {
                if (Integer.decode(size) > 0) {
                    version = FreeRTOS.FREERTOS_VERSION_10_1_0;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.freeRTOS.initStructs(version);
            String pcTail = this.variableReader.getOffset(this.freeRTOS.getStruct("queue"), "pcTail");
            version = TadFactory.isTextValid(pcTail) ? new Version(10, 0, 0) : new Version(10, 1, 1);
        }
        Logger.info(String.format(Texts.get("Info.VersionIdentifiedFrom"), "available FreeRTOS symbols", version.toString()));
        return version;
    }

    public boolean isTadReady() {
        return this.tadState.isReady();
    }

    public TadDataCache getDataCache() {
        return this.dataCache;
    }

    public MessageConsole getTadConsole() {
        return this.tadConsole;
    }

    public FreeRTOS getFreeRTOS() {
        return this.freeRTOS;
    }

    public void addListener(ITadModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ITadModelListener listener) {
        this.listeners.remove(listener);
    }

    private void startWorkerThread() {
        this.workerThread = new Thread(){

            @Override
            public void run() {
                while (TadModel.this.tadState.isDebugRunning()) {
                    try {
                        DataRequest request = TadModel.this.requestQueue.take();
                        if (request == POISON_DATA_REQUEST || !TadModel.this.tadState.isDebugRunning()) break;
                        if (!request.isTicketValid(TadModel.this.ticket.get())) continue;
                        request.execute();
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
        };
        this.workerThread.start();
    }

    private void stopWorkerThread() {
        try {
            this.requestQueue.put(POISON_DATA_REQUEST);
        }
        catch (InterruptedException e) {
            Logger.exception(e, Texts.get("Exception.CouldNotStopWorkerThread"));
        }
    }

    private void increaseTicket() {
        this.ticket.incrementAndGet();
    }

    public void sessionStarted(DsfSession session) {
        session.addServiceEventListener((Object)this, null);
        this.increaseTicket();
        this.dataCache.clear();
        this.tadState.debugStarted(true);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.tadConsole});
        this.freeRTOS.init();
        this.requestQueue.clear();
        this.startWorkerThread();
        for (ITadModelListener l : this.listeners) {
            l.debuggerSessionCreated();
        }
        Logger.info(String.format(Texts.get("Info.DSFStarted"), session.getId()));
    }

    public void sessionEnded(DsfSession session) {
        Logger.info(String.format(Texts.get("Info.DSFEnded"), session.getId()));
        session.removeServiceEventListener((Object)this);
        this.increaseTicket();
        this.dataCache.clear();
        this.tadState.debugStarted(false);
        this.stopWorkerThread();
        for (ITadModelListener l : this.listeners) {
            l.debuggerTerminated();
        }
        Logger.saveLogFile();
        Logger.clear();
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.ISuspendedDMEvent event) {
        this.increaseTicket();
        this.dataCache.clear();
        this.setContextInFactories((IRunControl.IExecutionDMContext)event.getDMContext());
        this.tadState.shiftState(DMEvent.SUSPENDED, event.getReason());
        if (this.isTadReady()) {
            this.variableReader.init();
            for (ITadModelListener l : this.listeners) {
                l.debuggerSuspended();
            }
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IResumedDMEvent event) {
        this.increaseTicket();
        this.dataCache.clear();
        this.tadState.shiftState(DMEvent.RESUMED, event.getReason());
        for (ITadModelListener l : this.listeners) {
            l.debuggerResumed();
        }
    }

    private void setContextInFactories(IRunControl.IExecutionDMContext context) {
        for (TadFactory factory : this.factories.values()) {
            factory.setContext(context);
        }
    }
}

